/*
 * Decompiled with CFR 0.152.
 */
package com.github.yegorbabarykin.spring.mvc.logger;

import com.github.yegorbabarykin.spring.mvc.logger.ResettableRequestServletWrapper;
import com.github.yegorbabarykin.spring.mvc.logger.WrappedHttpServletResponse;
import com.github.yegorbabarykin.spring.mvc.logger.common.OptionalCollection;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RequestLoggingInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(RequestLoggingInterceptor.class);

    public boolean preHandle(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler) throws Exception {
        Map headers = Collections.list(servletRequest.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)servletRequest).getHeader(arg_0)));
        String requestLog = String.join((CharSequence)System.lineSeparator(), "Inbound Request:", "URI: " + servletRequest.getRequestURI() + "?" + servletRequest.getQueryString(), "Headers: " + headers, "Payload: " + this.getPayload(servletRequest));
        if (log.isInfoEnabled()) {
            log.info("{}", (Object)requestLog);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (response instanceof WrappedHttpServletResponse && log.isInfoEnabled()) {
            log.info("{}", (Object)this.getMessage((WrappedHttpServletResponse)response));
        }
    }

    private String getMessage(WrappedHttpServletResponse response) {
        Map headers = OptionalCollection.streamOf(response.getHeaderNames()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WrappedHttpServletResponse)response).getHeader(arg_0)));
        return String.join((CharSequence)System.lineSeparator(), "Outbound Response:", "Status: " + response.getStatus(), "Headers: " + headers, "Payload: " + new String(response.getCopy()));
    }

    private String getPayload(HttpServletRequest request) throws IOException {
        if (request instanceof ResettableRequestServletWrapper) {
            ResettableRequestServletWrapper resettableRequest = (ResettableRequestServletWrapper)request;
            String requestBody = IOUtils.toString((Reader)resettableRequest.getReader());
            resettableRequest.resetInputStream();
            return requestBody.substring(0, Math.min(16384, requestBody.length()));
        }
        return "[]";
    }
}

