package cn.xys.maven;

import cn.xuxiaobu.doc.AbstractJavaProcessSynopsis;
import cn.xuxiaobu.doc.MavenJavaProcessSynopsis;
import cn.xuxiaobu.doc.config.JavaConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.resolvers.ResolveDependenciesMojo;
import org.apache.maven.plugins.dependency.utils.DependencyStatusSets;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Goal which touches a timestamp file.
 *
 * @author xuyuansheng
 */
@Mojo(name = "rest-api", defaultPhase = LifecyclePhase.PACKAGE, requiresDependencyResolution = ResolutionScope.TEST, threadSafe = true)
public class MyMojo extends ResolveDependenciesMojo {

    private static final String SOURCE_CLASSIFIER = "sources";

    @Override
    protected void doExecute() throws MojoExecutionException {

        MavenProject project = getProject();
        String javaSource = project.getBuild().getSourceDirectory();
        String classSource = project.getBuild().getOutputDirectory();
        String targetApis = project.getBuild().getDirectory() + File.separator + "xbApis";

        List<String> classDependencySource = getDependency(true);
        List<String> javaDependencySource = classDependencySource.stream().map(de -> StringUtils.replace(de, ".jar", "-sources.jar"))
                .filter(sourceDe -> Paths.get(sourceDe).toFile().exists()).collect(Collectors.toList());
        JavaConfig javaConfig = new JavaConfig(javaSource, classSource, javaDependencySource, classDependencySource).setOutPutDir(targetApis);
        AbstractJavaProcessSynopsis javaProcessSynopsis = new MavenJavaProcessSynopsis(javaConfig);
        javaProcessSynopsis.buildDoc();
        getLog().info(javaDependencySource.toString());

    }

    public List<String> getDependency(Boolean ifClasses) throws MojoExecutionException {
        this.classifier = ifClasses ? "" : SOURCE_CLASSIFIER;
        DependencyStatusSets dss = getDependencySets(false, false);
        Set<Artifact> artifacts = dss.getResolvedDependencies();
        return artifacts.stream().map(k -> k.getFile().getAbsolutePath()).collect(Collectors.toList());
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }
}
