/*
 * Decompiled with CFR 0.152.
 */
package warning_diff;

import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import metaconfig.Conf;
import metaconfig.Conf$;
import metaconfig.Hocon$;
import metaconfig.MetaconfigParser;
import sbt.io.IO$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.meta.Source;
import scala.meta.Tree;
import scala.meta.dialects.package$;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.parsers.Parse;
import scala.meta.parsers.Parse$;
import scala.runtime.BoxesRunTime;
import scalafix.internal.patch.PatchInternals$;
import scalafix.internal.v1.Rules$;
import scalafix.lint.LintSeverity;
import scalafix.lint.RuleDiagnostic;
import scalafix.v1.Configuration$;
import scalafix.v1.Rule;
import scalafix.v1.SyntacticDocument;
import scalafix.v1.SyntacticDocument$;
import scalafix.v1.SyntacticRule;
import sjsonnew.BasicJsonProtocol$;
import sjsonnew.JsonReader;
import sjsonnew.JsonWriter;
import sjsonnew.Unbuilder;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.Converter$;
import sjsonnew.support.scalajson.unsafe.Parser$;
import warning_diff.Dialect;
import warning_diff.FixInput;
import warning_diff.FixInput$;
import warning_diff.FixOutput;
import warning_diff.FixOutput$;
import warning_diff.JsonClassOps$;
import warning_diff.Pos;
import warning_diff.ScalafixWarning;
import warning_diff.Warning;

public final class ScalafixWarning$ {
    public static final ScalafixWarning$ MODULE$ = new ScalafixWarning$();

    public void main(String[] args) {
        try {
            this.run();
        }
        catch (LinkageError e) {
            throw new RuntimeException(e);
        }
    }

    private void run() {
        Unbuilder unbuilder = new Unbuilder(Converter$.MODULE$.facade());
        JValue json = (JValue)Parser$.MODULE$.parseFromFile(new File("input.json")).get();
        FixInput in = (FixInput)((JsonReader)Predef$.MODULE$.implicitly((Object)FixInput$.MODULE$.instance())).read((Option)new Some((Object)json), unbuilder);
        File base = new File(in.base());
        Seq result = (Seq)in.projects().map((Function1 & Serializable)proj -> {
            Set confRules = CollectionConverters$.MODULE$.ListHasAsScala(ConfigFactory.parseString((String)proj.scalafixConfig()).getStringList("rules")).asScala().toSet();
            List allRules = Rules$.MODULE$.all();
            List runRules = allRules.collect((PartialFunction)new Serializable(confRules, (FixInput.SubProject)proj){
                private static final long serialVersionUID = 0L;
                private final Set confRules$1;
                private final FixInput.SubProject proj$1;

                public final <A1 extends Rule, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (this.confRules$1.apply((Object)A1.name().value())) {
                        return (B1)A1.withConfiguration(Configuration$.MODULE$.apply().withConf((Conf)Conf$.MODULE$.parseString(this.proj$1.scalafixConfig(), (MetaconfigParser)Hocon$.MODULE$).get()).withScalacOptions(this.proj$1.scalacOptions().toList()).withScalaVersion(this.proj$1.scalaVersion())).get();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Rule x1) {
                    Rule rule = x1;
                    return this.confRules$1.apply((Object)rule.name().value());
                }
                {
                    this.confRules$1 = confRules$1;
                    this.proj$1 = proj$1;
                }
            }).collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Rule, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof SyntacticRule) {
                        SyntacticRule syntacticRule = (SyntacticRule)A1;
                        return (B1)syntacticRule;
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Rule x2) {
                    Rule rule = x2;
                    return rule instanceof SyntacticRule;
                }
            });
            Seq sourceFileNames = proj.sources();
            Seq diagnostics = (Seq)sourceFileNames.flatMap((Function1 & Serializable)sourceFileName -> {
                String src = IO$.MODULE$.read(new File((String)sourceFileName), IO$.MODULE$.read$default$2());
                Input.VirtualFile input = new Input.VirtualFile(new StringBuilder(8).append("${BASE}/").append(IO$.MODULE$.relativize(base, new File((String)sourceFileName)).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(1).append(base).append(" ").append((String)sourceFileName).toString()))).toString(), src);
                Parse parse = (Parse)Predef$.MODULE$.implicitly((Object)Parse$.MODULE$.parseSource());
                Source tree = (Source)parse.apply((Input)input, MODULE$.convertDialect(proj.dialect())).get();
                SyntacticDocument doc = SyntacticDocument$.MODULE$.fromTree((Tree)tree);
                Map map = runRules.map((Function1 & Serializable)rule -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rule.name()), (Object)rule.fix(doc))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                return PatchInternals$.MODULE$.syntactic(map, doc, false).diagnostics().map((Function1 & Serializable)x -> new ScalafixWarning.Result(input, (RuleDiagnostic)x));
            });
            return new FixOutput(proj.projectId(), proj.sbtConfig(), (Seq)diagnostics.map((Function1 & Serializable)x -> {
                None$ none$;
                String string = new StringBuilder(3).append("[").append(x.diagnostic().id().fullID()).append("] ").append(x.diagnostic().message()).toString();
                Pos pos = MODULE$.convertPosition(x.input(), x.diagnostic().position());
                LintSeverity lintSeverity = x.diagnostic().severity();
                if (LintSeverity.Warning$.MODULE$.equals(lintSeverity)) {
                    none$ = None$.MODULE$;
                } else if (LintSeverity.Info$.MODULE$.equals(lintSeverity)) {
                    none$ = new Some((Object)"INFO");
                } else if (LintSeverity.Error$.MODULE$.equals(lintSeverity)) {
                    none$ = new Some((Object)"ERROR");
                } else {
                    throw new MatchError((Object)lintSeverity);
                }
                return new Warning(string, pos, (Option)none$);
            }));
        });
        IO$.MODULE$.write(new File(in.output()), JsonClassOps$.MODULE$.toJsonString$extension(JsonClassOps$.MODULE$.toJsonClassOps((Object)result), (JsonWriter)BasicJsonProtocol$.MODULE$.immSeqFormat(FixOutput$.MODULE$.instance())), IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
    }

    private Pos convertPosition(Input.VirtualFile input, Position p) {
        return new Pos((Option)new Some((Object)BoxesRunTime.boxToInteger((int)(p.startLine() + 1))), (String)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(input.value())).drop(p.startLine()).next(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)input.path()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)(p.startLine() + 1))), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)p.startColumn())), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)(p.endLine() + 1))), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)p.endColumn())));
    }

    private scala.meta.Dialect convertDialect(Dialect x) {
        Dialect dialect = x;
        if (Dialect.Scala210$.MODULE$.equals(dialect)) {
            return package$.MODULE$.Scala210();
        }
        if (Dialect.Scala211$.MODULE$.equals(dialect)) {
            return package$.MODULE$.Scala211();
        }
        if (Dialect.Scala212$.MODULE$.equals(dialect)) {
            return package$.MODULE$.Scala212();
        }
        if (Dialect.Scala213$.MODULE$.equals(dialect)) {
            return package$.MODULE$.Scala213();
        }
        if (Dialect.Scala212Source3$.MODULE$.equals(dialect)) {
            return package$.MODULE$.Scala212Source3();
        }
        if (Dialect.Scala213Source3$.MODULE$.equals(dialect)) {
            return package$.MODULE$.Scala213Source3();
        }
        if (Dialect.Scala3$.MODULE$.equals(dialect)) {
            return package$.MODULE$.Scala3();
        }
        throw new MatchError((Object)dialect);
    }

    private ScalafixWarning$() {
    }
}

