/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import msgpack4z.Code$;
import msgpack4z.MsgOutBuffer$;
import msgpack4z.MsgPacker;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0012%\u0005\u001dB\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006w\u0001!I\u0001\u0010\u0005\u0006\u007f\u0001!\t\u0005\u0011\u0005\u0007\u000f\u0002!\t\u0001\n%\t\rM\u0003\u0001\u0015\"\u0003U\u0011\u0019A\u0006\u0001)C\u00053\"1q\f\u0001Q\u0005\n\u0001Da!\u001a\u0001\u0005\u0002\u00112\u0007B\u00026\u0001\t\u0003!3\u000e\u0003\u0004o\u0001\u0001&Ia\u001c\u0005\u0007m\u0002\u0001K\u0011B<\t\u000by\u0004A\u0011I@\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0003bBA'\u0001\u0011\u0005\u00131\b\u0005\b\u0003\u001f\u0002A\u0011IA\u001e\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!a\u0016\u0001\t\u0003\nI\u0006\u0003\u0005\u0002f\u0001\u0001K\u0011BA4\u0011\u001d\ti\u0007\u0001C!\u0003_Bq!a#\u0001\t\u0003\nY\u0004C\u0004\u0002\u000e\u0002!\t%a$\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\u001e9\u0011q\u0014\u0013\t\u0002\u0005\u0005fAB\u0012%\u0011\u0003\t\u0019\u000b\u0003\u0004<A\u0011\u0005\u0011Q\u0015\u0005\b\u0003O\u0003C\u0011AAU\u00051i5oZ(vi\n+hMZ3s\u0015\u0005)\u0013!C7tOB\f7m\u001b\u001b{\u0007\u0001\u00192\u0001\u0001\u0015/!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fMB\u0011q\u0006M\u0007\u0002I%\u0011\u0011\u0007\n\u0002\n\u001bN<\u0007+Y2lKJ\f1AY;g!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0002j_*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e6\u0005U\u0011\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6\fa\u0001P5oSRtDCA\u001f?!\ty\u0003\u0001C\u00033\u0005\u0001\u00071'\u0001\u0004sKN,H\u000e\u001e\u000b\u0002\u0003B\u0019\u0011F\u0011#\n\u0005\rS#!B!se\u0006L\bCA\u0015F\u0013\t1%F\u0001\u0003CsR,\u0017!E<sSR,')\u001f;f\u0003:$7\u000b[8siR\u0019\u0011\n\u0014(\u0011\u0005%R\u0015BA&+\u0005\u0011)f.\u001b;\t\u000b5#\u0001\u0019\u0001#\u0002\u0003\tDQa\u0014\u0003A\u0002A\u000b!a\u001d5\u0011\u0005%\n\u0016B\u0001*+\u0005\u0015\u0019\u0006n\u001c:u\u0003A9(/\u001b;f\u0005f$X-\u00118e\u0005f$X\rF\u0002J+ZCQ!T\u0003A\u0002\u0011CQaV\u0003A\u0002\u0011\u000b!AY\u0019\u0002\u0011]\u0014\u0018\u000e^3J]R$\"!\u0013.\t\u000bm3\u0001\u0019\u0001/\u0002\u00031\u0004\"!K/\n\u0005yS#aA%oi\u0006IqO]5uK2{gn\u001a\u000b\u0003\u0013\u0006DQaW\u0004A\u0002\t\u0004\"!K2\n\u0005\u0011T#\u0001\u0002'p]\u001e\fqb\u001e:ji\u0016\u0014\u0015\u0010^3B]\u0012Le\u000e\u001e\u000b\u0004\u0013\u001eD\u0007\"B'\t\u0001\u0004!\u0005\"B5\t\u0001\u0004a\u0016!A5\u0002!]\u0014\u0018\u000e^3CsR,\u0017I\u001c3M_:<GcA%m[\")Q*\u0003a\u0001\t\")1,\u0003a\u0001E\u0006\trO]5uK\nKH/Z!oI\u001acw.\u0019;\u0015\u0007%\u0003\u0018\u000fC\u0003N\u0015\u0001\u0007A\tC\u0003s\u0015\u0001\u00071/A\u0001g!\tIC/\u0003\u0002vU\t)a\t\\8bi\u0006\u0011rO]5uK\nKH/Z!oI\u0012{WO\u00197f)\rI\u00050\u001f\u0005\u0006\u001b.\u0001\r\u0001\u0012\u0005\u0006u.\u0001\ra_\u0001\u0002IB\u0011\u0011\u0006`\u0005\u0003{*\u0012a\u0001R8vE2,\u0017\u0001\u00039bG.\u0014\u0015\u0010^3\u0015\u0007%\u000b\t\u0001C\u0003N\u0019\u0001\u0007A)A\u0005qC\u000e\\7\u000b[8siR\u0019\u0011*a\u0002\t\r\u0005%Q\u00021\u0001Q\u0003\u00051\u0018a\u00029bG.Le\u000e\u001e\u000b\u0004\u0013\u0006=\u0001BBA\t\u001d\u0001\u0007A,A\u0001s\u0003!\u0001\u0018mY6M_:<GcA%\u0002\u0018!1\u0011\u0011B\bA\u0002\t\fa\u0002]1dW\nKw-\u00138uK\u001e,'\u000fF\u0002J\u0003;Aq!a\b\u0011\u0001\u0004\t\t#\u0001\u0002cSB!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(]\nA!\\1uQ&!\u00111FA\u0013\u0005)\u0011\u0015nZ%oi\u0016<WM]\u0001\na\u0006\u001c7N\u00127pCR$2!SA\u0019\u0011\u0019\tI!\u0005a\u0001g\u0006Q\u0001/Y2l\t>,(\r\\3\u0015\u0007%\u000b9\u0004\u0003\u0004\u0002\nI\u0001\ra_\u0001\u0006G2|7/\u001a\u000b\u0002\u0013\u0006y\u0001/Y2l\u0003J\u0014\u0018-\u001f%fC\u0012,'\u000fF\u0002J\u0003\u0003Ba!a\u0011\u0015\u0001\u0004a\u0016\u0001B:ju\u0016\f!\u0002]1dW\nKg.\u0019:z)\rI\u0015\u0011\n\u0005\u0007\u0003\u0017*\u0002\u0019A!\u0002\u000b\u0005\u0014(/Y=\u0002\u000fA\f7m\u001b(jY\u00061Q.\u00199F]\u0012\fQ\u0002]1dW6\u000b\u0007\u000fS3bI\u0016\u0014HcA%\u0002V!1\u00111\t\rA\u0002q\u000b1\u0002]1dW\n{w\u000e\\3b]R\u0019\u0011*a\u0017\t\u000f\u0005u\u0013\u00041\u0001\u0002`\u0005\t\u0011\rE\u0002*\u0003CJ1!a\u0019+\u0005\u001d\u0011un\u001c7fC:\f\u0011c\u001e:ji\u0016\u001cFO]5oO\"+\u0017\rZ3s)\rI\u0015\u0011\u000e\u0005\u0007\u0003WR\u0002\u0019\u0001/\u0002\u00071,g.\u0001\u0006qC\u000e\\7\u000b\u001e:j]\u001e$2!SA9\u0011\u001d\t\u0019h\u0007a\u0001\u0003k\n1a\u001d;s!\u0011\t9(!\"\u000f\t\u0005e\u0014\u0011\u0011\t\u0004\u0003wRSBAA?\u0015\r\tyHJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r%&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\u000bII\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007S\u0013\u0001C1se\u0006LXI\u001c3\u0002\u0019]\u0014\u0018\u000e^3QCfdw.\u00193\u0015\u0007%\u000b\t\n\u0003\u0004\u0002^u\u0001\r!Q\u0001\u0012a\u0006\u001c7.\u0012=u)f\u0004X\rS3bI\u0016\u0014H#B%\u0002\u0018\u0006m\u0005BBAM=\u0001\u0007A)A\u0004fqR$\u0016\u0010]3\t\r\u0005ue\u00041\u0001]\u0003)\u0001\u0018-\u001f7pC\u0012dUM\\\u0001\r\u001bN<w*\u001e;Ck\u001a4WM\u001d\t\u0003_\u0001\u001a\"\u0001\t\u0015\u0015\u0005\u0005\u0005\u0016AB2sK\u0006$X\rF\u0001>\u0001")
public final class MsgOutBuffer
implements MsgPacker {
    private final ByteArrayOutputStream buf;

    public static MsgOutBuffer create() {
        return MsgOutBuffer$.MODULE$.create();
    }

    @Override
    public byte[] result() {
        return this.buf.toByteArray();
    }

    public void writeByteAndShort(byte b, short sh) {
        this.buf.write(b);
        this.buf.write(sh >>> 8 & 0xFF);
        this.buf.write(sh >>> 0 & 0xFF);
    }

    private void writeByteAndByte(byte b, byte b1) {
        this.buf.write(b);
        this.buf.write(b1);
    }

    private void writeInt(int l) {
        this.buf.write((byte)(l >>> 24));
        this.buf.write((byte)(l >>> 16));
        this.buf.write((byte)(l >>> 8));
        this.buf.write((byte)l);
    }

    private void writeLong(long l) {
        this.buf.write((byte)(l >>> 56));
        this.buf.write((byte)(l >>> 48));
        this.buf.write((byte)(l >>> 40));
        this.buf.write((byte)(l >>> 32));
        this.buf.write((byte)(l >>> 24));
        this.buf.write((byte)(l >>> 16));
        this.buf.write((byte)(l >>> 8));
        this.buf.write((byte)l);
    }

    public void writeByteAndInt(byte b, int i) {
        this.buf.write(b);
        this.writeInt(i);
    }

    public void writeByteAndLong(byte b, long l) {
        this.buf.write(b);
        this.writeLong(l);
    }

    private void writeByteAndFloat(byte b, float f) {
        this.buf.write(b);
        this.writeInt(Float.floatToIntBits(f));
    }

    private void writeByteAndDouble(byte b, double d) {
        this.buf.write(b);
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void packByte(byte b) {
        if (b < -32) {
            this.buf.write(Code$.MODULE$.INT8());
            this.buf.write(b);
            return;
        }
        this.buf.write(b);
    }

    @Override
    public void packShort(short v) {
        if (v < -32) {
            if (v < -128) {
                this.writeByteAndShort(Code$.MODULE$.INT16(), v);
                return;
            }
            this.writeByteAndByte(Code$.MODULE$.INT8(), (byte)v);
            return;
        }
        if (v < 128) {
            this.buf.write((byte)v);
            return;
        }
        if (v < 256) {
            this.writeByteAndByte(Code$.MODULE$.UINT8(), (byte)v);
            return;
        }
        this.writeByteAndShort(Code$.MODULE$.UINT16(), v);
    }

    @Override
    public void packInt(int r) {
        if (r < -32) {
            if (r < -32768) {
                this.writeByteAndInt(Code$.MODULE$.INT32(), r);
                return;
            }
            if (r < -128) {
                this.writeByteAndShort(Code$.MODULE$.INT16(), (short)r);
                return;
            }
            this.writeByteAndByte(Code$.MODULE$.INT8(), (byte)r);
            return;
        }
        if (r < 128) {
            this.buf.write((byte)r);
            return;
        }
        if (r < 256) {
            this.writeByteAndByte(Code$.MODULE$.UINT8(), (byte)r);
            return;
        }
        if (r < 65536) {
            this.writeByteAndShort(Code$.MODULE$.UINT16(), (short)r);
            return;
        }
        this.writeByteAndInt(Code$.MODULE$.UINT32(), r);
    }

    @Override
    public void packLong(long v) {
        if (v < -32L) {
            if (v < -32768L) {
                if (v < -0x80000000L) {
                    this.writeByteAndLong(Code$.MODULE$.INT64(), v);
                    return;
                }
                this.writeByteAndInt(Code$.MODULE$.INT32(), (int)v);
                return;
            }
            if (v < (long)(-128)) {
                this.writeByteAndShort(Code$.MODULE$.INT16(), (short)v);
                return;
            }
            this.writeByteAndByte(Code$.MODULE$.INT8(), (byte)v);
            return;
        }
        if (v < 128L) {
            this.buf.write((byte)v);
            return;
        }
        if (v < 65536L) {
            if (v < 256L) {
                this.writeByteAndByte(Code$.MODULE$.UINT8(), (byte)v);
                return;
            }
            this.writeByteAndShort(Code$.MODULE$.UINT16(), (short)v);
            return;
        }
        if (v < 0x100000000L) {
            this.writeByteAndInt(Code$.MODULE$.UINT32(), (int)v);
            return;
        }
        this.writeByteAndLong(Code$.MODULE$.UINT64(), v);
    }

    @Override
    public void packBigInteger(BigInteger bi) {
        if (bi.bitLength() <= 63) {
            this.packLong(bi.longValue());
            return;
        }
        if (bi.bitLength() == 64 && bi.signum() == 1) {
            this.writeByteAndLong(Code$.MODULE$.UINT64(), bi.longValue());
            return;
        }
        throw new IllegalArgumentException("Messagepack cannot serialize BigInteger larger than 2^64-1");
    }

    @Override
    public void packFloat(float v) {
        this.writeByteAndFloat(Code$.MODULE$.FLOAT32(), v);
    }

    @Override
    public void packDouble(double v) {
        this.writeByteAndDouble(Code$.MODULE$.FLOAT64(), v);
    }

    public void close() {
        this.buf.close();
    }

    @Override
    public void packArrayHeader(int size) {
        if (0 <= size) {
            if (size < 16) {
                this.buf.write((byte)(Code$.MODULE$.FIXARRAY_PREFIX() | size));
                return;
            }
            if (size < 65536) {
                this.writeByteAndShort(Code$.MODULE$.ARRAY16(), (short)size);
                return;
            }
            this.writeByteAndInt(Code$.MODULE$.ARRAY32(), size);
            return;
        }
        this.writeByteAndInt(Code$.MODULE$.ARRAY32(), size);
    }

    @Override
    public void packBinary(byte[] array) {
        int len = array.length;
        if (len < 256) {
            this.writeByteAndByte(Code$.MODULE$.BIN8(), (byte)len);
        } else if (len < 65536) {
            this.writeByteAndShort(Code$.MODULE$.BIN16(), (short)len);
        } else {
            this.writeByteAndInt(Code$.MODULE$.BIN32(), len);
        }
        this.buf.write(array);
    }

    @Override
    public void packNil() {
        this.buf.write(Code$.MODULE$.NIL());
    }

    @Override
    public void mapEnd() {
    }

    @Override
    public void packMapHeader(int size) {
        if (0 <= size) {
            if (size < 16) {
                this.buf.write((byte)(Code$.MODULE$.FIXMAP_PREFIX() | size));
                return;
            }
            if (size < 65536) {
                this.writeByteAndShort(Code$.MODULE$.MAP16(), (short)size);
                return;
            }
            this.writeByteAndInt(Code$.MODULE$.MAP32(), size);
            return;
        }
        this.writeByteAndInt(Code$.MODULE$.MAP32(), size);
    }

    @Override
    public void packBoolean(boolean a) {
        this.buf.write(a ? Code$.MODULE$.TRUE() : Code$.MODULE$.FALSE());
    }

    private void writeStringHeader(int len) {
        if (len < 32) {
            this.buf.write((byte)(Code$.MODULE$.FIXSTR_PREFIX() | len));
            return;
        }
        if (len < 256) {
            this.writeByteAndByte(Code$.MODULE$.STR8(), (byte)len);
            return;
        }
        if (len < 65536) {
            this.writeByteAndShort(Code$.MODULE$.STR16(), (short)len);
            return;
        }
        this.writeByteAndInt(Code$.MODULE$.STR32(), len);
    }

    @Override
    public void packString(String str) {
        byte[] bytes = str.getBytes("UTF-8");
        this.writeStringHeader(bytes.length);
        this.buf.write(bytes);
    }

    @Override
    public void arrayEnd() {
    }

    @Override
    public void writePayload(byte[] a) {
        this.buf.write(a);
    }

    @Override
    public void packExtTypeHeader(byte extType, int payloadLen) {
        if (0 <= payloadLen) {
            if (payloadLen < 256) {
                int n = payloadLen;
                switch (n) {
                    case 1: {
                        this.writeByteAndByte((byte)212, extType);
                        return;
                    }
                    case 2: {
                        this.writeByteAndByte((byte)213, extType);
                        return;
                    }
                    case 4: {
                        this.writeByteAndByte((byte)214, extType);
                        return;
                    }
                    case 8: {
                        this.writeByteAndByte((byte)215, extType);
                        return;
                    }
                    case 16: {
                        this.writeByteAndByte((byte)216, extType);
                        return;
                    }
                }
                this.writeByteAndByte((byte)199, (byte)payloadLen);
                this.buf.write(extType);
                return;
            }
            if (payloadLen < 65536) {
                this.writeByteAndShort((byte)200, (short)payloadLen);
                this.buf.write(extType);
                return;
            }
            this.writeByteAndInt((byte)201, payloadLen);
            this.buf.write(extType);
            return;
        }
        this.writeByteAndInt((byte)201, payloadLen);
        this.buf.write(extType);
    }

    public MsgOutBuffer(ByteArrayOutputStream buf) {
        this.buf = buf;
    }
}

