/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.math.BigInteger;
import msgpack4z.Code$;
import msgpack4z.ExtTypeHeader;
import msgpack4z.MsgInBuffer$;
import msgpack4z.MsgType;
import msgpack4z.MsgUnpacker;
import msgpack4z.OptBool;
import msgpack4z.OptBool$Empty$;
import msgpack4z.OptBool$False$;
import msgpack4z.OptBool$True$;
import msgpack4z.OptByte;
import msgpack4z.OptByte$;
import msgpack4z.OptInt$;
import msgpack4z.OptShort;
import msgpack4z.OptShort$;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005%v!\u0002\u00180\u0011\u0003\u0011d!\u0002\u001b0\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004\"\u0002 \u0002\t\u0003yd\u0001\u0002\u001b0\u0005\u0005C\u0001\"\u0012\u0003\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006y\u0011!\tA\u0014\u0005\u0006!\u0012!\t!\u0015\u0005\u00075\u0012\u0001K\u0011B.\t\r}#\u0001\u0015\"\u0003a\u0011\u0019!G\u0001)C\u0005K\"1a\r\u0002Q\u0005\n\u001dDaa\u001b\u0003!\n\u0013a\u0007B\u00029\u0005A\u0013%\u0011\u000fC\u0003v\t\u0011\u0005a\u000fC\u0003{\t\u0011\u00051\u0010\u0003\u0004\u0000\t\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u0013!A\u0011AA\u0006\u0011\u001d\t\u0019\u0002\u0002C\u0001\u0003+Aa!!\b\u0005\t\u0003:\u0007bBA\u0010\t\u0011\u0005\u0013\u0011\u0005\u0005\u0007\u0003_!A\u0011\t7\t\r\u0005EB\u0001\"\u0011r\u0011\u001d\t\u0019\u0004\u0002C\u0001\u0003+Aq!!\u000e\u0005\t\u0003\t)\u0002C\u0004\u00028\u0011!I!!\u000f\t\u000f\u0005}B\u0001\"\u0001\u0002B!9\u00111\t\u0003!\n\u0013)\u0007bBA#\t\u0001&I!\u001a\u0005\t\u0003\u000f\"\u0001\u0015\"\u0003\u0002\u0016!9\u0011\u0011\n\u0003\u0005B\u0005-\u0003bBA'\t\u0011\u0005\u0013q\n\u0005\b\u0003/\"A\u0011IA-\u0011\u001d\t\t\u0007\u0002C!\u0003\u0017Ba!a\u0019\u0005\t\u00032\bbBA3\t\u0011\u0005\u00131\n\u0005\b\u0003O\"A\u0011IA5\u0011\u001d\t\t\t\u0002C!\u0003\u0017Ba!a!\u0005\t\u0003Z\u0006BBAC\t\u0011\u0005S\r\u0003\u0004\u0002\b\u0012!\t%\u001a\u0005\u0007\u0003\u0013#A\u0011\t1\t\r\u0005-E\u0001\"\u0011f\u0011\u001d\ti\t\u0002C!\u0003\u001fCq!!$\u0005\t\u0003\n)\nC\u0004\u0002\u001c\u0012!\t%!(\u0002\u00175\u001bx-\u00138Ck\u001a4WM\u001d\u0006\u0002a\u0005IQn]4qC\u000e\\GG_\u0002\u0001!\t\u0019\u0014!D\u00010\u0005-i5oZ%o\u0005V4g-\u001a:\u0014\u0005\u00051\u0004CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002e\u0005)\u0011\r\u001d9msR\u0019\u0001)!*\u0011\u0005M\"1c\u0001\u00037\u0005B\u00111gQ\u0005\u0003\t>\u00121\"T:h+:\u0004\u0018mY6fe\u0006\u0019!-\u001e4\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015AA5p\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003)\tKH/Z!se\u0006L\u0018J\u001c9viN#(/Z1n)\t\u0001u\nC\u0003F\r\u0001\u0007a)A\u0005tW&\u0004()\u001f;fgR\u0011!+\u0016\t\u0003oMK!\u0001\u0016\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006-\u001e\u0001\raV\u0001\u0002]B\u0011q\u0007W\u0005\u00033b\u00121!\u00138u\u0003!\u0011X-\u00193CsR,G#\u0001/\u0011\u0005]j\u0016B\u000109\u0005\u0011\u0011\u0015\u0010^3\u0002\u0013I,\u0017\rZ*i_J$H#A1\u0011\u0005]\u0012\u0017BA29\u0005\u0015\u0019\u0006n\u001c:u\u0003\u001d\u0011X-\u00193J]R$\u0012aV\u0001\te\u0016\fG\rT8oOR\t\u0001\u000e\u0005\u00028S&\u0011!\u000e\u000f\u0002\u0005\u0019>tw-A\u0005sK\u0006$g\t\\8biR\tQ\u000e\u0005\u00028]&\u0011q\u000e\u000f\u0002\u0006\r2|\u0017\r^\u0001\u000be\u0016\fG\rR8vE2,G#\u0001:\u0011\u0005]\u001a\u0018B\u0001;9\u0005\u0019!u.\u001e2mK\u0006\u0011RO\u001c9bG.t\u0015\u000e\\,ji\"\u001c\u0005.Z2l)\u00059\bCA\u001cy\u0013\tI\bHA\u0004C_>dW-\u00198\u0002!Ut\u0007/Y2l\u0005>|G.Z1o\u001fB$H#\u0001?\u0011\u0005Mj\u0018B\u0001@0\u0005\u001dy\u0005\u000f\u001e\"p_2\fQ\"\u001e8qC\u000e\\')\u001f;f\u001fB$HCAA\u0002!\r\u0019\u0014QA\u0005\u0004\u0003\u000fy#aB(qi\nKH/Z\u0001\u000fk:\u0004\u0018mY6TQ>\u0014Ho\u00149u)\t\ti\u0001E\u00024\u0003\u001fI1!!\u00050\u0005!y\u0005\u000f^*i_J$\u0018\u0001D;oa\u0006\u001c7.\u00138u\u001fB$HCAA\f!\r\u0019\u0014\u0011D\u0005\u0004\u00037y#AB(qi&sG/\u0001\u0006v]B\f7m\u001b'p]\u001e\f\u0001#\u001e8qC\u000e\\')[4J]R,w-\u001a:\u0015\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%\"*\u0001\u0003nCRD\u0017\u0002BA\u0017\u0003O\u0011!BQ5h\u0013:$XmZ3s\u0003-)h\u000e]1dW\u001acw.\u0019;\u0002\u0019Ut\u0007/Y2l\t>,(\r\\3\u0002)Ut\u0007/Y2l\u0003J\u0014\u0018-\u001f%fC\u0012,'o\u00149u\u0003I)h\u000e]1dW6\u000b\u0007\u000fS3bI\u0016\u0014x\n\u001d;\u0002!I,\u0017\rZ*ue&tw\rS3bI\u0016\u0014H\u0003BA\f\u0003wAa!!\u0010\u001a\u0001\u0004a\u0016!\u00012\u0002+Ut\u0007/Y2l%\u0006<8\u000b\u001e:j]\u001eDU-\u00193feV\u0011\u0011qC\u0001\u0010e\u0016\fGMT3yi2+gn\u001a;iq\u0005\u0001\"/Z1e\u001d\u0016DH\u000fT3oORD\u0017GN\u0001\u0011e\u0016\fGMT3yi2+gn\u001a;igI\nQa\u00197pg\u0016$\u0012AU\u0001\t]\u0016DH\u000fV=qKR\u0011\u0011\u0011\u000b\t\u0004g\u0005M\u0013bAA+_\t9Qj]4UsB,\u0017\u0001D;oa\u0006\u001c7NQ5oCJLHCAA.!\u00119\u0014Q\f/\n\u0007\u0005}\u0003HA\u0003BeJ\f\u00170\u0001\u0004nCB,e\u000eZ\u0001\u000ek:\u0004\u0018mY6C_>dW-\u00198\u0002\u0013Ut\u0007/Y2l\u001d&d\u0017\u0001D;oa\u0006\u001c7n\u0015;sS:<GCAA6!\u0011\ti'a\u001f\u000f\t\u0005=\u0014q\u000f\t\u0004\u0003cBTBAA:\u0015\r\t)(M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005e\u0004(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003{\nyH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003sB\u0014\u0001C1se\u0006LXI\u001c3\u0002\u0015Ut\u0007/Y2l\u0005f$X-A\tv]B\f7m[!se\u0006L\b*Z1eKJ\f\u0011\"\u001e8qC\u000e\\\u0017J\u001c;\u0002\u0017Ut\u0007/Y2l'\"|'\u000f^\u0001\u0010k:\u0004\u0018mY6NCBDU-\u00193fe\u0006Y!/Z1e!\u0006LHn\\1e)\u0011\tY&!%\t\r\u0005M5\u00061\u0001X\u0003\u0019aWM\\4uQR\u0019!+a&\t\u000f\u0005eE\u00061\u0001\u0002\\\u0005\t\u0011-A\nv]B\f7m[#yiRK\b/\u001a%fC\u0012,'\u000f\u0006\u0002\u0002 B\u00191'!)\n\u0007\u0005\rvFA\u0007FqR$\u0016\u0010]3IK\u0006$WM\u001d\u0005\b\u0003O\u001b\u0001\u0019AA.\u0003\u0015\u0011\u0017\u0010^3t\u0001")
public final class MsgInBuffer
implements MsgUnpacker {
    private final ByteArrayInputStream buf;

    public static MsgInBuffer apply(byte[] byArray) {
        return MsgInBuffer$.MODULE$.apply(byArray);
    }

    public void skipBytes(int n) {
        this.buf.skip(n);
    }

    private byte readByte() {
        int b = this.buf.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    private short readShort() {
        int ch2;
        int ch1 = this.buf.read();
        if ((ch1 | (ch2 = this.buf.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    private int readInt() {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.buf.read();
        if ((ch1 | (ch2 = this.buf.read()) | (ch3 = this.buf.read()) | (ch4 = this.buf.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    private long readLong() {
        long ch8;
        long ch7;
        long ch6;
        long ch5;
        long ch4;
        long ch3;
        long ch2;
        long ch1 = this.buf.read();
        if ((ch1 | (ch2 = (long)this.buf.read()) | (ch3 = (long)this.buf.read()) | (ch4 = (long)this.buf.read()) | (ch5 = (long)this.buf.read()) | (ch6 = (long)this.buf.read()) | (ch7 = (long)this.buf.read()) | (ch8 = (long)this.buf.read())) < 0L) {
            throw new EOFException();
        }
        return (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + ch8;
    }

    private float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    private double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public boolean unpackNilWithCheck() {
        return this.readByte() == Code$.MODULE$.NIL();
    }

    public OptBool unpackBooleanOpt() {
        byte by = this.readByte();
        if (Code$.MODULE$.TRUE() == by) {
            return OptBool$True$.MODULE$;
        }
        if (Code$.MODULE$.FALSE() == by) {
            return OptBool$False$.MODULE$;
        }
        return OptBool$Empty$.MODULE$;
    }

    public OptByte unpackByteOpt() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixInt(b)) {
            return OptByte$.MODULE$.apply(b);
        }
        byte by = b;
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = this.readByte();
            if (u8 < 0) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply(u8);
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = this.readShort();
            if (u16 < 0 || u16 > 127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)u16);
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = this.readInt();
            if (u32 < 0 || u32 > 127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)u32);
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = this.readLong();
            if (u64 < 0L || u64 > (long)127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)u64);
        }
        if (Code$.MODULE$.INT8() == by) {
            return OptByte$.MODULE$.apply(this.readByte());
        }
        if (Code$.MODULE$.INT16() == by) {
            short i16 = this.readShort();
            if (i16 < -128 || i16 > 127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)i16);
        }
        if (Code$.MODULE$.INT32() == by) {
            int i32 = this.readInt();
            if (i32 < -128 || i32 > 127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)i32);
        }
        if (Code$.MODULE$.INT64() == by) {
            long i64 = this.readLong();
            if (i64 < (long)-128 || i64 > (long)127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)i64);
        }
        return OptByte$.MODULE$.empty();
    }

    public OptShort unpackShortOpt() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixInt(b)) {
            return OptShort$.MODULE$.apply(b);
        }
        byte by = b;
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = this.readByte();
            return OptShort$.MODULE$.apply((short)(u8 & 0xFF));
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = this.readShort();
            if (u16 < 0) {
                return OptShort$.MODULE$.empty();
            }
            return OptShort$.MODULE$.apply(u16);
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = this.readInt();
            if (u32 < 0 || u32 > Short.MAX_VALUE) {
                return OptShort$.MODULE$.empty();
            }
            return OptShort$.MODULE$.apply((short)u32);
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = this.readLong();
            if (u64 < 0L || u64 > (long)Short.MAX_VALUE) {
                return OptShort$.MODULE$.empty();
            }
            return OptShort$.MODULE$.apply((short)u64);
        }
        if (Code$.MODULE$.INT8() == by) {
            byte i8 = this.readByte();
            return OptShort$.MODULE$.apply(i8);
        }
        if (Code$.MODULE$.INT16() == by) {
            return OptShort$.MODULE$.apply(this.readShort());
        }
        if (Code$.MODULE$.INT32() == by) {
            int i32 = this.readInt();
            if (i32 < Short.MIN_VALUE || i32 > Short.MAX_VALUE) {
                return OptShort$.MODULE$.empty();
            }
            return OptShort$.MODULE$.apply((short)i32);
        }
        if (Code$.MODULE$.INT64() == by) {
            long i64 = this.readLong();
            if (i64 < (long)Short.MIN_VALUE || i64 > (long)Short.MAX_VALUE) {
                return OptShort$.MODULE$.empty();
            }
            return OptShort$.MODULE$.apply((short)i64);
        }
        return OptShort$.MODULE$.empty();
    }

    public long unpackIntOpt() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixInt(b)) {
            return OptInt$.MODULE$.apply(b);
        }
        byte by = b;
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = this.readByte();
            return OptInt$.MODULE$.apply(u8 & 0xFF);
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = this.readShort();
            return OptInt$.MODULE$.apply(u16 & 0xFFFF);
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = this.readInt();
            if (u32 < 0) {
                return OptInt$.MODULE$.empty();
            }
            return OptInt$.MODULE$.apply(u32);
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = this.readLong();
            if (u64 < 0L || u64 > Integer.MAX_VALUE) {
                return OptInt$.MODULE$.empty();
            }
            return OptInt$.MODULE$.apply((int)u64);
        }
        if (Code$.MODULE$.INT8() == by) {
            return OptInt$.MODULE$.apply(this.readByte());
        }
        if (Code$.MODULE$.INT16() == by) {
            return OptInt$.MODULE$.apply(this.readShort());
        }
        if (Code$.MODULE$.INT32() == by) {
            return OptInt$.MODULE$.apply(this.readInt());
        }
        if (Code$.MODULE$.INT64() == by) {
            long i64 = this.readLong();
            if (i64 < Integer.MIN_VALUE || i64 > Integer.MAX_VALUE) {
                return OptInt$.MODULE$.empty();
            }
            return OptInt$.MODULE$.apply((int)i64);
        }
        return OptInt$.MODULE$.empty();
    }

    @Override
    public long unpackLong() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixInt(b)) {
            return b;
        }
        byte by = b;
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = this.readByte();
            return u8 & 0xFF;
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = this.readShort();
            return u16 & 0xFFFF;
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = this.readInt();
            if (u32 < 0) {
                return (long)(u32 & Integer.MAX_VALUE) + 0x80000000L;
            }
            return u32;
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = this.readLong();
            if (u64 < 0L) {
                throw new RuntimeException(new StringBuilder(9).append("overflow ").append(u64).toString());
            }
            return u64;
        }
        if (Code$.MODULE$.INT8() == by) {
            return this.readByte();
        }
        if (Code$.MODULE$.INT16() == by) {
            return this.readShort();
        }
        if (Code$.MODULE$.INT32() == by) {
            return this.readInt();
        }
        if (Code$.MODULE$.INT64() == by) {
            return this.readLong();
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    @Override
    public BigInteger unpackBigInteger() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixInt(b)) {
            return BigInteger.valueOf(b);
        }
        byte by = b;
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = this.readByte();
            return BigInteger.valueOf(u8 & 0xFF);
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = this.readShort();
            return BigInteger.valueOf(u16 & 0xFFFF);
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = this.readInt();
            if (u32 < 0) {
                return BigInteger.valueOf((long)(u32 & Integer.MAX_VALUE) + 0x80000000L);
            }
            return BigInteger.valueOf(u32);
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = this.readLong();
            if (u64 < 0L) {
                return BigInteger.valueOf(u64 + Long.MAX_VALUE + 1L).setBit(63);
            }
            return BigInteger.valueOf(u64);
        }
        if (Code$.MODULE$.INT8() == by) {
            byte i8 = this.readByte();
            return BigInteger.valueOf(i8);
        }
        if (Code$.MODULE$.INT16() == by) {
            short i16 = this.readShort();
            return BigInteger.valueOf(i16);
        }
        if (Code$.MODULE$.INT32() == by) {
            int i32 = this.readInt();
            return BigInteger.valueOf(i32);
        }
        if (Code$.MODULE$.INT64() == by) {
            return BigInteger.valueOf(this.readLong());
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    @Override
    public float unpackFloat() {
        byte b;
        byte by = b = this.readByte();
        if (Code$.MODULE$.FLOAT32() == by) {
            return this.readFloat();
        }
        if (Code$.MODULE$.FLOAT64() == by) {
            return (float)this.readDouble();
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    @Override
    public double unpackDouble() {
        byte b;
        byte by = b = this.readByte();
        if (Code$.MODULE$.FLOAT32() == by) {
            return this.readFloat();
        }
        if (Code$.MODULE$.FLOAT64() == by) {
            return this.readDouble();
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public long unpackArrayHeaderOpt() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixedArray(b)) {
            return OptInt$.MODULE$.apply(b & 0xF);
        }
        byte by = b;
        if (Code$.MODULE$.ARRAY16() == by) {
            return OptInt$.MODULE$.apply(this.readNextLength16());
        }
        if (Code$.MODULE$.ARRAY32() == by) {
            return OptInt$.MODULE$.apply(this.readInt());
        }
        return OptInt$.MODULE$.empty();
    }

    public long unpackMapHeaderOpt() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixedMap(b)) {
            return OptInt$.MODULE$.apply(b & 0xF);
        }
        byte by = b;
        if (Code$.MODULE$.MAP16() == by) {
            return OptInt$.MODULE$.apply(this.readNextLength16());
        }
        if (Code$.MODULE$.MAP32() == by) {
            return OptInt$.MODULE$.apply(this.readInt());
        }
        return OptInt$.MODULE$.empty();
    }

    private long readStringHeader(byte b) {
        byte by = b;
        if (Code$.MODULE$.STR8() == by) {
            return OptInt$.MODULE$.apply(this.readNextLength8());
        }
        if (Code$.MODULE$.STR16() == by) {
            return OptInt$.MODULE$.apply(this.readNextLength16());
        }
        if (Code$.MODULE$.STR32() == by) {
            return this.readNextLength32();
        }
        return OptInt$.MODULE$.empty();
    }

    public long unpackRawStringHeader() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixedRaw(b)) {
            return OptInt$.MODULE$.apply(b & 0x1F);
        }
        return this.readStringHeader(b);
    }

    private int readNextLength8() {
        return this.readByte() & 0xFF;
    }

    private int readNextLength16() {
        return this.readShort() & 0xFFFF;
    }

    private long readNextLength32() {
        int u32 = this.readInt();
        if (u32 < 0) {
            return OptInt$.MODULE$.empty();
        }
        return OptInt$.MODULE$.apply(u32);
    }

    @Override
    public void close() {
        this.buf.close();
    }

    @Override
    public MsgType nextType() {
        if (this.buf.markSupported()) {
            MsgType msgType;
            this.buf.mark(1024);
            try {
                msgType = Code$.MODULE$.getType(this.readByte());
            }
            finally {
                this.buf.reset();
            }
            return msgType;
        }
        throw package$.MODULE$.error("mark not supported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] unpackBinary() {
        int n;
        byte b = this.readByte();
        if (Code$.MODULE$.isFixedRaw(b)) {
            n = 0x1F & b;
        } else {
            byte by = b;
            if (Code$.MODULE$.BIN8() == by) {
                n = this.readNextLength8();
            } else if (Code$.MODULE$.BIN16() == by) {
                n = this.readNextLength16();
            } else {
                int l;
                if (Code$.MODULE$.BIN32() != by) throw package$.MODULE$.error(new StringBuilder(18).append("not binary header ").append(b).toString());
                long l2 = this.readNextLength32();
                long l3 = OptInt$.MODULE$.unapply(l2);
                if (OptInt$.MODULE$.isEmpty$extension(l3)) throw package$.MODULE$.error("binary header length overflow");
                n = l = OptInt$.MODULE$.get$extension(l3);
            }
        }
        int len = n;
        byte[] array = new byte[len];
        this.buf.read(array);
        return array;
    }

    @Override
    public void mapEnd() {
    }

    @Override
    public boolean unpackBoolean() {
        return this.unpackBooleanOpt().get();
    }

    @Override
    public void unpackNil() {
        Predef$.MODULE$.assert(this.unpackNilWithCheck());
    }

    @Override
    public String unpackString() {
        int n;
        byte b = this.readByte();
        if (Code$.MODULE$.isFixStr(b)) {
            n = 0x1F & b;
        } else {
            byte by = b;
            if (Code$.MODULE$.STR8() == by) {
                n = this.readNextLength8();
            } else if (Code$.MODULE$.STR16() == by) {
                n = this.readNextLength16();
            } else if (Code$.MODULE$.STR32() == by) {
                n = OptInt$.MODULE$.get$extension(this.readNextLength32());
            } else {
                throw package$.MODULE$.error(new StringBuilder(18).append("not string header ").append(b).toString());
            }
        }
        int len = n;
        byte[] array = new byte[len];
        this.buf.read(array);
        return new String(array, "UTF-8");
    }

    @Override
    public void arrayEnd() {
    }

    @Override
    public byte unpackByte() {
        return this.unpackByteOpt().get();
    }

    @Override
    public int unpackArrayHeader() {
        return OptInt$.MODULE$.get$extension(this.unpackArrayHeaderOpt());
    }

    @Override
    public int unpackInt() {
        return OptInt$.MODULE$.get$extension(this.unpackIntOpt());
    }

    @Override
    public short unpackShort() {
        return this.unpackShortOpt().get();
    }

    @Override
    public int unpackMapHeader() {
        return OptInt$.MODULE$.get$extension(this.unpackMapHeaderOpt());
    }

    @Override
    public byte[] readPayload(int length) {
        byte[] array = new byte[length];
        this.buf.read(array);
        return array;
    }

    @Override
    public void readPayload(byte[] a) {
        this.buf.read(a);
    }

    @Override
    public ExtTypeHeader unpackExtTypeHeader() {
        byte by = this.readByte();
        if (Code$.MODULE$.FIXEXT1() == by) {
            return new ExtTypeHeader(this.readByte(), 1);
        }
        if (Code$.MODULE$.FIXEXT2() == by) {
            return new ExtTypeHeader(this.readByte(), 2);
        }
        if (Code$.MODULE$.FIXEXT4() == by) {
            return new ExtTypeHeader(this.readByte(), 4);
        }
        if (Code$.MODULE$.FIXEXT8() == by) {
            return new ExtTypeHeader(this.readByte(), 8);
        }
        if (Code$.MODULE$.FIXEXT16() == by) {
            return new ExtTypeHeader(this.readByte(), 16);
        }
        if (Code$.MODULE$.EXT8() == by) {
            int length = this.readByte() & 0xFF;
            byte tpe = this.readByte();
            return new ExtTypeHeader(tpe, length);
        }
        if (Code$.MODULE$.EXT16() == by) {
            int length = this.readShort() & 0xFFFF;
            byte tpe = this.readByte();
            return new ExtTypeHeader(tpe, length);
        }
        if (Code$.MODULE$.EXT32() == by) {
            int length = this.readInt();
            byte tpe = this.readByte();
            return new ExtTypeHeader(tpe, length);
        }
        throw package$.MODULE$.error(new StringBuilder(16).append("unexpected type ").append(by).toString());
    }

    public MsgInBuffer(ByteArrayInputStream buf) {
        this.buf = buf;
    }
}

