/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import msgpack4z.Code$;
import msgpack4z.MsgOutBuffer$;
import msgpack4z.MsgPacker;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\u0012%\u0005\u001dB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\u0006w\u0001!I\u0001\u0010\u0005\u0006\u007f\u0001!\t\u0005\u0011\u0005\u0007\u0015\u0002!\t\u0001J&\t\rY\u0003\u0001\u0015\"\u0003X\u0011\u0019Y\u0006\u0001)C\u00059\"1!\r\u0001Q\u0005\n\rDa\u0001\u001b\u0001\u0005\u0002\u0011J\u0007BB7\u0001\t\u0003!c\u000e\u0003\u0004r\u0001\u0001&IA\u001d\u0005\u0007s\u0002\u0001K\u0011\u0002>\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u00111\t\u0001\u0005B\u0005\u0015\u0003bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003'\u0002A\u0011IA!\u0011\u001d\t)\u0006\u0001C!\u0003\u0003Bq!a\u0016\u0001\t\u0003\nI\u0006C\u0004\u0002^\u0001!\t%a\u0018\t\u0011\u0005-\u0004\u0001)C\u0005\u0003[Bq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002\u0012\u0002!\t%!\u0011\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\"9\u0011\u0011\u0014\u0001\u0005B\u0005muaBASI!\u0005\u0011q\u0015\u0004\u0007G\u0011B\t!!+\t\rm\u0002C\u0011AAY\u0011\u001d\t\u0019\f\tC\u0001\u0003k\u0013A\"T:h\u001fV$()\u001e4gKJT\u0011!J\u0001\n[N<\u0007/Y2lii\u001c\u0001aE\u0002\u0001QA\u0002\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\t1\fgn\u001a\u0006\u0002[\u0005!!.\u0019<b\u0013\ty#F\u0001\u0004PE*,7\r\u001e\t\u0003cIj\u0011\u0001J\u0005\u0003g\u0011\u0012\u0011\"T:h!\u0006\u001c7.\u001a:\u0002\u0007\t,h\r\u0005\u00027s5\tqG\u0003\u00029Y\u0005\u0011\u0011n\\\u0005\u0003u]\u0012QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.\u0001\u0004=S:LGO\u0010\u000b\u0003{y\u0002\"!\r\u0001\t\u000bQ\u0012\u0001\u0019A\u001b\u0002\rI,7/\u001e7u)\u0005\t\u0005c\u0001\"F\u000f6\t1IC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15IA\u0003BeJ\f\u0017\u0010\u0005\u0002C\u0011&\u0011\u0011j\u0011\u0002\u0005\u0005f$X-A\txe&$XMQ=uK\u0006sGm\u00155peR$2\u0001T(R!\t\u0011U*\u0003\u0002O\u0007\n!QK\\5u\u0011\u0015\u0001F\u00011\u0001H\u0003\u0005\u0011\u0007\"\u0002*\u0005\u0001\u0004\u0019\u0016AA:i!\t\u0011E+\u0003\u0002V\u0007\n)1\u000b[8si\u0006\u0001rO]5uK\nKH/Z!oI\nKH/\u001a\u000b\u0004\u0019bK\u0006\"\u0002)\u0006\u0001\u00049\u0005\"\u0002.\u0006\u0001\u00049\u0015A\u000122\u0003!9(/\u001b;f\u0013:$HC\u0001'^\u0011\u0015qf\u00011\u0001`\u0003\u0005a\u0007C\u0001\"a\u0013\t\t7IA\u0002J]R\f\u0011b\u001e:ji\u0016duN\\4\u0015\u00051#\u0007\"\u00020\b\u0001\u0004)\u0007C\u0001\"g\u0013\t97I\u0001\u0003M_:<\u0017aD<sSR,')\u001f;f\u0003:$\u0017J\u001c;\u0015\u00071S7\u000eC\u0003Q\u0011\u0001\u0007q\tC\u0003m\u0011\u0001\u0007q,A\u0001j\u0003A9(/\u001b;f\u0005f$X-\u00118e\u0019>tw\rF\u0002M_BDQ\u0001U\u0005A\u0002\u001dCQAX\u0005A\u0002\u0015\f\u0011c\u001e:ji\u0016\u0014\u0015\u0010^3B]\u00124En\\1u)\ra5\u000f\u001e\u0005\u0006!*\u0001\ra\u0012\u0005\u0006k*\u0001\rA^\u0001\u0002MB\u0011!i^\u0005\u0003q\u000e\u0013QA\u00127pCR\f!c\u001e:ji\u0016\u0014\u0015\u0010^3B]\u0012$u.\u001e2mKR\u0019Aj\u001f?\t\u000bA[\u0001\u0019A$\t\u000bu\\\u0001\u0019\u0001@\u0002\u0003\u0011\u0004\"AQ@\n\u0007\u0005\u00051I\u0001\u0004E_V\u0014G.Z\u0001\ta\u0006\u001c7NQ=uKR\u0019A*a\u0002\t\u000bAc\u0001\u0019A$\u0002\u0013A\f7m[*i_J$Hc\u0001'\u0002\u000e!1\u0011qB\u0007A\u0002M\u000b\u0011A^\u0001\ba\u0006\u001c7.\u00138u)\ra\u0015Q\u0003\u0005\u0007\u0003/q\u0001\u0019A0\u0002\u0003I\f\u0001\u0002]1dW2{gn\u001a\u000b\u0004\u0019\u0006u\u0001BBA\b\u001f\u0001\u0007Q-\u0001\bqC\u000e\\')[4J]R,w-\u001a:\u0015\u00071\u000b\u0019\u0003C\u0004\u0002&A\u0001\r!a\n\u0002\u0005\tL\u0007\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055B&\u0001\u0003nCRD\u0017\u0002BA\u0019\u0003W\u0011!BQ5h\u0013:$XmZ3s\u0003%\u0001\u0018mY6GY>\fG\u000fF\u0002M\u0003oAa!a\u0004\u0012\u0001\u00041\u0018A\u00039bG.$u.\u001e2mKR\u0019A*!\u0010\t\r\u0005=!\u00031\u0001\u007f\u0003\u0015\u0019Gn\\:f)\u0005a\u0015a\u00049bG.\f%O]1z\u0011\u0016\fG-\u001a:\u0015\u00071\u000b9\u0005\u0003\u0004\u0002JQ\u0001\raX\u0001\u0005g&TX-\u0001\u0006qC\u000e\\')\u001b8bef$2\u0001TA(\u0011\u0019\t\t&\u0006a\u0001\u0003\u0006)\u0011M\u001d:bs\u00069\u0001/Y2l\u001d&d\u0017AB7ba\u0016sG-A\u0007qC\u000e\\W*\u00199IK\u0006$WM\u001d\u000b\u0004\u0019\u0006m\u0003BBA%1\u0001\u0007q,A\u0006qC\u000e\\'i\\8mK\u0006tGc\u0001'\u0002b!9\u00111M\rA\u0002\u0005\u0015\u0014!A1\u0011\u0007\t\u000b9'C\u0002\u0002j\r\u0013qAQ8pY\u0016\fg.A\txe&$Xm\u0015;sS:<\u0007*Z1eKJ$2\u0001TA8\u0011\u0019\t\tH\u0007a\u0001?\u0006\u0019A.\u001a8\u0002\u0015A\f7m[*ue&tw\rF\u0002M\u0003oBq!!\u001f\u001c\u0001\u0004\tY(A\u0002tiJ\u0004B!! \u0002\f:!\u0011qPAD!\r\t\tiQ\u0007\u0003\u0003\u0007S1!!\"'\u0003\u0019a$o\\8u}%\u0019\u0011\u0011R\"\u0002\rA\u0013X\rZ3g\u0013\u0011\ti)a$\u0003\rM#(/\u001b8h\u0015\r\tIiQ\u0001\tCJ\u0014\u0018-_#oI\u0006aqO]5uKB\u000b\u0017\u0010\\8bIR\u0019A*a&\t\r\u0005\rT\u00041\u0001B\u0003E\u0001\u0018mY6FqR$\u0016\u0010]3IK\u0006$WM\u001d\u000b\u0006\u0019\u0006u\u0015\u0011\u0015\u0005\u0007\u0003?s\u0002\u0019A$\u0002\u000f\u0015DH\u000fV=qK\"1\u00111\u0015\u0010A\u0002}\u000b!\u0002]1zY>\fG\rT3o\u00031i5oZ(vi\n+hMZ3s!\t\t\u0004eE\u0002!\u0003W\u00032AQAW\u0013\r\tyk\u0011\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u001d\u0016AB2sK\u0006$X\rF\u0001>\u0001")
public final class MsgOutBuffer
implements MsgPacker {
    private final ByteArrayOutputStream buf;

    public static MsgOutBuffer create() {
        return MsgOutBuffer$.MODULE$.create();
    }

    public byte[] result() {
        return this.buf.toByteArray();
    }

    public void writeByteAndShort(byte b, short sh) {
        this.buf.write(b);
        this.buf.write(sh >>> 8 & 0xFF);
        this.buf.write(sh >>> 0 & 0xFF);
    }

    private void writeByteAndByte(byte b, byte b1) {
        this.buf.write(b);
        this.buf.write(b1);
    }

    private void writeInt(int l) {
        this.buf.write((byte)(l >>> 24));
        this.buf.write((byte)(l >>> 16));
        this.buf.write((byte)(l >>> 8));
        this.buf.write((byte)l);
    }

    private void writeLong(long l) {
        this.buf.write((byte)(l >>> 56));
        this.buf.write((byte)(l >>> 48));
        this.buf.write((byte)(l >>> 40));
        this.buf.write((byte)(l >>> 32));
        this.buf.write((byte)(l >>> 24));
        this.buf.write((byte)(l >>> 16));
        this.buf.write((byte)(l >>> 8));
        this.buf.write((byte)l);
    }

    public void writeByteAndInt(byte b, int i) {
        this.buf.write(b);
        this.writeInt(i);
    }

    public void writeByteAndLong(byte b, long l) {
        this.buf.write(b);
        this.writeLong(l);
    }

    private void writeByteAndFloat(byte b, float f) {
        this.buf.write(b);
        this.writeInt(Float.floatToIntBits(f));
    }

    private void writeByteAndDouble(byte b, double d) {
        this.buf.write(b);
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void packByte(byte b) {
        if (b < -32) {
            this.buf.write(Code$.MODULE$.INT8());
            this.buf.write(b);
            return;
        }
        this.buf.write(b);
    }

    public void packShort(short v) {
        if (v < -32) {
            if (v < -128) {
                this.writeByteAndShort(Code$.MODULE$.INT16(), v);
                return;
            }
            this.writeByteAndByte(Code$.MODULE$.INT8(), (byte)v);
            return;
        }
        if (v < 128) {
            this.buf.write((byte)v);
            return;
        }
        if (v < 256) {
            this.writeByteAndByte(Code$.MODULE$.UINT8(), (byte)v);
            return;
        }
        this.writeByteAndShort(Code$.MODULE$.UINT16(), v);
    }

    public void packInt(int r) {
        if (r < -32) {
            if (r < -32768) {
                this.writeByteAndInt(Code$.MODULE$.INT32(), r);
                return;
            }
            if (r < -128) {
                this.writeByteAndShort(Code$.MODULE$.INT16(), (short)r);
                return;
            }
            this.writeByteAndByte(Code$.MODULE$.INT8(), (byte)r);
            return;
        }
        if (r < 128) {
            this.buf.write((byte)r);
            return;
        }
        if (r < 256) {
            this.writeByteAndByte(Code$.MODULE$.UINT8(), (byte)r);
            return;
        }
        if (r < 65536) {
            this.writeByteAndShort(Code$.MODULE$.UINT16(), (short)r);
            return;
        }
        this.writeByteAndInt(Code$.MODULE$.UINT32(), r);
    }

    public void packLong(long v) {
        if (v < -32L) {
            if (v < -32768L) {
                if (v < -0x80000000L) {
                    this.writeByteAndLong(Code$.MODULE$.INT64(), v);
                    return;
                }
                this.writeByteAndInt(Code$.MODULE$.INT32(), (int)v);
                return;
            }
            if (v < (long)(-128)) {
                this.writeByteAndShort(Code$.MODULE$.INT16(), (short)v);
                return;
            }
            this.writeByteAndByte(Code$.MODULE$.INT8(), (byte)v);
            return;
        }
        if (v < 128L) {
            this.buf.write((byte)v);
            return;
        }
        if (v < 65536L) {
            if (v < 256L) {
                this.writeByteAndByte(Code$.MODULE$.UINT8(), (byte)v);
                return;
            }
            this.writeByteAndShort(Code$.MODULE$.UINT16(), (short)v);
            return;
        }
        if (v < 0x100000000L) {
            this.writeByteAndInt(Code$.MODULE$.UINT32(), (int)v);
            return;
        }
        this.writeByteAndLong(Code$.MODULE$.UINT64(), v);
    }

    public void packBigInteger(BigInteger bi) {
        if (bi.bitLength() <= 63) {
            this.packLong(bi.longValue());
            return;
        }
        if (bi.bitLength() == 64 && bi.signum() == 1) {
            this.writeByteAndLong(Code$.MODULE$.UINT64(), bi.longValue());
            return;
        }
        throw new IllegalArgumentException("Messagepack cannot serialize BigInteger larger than 2^64-1");
    }

    public void packFloat(float v) {
        this.writeByteAndFloat(Code$.MODULE$.FLOAT32(), v);
    }

    public void packDouble(double v) {
        this.writeByteAndDouble(Code$.MODULE$.FLOAT64(), v);
    }

    public void close() {
        this.buf.close();
    }

    public void packArrayHeader(int size) {
        if (0 <= size) {
            if (size < 16) {
                this.buf.write((byte)(Code$.MODULE$.FIXARRAY_PREFIX() | size));
                return;
            }
            if (size < 65536) {
                this.writeByteAndShort(Code$.MODULE$.ARRAY16(), (short)size);
                return;
            }
            this.writeByteAndInt(Code$.MODULE$.ARRAY32(), size);
            return;
        }
        this.writeByteAndInt(Code$.MODULE$.ARRAY32(), size);
    }

    public void packBinary(byte[] array) {
        int len = array.length;
        if (len < 256) {
            this.writeByteAndByte(Code$.MODULE$.BIN8(), (byte)len);
        } else if (len < 65536) {
            this.writeByteAndShort(Code$.MODULE$.BIN16(), (short)len);
        } else {
            this.writeByteAndInt(Code$.MODULE$.BIN32(), len);
        }
        this.buf.write(array);
    }

    public void packNil() {
        this.buf.write(Code$.MODULE$.NIL());
    }

    public void mapEnd() {
    }

    public void packMapHeader(int size) {
        if (0 <= size) {
            if (size < 16) {
                this.buf.write((byte)(Code$.MODULE$.FIXMAP_PREFIX() | size));
                return;
            }
            if (size < 65536) {
                this.writeByteAndShort(Code$.MODULE$.MAP16(), (short)size);
                return;
            }
            this.writeByteAndInt(Code$.MODULE$.MAP32(), size);
            return;
        }
        this.writeByteAndInt(Code$.MODULE$.MAP32(), size);
    }

    public void packBoolean(boolean a) {
        this.buf.write(a ? Code$.MODULE$.TRUE() : Code$.MODULE$.FALSE());
    }

    private void writeStringHeader(int len) {
        if (len < 32) {
            this.buf.write((byte)(Code$.MODULE$.FIXSTR_PREFIX() | len));
            return;
        }
        if (len < 256) {
            this.writeByteAndByte(Code$.MODULE$.STR8(), (byte)len);
            return;
        }
        if (len < 65536) {
            this.writeByteAndShort(Code$.MODULE$.STR16(), (short)len);
            return;
        }
        this.writeByteAndInt(Code$.MODULE$.STR32(), len);
    }

    public void packString(String str) {
        byte[] bytes = str.getBytes("UTF-8");
        this.writeStringHeader(bytes.length);
        this.buf.write(bytes);
    }

    public void arrayEnd() {
    }

    public void writePayload(byte[] a) {
        this.buf.write(a);
    }

    public void packExtTypeHeader(byte extType, int payloadLen) {
        if (0 <= payloadLen) {
            if (payloadLen < 256) {
                int n = payloadLen;
                switch (n) {
                    case 1: {
                        this.writeByteAndByte((byte)212, extType);
                        return;
                    }
                    case 2: {
                        this.writeByteAndByte((byte)213, extType);
                        return;
                    }
                    case 4: {
                        this.writeByteAndByte((byte)214, extType);
                        return;
                    }
                    case 8: {
                        this.writeByteAndByte((byte)215, extType);
                        return;
                    }
                    case 16: {
                        this.writeByteAndByte((byte)216, extType);
                        return;
                    }
                }
                this.writeByteAndByte((byte)199, (byte)payloadLen);
                this.buf.write(extType);
                return;
            }
            if (payloadLen < 65536) {
                this.writeByteAndShort((byte)200, (short)payloadLen);
                this.buf.write(extType);
                return;
            }
            this.writeByteAndInt((byte)201, payloadLen);
            this.buf.write(extType);
            return;
        }
        this.writeByteAndInt((byte)201, payloadLen);
        this.buf.write(extType);
    }

    public MsgOutBuffer(ByteArrayOutputStream buf) {
        this.buf = buf;
    }
}

