/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.math.BigInteger;
import msgpack4z.Code$;
import msgpack4z.ExtTypeHeader;
import msgpack4z.MsgInBuffer$;
import msgpack4z.MsgType;
import msgpack4z.MsgUnpacker;
import msgpack4z.OptBool;
import msgpack4z.OptBool$Empty$;
import msgpack4z.OptBool$False$;
import msgpack4z.OptBool$True$;
import msgpack4z.OptByte;
import msgpack4z.OptByte$;
import msgpack4z.OptInt$;
import msgpack4z.OptShort;
import msgpack4z.OptShort$;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uv!\u0002\u00180\u0011\u0003\u0011d!\u0002\u001b0\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004\"\u0002 \u0002\t\u0003yd\u0001\u0002\u001b0\u0005\u0005C\u0001\"\u0014\u0003\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006y\u0011!\t\u0001\u0016\u0005\u0006-\u0012!\ta\u0016\u0005\u0007A\u0012\u0001K\u0011B1\t\r\u0015$\u0001\u0015\"\u0003g\u0011\u0019QG\u0001)C\u0005W\"1A\u000e\u0002Q\u0005\n5Da!\u001d\u0003!\n\u0013\u0011\bB\u0002<\u0005A\u0013%q\u000fC\u0003|\t\u0011\u0005A\u0010C\u0004\u0002\u0002\u0011!\t!a\u0001\t\u000f\u0005-A\u0001\"\u0001\u0002\u000e!9\u0011Q\u0003\u0003\u0005\u0002\u0005]\u0001bBA\u0010\t\u0011\u0005\u0011\u0011\u0005\u0005\u0007\u0003S!A\u0011I7\t\u000f\u0005-B\u0001\"\u0011\u0002.!1\u00111\b\u0003\u0005BIDa!!\u0010\u0005\t\u0003:\bbBA \t\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003\u0003\"A\u0011AA\u0011\u0011\u001d\t\u0019\u0005\u0002C\u0005\u0003\u000bBq!a\u0013\u0005\t\u0003\ti\u0005C\u0004\u0002P\u0011\u0001K\u0011B6\t\u000f\u0005EC\u0001)C\u0005W\"A\u00111\u000b\u0003!\n\u0013\t\t\u0003C\u0004\u0002V\u0011!\t%a\u0016\t\u000f\u0005eC\u0001\"\u0011\u0002\\!9\u00111\r\u0003\u0005B\u0005\u0015\u0004bBA7\t\u0011\u0005\u0013q\u000b\u0005\u0007\u0003_\"A\u0011\t?\t\u000f\u0005ED\u0001\"\u0011\u0002X!9\u00111\u000f\u0003\u0005B\u0005U\u0004bBAG\t\u0011\u0005\u0013q\u000b\u0005\u0007\u0003\u001f#A\u0011I1\t\r\u0005EE\u0001\"\u0011l\u0011\u0019\t\u0019\n\u0002C!W\"1\u0011Q\u0013\u0003\u0005B\u0019Da!a&\u0005\t\u0003Z\u0007bBAM\t\u0011\u0005\u00131\u0014\u0005\b\u00033#A\u0011IAQ\u0011\u001d\t9\u000b\u0002C!\u0003S\u000b1\"T:h\u0013:\u0014UO\u001a4fe*\t\u0001'A\u0005ng\u001e\u0004\u0018mY65u\u000e\u0001\u0001CA\u001a\u0002\u001b\u0005y#aC'tO&s')\u001e4gKJ\u001c\"!\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!'A\u0003baBd\u0017\u0010F\u0002A\u0003c\u0003\"a\r\u0003\u0014\u0007\u0011\u0011%\n\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!A.\u00198h\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\r=\u0013'.Z2u!\t\u00194*\u0003\u0002M_\tYQj]4V]B\f7m[3s\u0003\r\u0011WO\u001a\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u001a\u000b!![8\n\u0005M\u0003&\u0001\u0006\"zi\u0016\f%O]1z\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0006\u0002A+\")QJ\u0002a\u0001\u001d\u0006I1o[5q\u0005f$Xm\u001d\u000b\u00031n\u0003\"aN-\n\u0005iC$\u0001B+oSRDQ\u0001X\u0004A\u0002u\u000b\u0011A\u001c\t\u0003oyK!a\u0018\u001d\u0003\u0007%sG/\u0001\u0005sK\u0006$')\u001f;f)\u0005\u0011\u0007CA\u001cd\u0013\t!\u0007H\u0001\u0003CsR,\u0017!\u0003:fC\u0012\u001c\u0006n\u001c:u)\u00059\u0007CA\u001ci\u0013\tI\u0007HA\u0003TQ>\u0014H/A\u0004sK\u0006$\u0017J\u001c;\u0015\u0003u\u000b\u0001B]3bI2{gn\u001a\u000b\u0002]B\u0011qg\\\u0005\u0003ab\u0012A\u0001T8oO\u0006I!/Z1e\r2|\u0017\r\u001e\u000b\u0002gB\u0011q\u0007^\u0005\u0003kb\u0012QA\u00127pCR\f!B]3bI\u0012{WO\u00197f)\u0005A\bCA\u001cz\u0013\tQ\bH\u0001\u0004E_V\u0014G.Z\u0001\u0013k:\u0004\u0018mY6OS2<\u0016\u000e\u001e5DQ\u0016\u001c7\u000eF\u0001~!\t9d0\u0003\u0002\u0000q\t9!i\\8mK\u0006t\u0017\u0001E;oa\u0006\u001c7NQ8pY\u0016\fgn\u00149u)\t\t)\u0001E\u00024\u0003\u000fI1!!\u00030\u0005\u001dy\u0005\u000f\u001e\"p_2\fQ\"\u001e8qC\u000e\\')\u001f;f\u001fB$HCAA\b!\r\u0019\u0014\u0011C\u0005\u0004\u0003'y#aB(qi\nKH/Z\u0001\u000fk:\u0004\u0018mY6TQ>\u0014Ho\u00149u)\t\tI\u0002E\u00024\u00037I1!!\b0\u0005!y\u0005\u000f^*i_J$\u0018\u0001D;oa\u0006\u001c7.\u00138u\u001fB$HCAA\u0012!\r\u0019\u0014QE\u0005\u0004\u0003Oy#AB(qi&sG/\u0001\u0006v]B\f7m\u001b'p]\u001e\f\u0001#\u001e8qC\u000e\\')[4J]R,w-\u001a:\u0015\u0005\u0005=\u0002\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005Ub)\u0001\u0003nCRD\u0017\u0002BA\u001d\u0003g\u0011!BQ5h\u0013:$XmZ3s\u0003-)h\u000e]1dW\u001acw.\u0019;\u0002\u0019Ut\u0007/Y2l\t>,(\r\\3\u0002)Ut\u0007/Y2l\u0003J\u0014\u0018-\u001f%fC\u0012,'o\u00149u\u0003I)h\u000e]1dW6\u000b\u0007\u000fS3bI\u0016\u0014x\n\u001d;\u0002!I,\u0017\rZ*ue&tw\rS3bI\u0016\u0014H\u0003BA\u0012\u0003\u000fBa!!\u0013\u001a\u0001\u0004\u0011\u0017!\u00012\u0002+Ut\u0007/Y2l%\u0006<8\u000b\u001e:j]\u001eDU-\u00193feV\u0011\u00111E\u0001\u0010e\u0016\fGMT3yi2+gn\u001a;iq\u0005\u0001\"/Z1e\u001d\u0016DH\u000fT3oORD\u0017GN\u0001\u0011e\u0016\fGMT3yi2+gn\u001a;igI\nQa\u00197pg\u0016$\u0012\u0001W\u0001\t]\u0016DH\u000fV=qKR\u0011\u0011Q\f\t\u0004g\u0005}\u0013bAA1_\t9Qj]4UsB,\u0017\u0001D;oa\u0006\u001c7NQ5oCJLHCAA4!\u00119\u0014\u0011\u000e2\n\u0007\u0005-\u0004HA\u0003BeJ\f\u00170\u0001\u0004nCB,e\u000eZ\u0001\u000ek:\u0004\u0018mY6C_>dW-\u00198\u0002\u0013Ut\u0007/Y2l\u001d&d\u0017\u0001D;oa\u0006\u001c7n\u0015;sS:<GCAA<!\u0011\tI(a\"\u000f\t\u0005m\u00141\u0011\t\u0004\u0003{BTBAA@\u0015\r\t\t)M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015\u0005(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\u000bYI\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000bC\u0014\u0001C1se\u0006LXI\u001c3\u0002\u0015Ut\u0007/Y2l\u0005f$X-A\tv]B\f7m[!se\u0006L\b*Z1eKJ\f\u0011\"\u001e8qC\u000e\\\u0017J\u001c;\u0002\u0017Ut\u0007/Y2l'\"|'\u000f^\u0001\u0010k:\u0004\u0018mY6NCBDU-\u00193fe\u0006Y!/Z1e!\u0006LHn\\1e)\u0011\t9'!(\t\r\u0005}5\u00061\u0001^\u0003\u0019aWM\\4uQR\u0019\u0001,a)\t\u000f\u0005\u0015F\u00061\u0001\u0002h\u0005\t\u0011-A\nv]B\f7m[#yiRK\b/\u001a%fC\u0012,'\u000f\u0006\u0002\u0002,B\u00191'!,\n\u0007\u0005=vFA\u0007FqR$\u0016\u0010]3IK\u0006$WM\u001d\u0005\b\u0003g\u001b\u0001\u0019AA4\u0003\u0015\u0011\u0017\u0010^3t\u0001")
public final class MsgInBuffer
implements MsgUnpacker {
    private final ByteArrayInputStream buf;

    public static MsgInBuffer apply(byte[] bytes) {
        return MsgInBuffer$.MODULE$.apply(bytes);
    }

    public void skipBytes(int n) {
        this.buf.skip(n);
    }

    private byte readByte() {
        int b = this.buf.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    private short readShort() {
        int ch2;
        int ch1 = this.buf.read();
        if ((ch1 | (ch2 = this.buf.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    private int readInt() {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.buf.read();
        if ((ch1 | (ch2 = this.buf.read()) | (ch3 = this.buf.read()) | (ch4 = this.buf.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    private long readLong() {
        long ch8;
        long ch7;
        long ch6;
        long ch5;
        long ch4;
        long ch3;
        long ch2;
        long ch1 = this.buf.read();
        if ((ch1 | (ch2 = (long)this.buf.read()) | (ch3 = (long)this.buf.read()) | (ch4 = (long)this.buf.read()) | (ch5 = (long)this.buf.read()) | (ch6 = (long)this.buf.read()) | (ch7 = (long)this.buf.read()) | (ch8 = (long)this.buf.read())) < 0L) {
            throw new EOFException();
        }
        return (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + ch8;
    }

    private float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    private double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public boolean unpackNilWithCheck() {
        return this.readByte() == Code$.MODULE$.NIL();
    }

    public OptBool unpackBooleanOpt() {
        byte by = this.readByte();
        if (Code$.MODULE$.TRUE() == by) {
            return OptBool$True$.MODULE$;
        }
        if (Code$.MODULE$.FALSE() == by) {
            return OptBool$False$.MODULE$;
        }
        return OptBool$Empty$.MODULE$;
    }

    public OptByte unpackByteOpt() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixInt(b)) {
            return OptByte$.MODULE$.apply(b);
        }
        byte by = b;
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = this.readByte();
            if (u8 < 0) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply(u8);
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = this.readShort();
            if (u16 < 0 || u16 > 127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)u16);
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = this.readInt();
            if (u32 < 0 || u32 > 127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)u32);
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = this.readLong();
            if (u64 < 0L || u64 > (long)127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)u64);
        }
        if (Code$.MODULE$.INT8() == by) {
            return OptByte$.MODULE$.apply(this.readByte());
        }
        if (Code$.MODULE$.INT16() == by) {
            short i16 = this.readShort();
            if (i16 < -128 || i16 > 127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)i16);
        }
        if (Code$.MODULE$.INT32() == by) {
            int i32 = this.readInt();
            if (i32 < -128 || i32 > 127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)i32);
        }
        if (Code$.MODULE$.INT64() == by) {
            long i64 = this.readLong();
            if (i64 < (long)-128 || i64 > (long)127) {
                return OptByte$.MODULE$.empty();
            }
            return OptByte$.MODULE$.apply((byte)i64);
        }
        return OptByte$.MODULE$.empty();
    }

    public OptShort unpackShortOpt() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixInt(b)) {
            return OptShort$.MODULE$.apply(b);
        }
        byte by = b;
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = this.readByte();
            return OptShort$.MODULE$.apply((short)(u8 & 0xFF));
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = this.readShort();
            if (u16 < 0) {
                return OptShort$.MODULE$.empty();
            }
            return OptShort$.MODULE$.apply(u16);
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = this.readInt();
            if (u32 < 0 || u32 > Short.MAX_VALUE) {
                return OptShort$.MODULE$.empty();
            }
            return OptShort$.MODULE$.apply((short)u32);
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = this.readLong();
            if (u64 < 0L || u64 > (long)Short.MAX_VALUE) {
                return OptShort$.MODULE$.empty();
            }
            return OptShort$.MODULE$.apply((short)u64);
        }
        if (Code$.MODULE$.INT8() == by) {
            byte i8 = this.readByte();
            return OptShort$.MODULE$.apply(i8);
        }
        if (Code$.MODULE$.INT16() == by) {
            return OptShort$.MODULE$.apply(this.readShort());
        }
        if (Code$.MODULE$.INT32() == by) {
            int i32 = this.readInt();
            if (i32 < Short.MIN_VALUE || i32 > Short.MAX_VALUE) {
                return OptShort$.MODULE$.empty();
            }
            return OptShort$.MODULE$.apply((short)i32);
        }
        if (Code$.MODULE$.INT64() == by) {
            long i64 = this.readLong();
            if (i64 < (long)Short.MIN_VALUE || i64 > (long)Short.MAX_VALUE) {
                return OptShort$.MODULE$.empty();
            }
            return OptShort$.MODULE$.apply((short)i64);
        }
        return OptShort$.MODULE$.empty();
    }

    public long unpackIntOpt() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixInt(b)) {
            return OptInt$.MODULE$.apply(b);
        }
        byte by = b;
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = this.readByte();
            return OptInt$.MODULE$.apply(u8 & 0xFF);
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = this.readShort();
            return OptInt$.MODULE$.apply(u16 & 0xFFFF);
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = this.readInt();
            if (u32 < 0) {
                return OptInt$.MODULE$.empty();
            }
            return OptInt$.MODULE$.apply(u32);
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = this.readLong();
            if (u64 < 0L || u64 > Integer.MAX_VALUE) {
                return OptInt$.MODULE$.empty();
            }
            return OptInt$.MODULE$.apply((int)u64);
        }
        if (Code$.MODULE$.INT8() == by) {
            return OptInt$.MODULE$.apply(this.readByte());
        }
        if (Code$.MODULE$.INT16() == by) {
            return OptInt$.MODULE$.apply(this.readShort());
        }
        if (Code$.MODULE$.INT32() == by) {
            return OptInt$.MODULE$.apply(this.readInt());
        }
        if (Code$.MODULE$.INT64() == by) {
            long i64 = this.readLong();
            if (i64 < Integer.MIN_VALUE || i64 > Integer.MAX_VALUE) {
                return OptInt$.MODULE$.empty();
            }
            return OptInt$.MODULE$.apply((int)i64);
        }
        return OptInt$.MODULE$.empty();
    }

    public long unpackLong() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixInt(b)) {
            return b;
        }
        byte by = b;
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = this.readByte();
            return u8 & 0xFF;
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = this.readShort();
            return u16 & 0xFFFF;
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = this.readInt();
            if (u32 < 0) {
                return (long)(u32 & Integer.MAX_VALUE) + 0x80000000L;
            }
            return u32;
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = this.readLong();
            if (u64 < 0L) {
                throw new RuntimeException(new StringBuilder(9).append("overflow ").append(u64).toString());
            }
            return u64;
        }
        if (Code$.MODULE$.INT8() == by) {
            return this.readByte();
        }
        if (Code$.MODULE$.INT16() == by) {
            return this.readShort();
        }
        if (Code$.MODULE$.INT32() == by) {
            return this.readInt();
        }
        if (Code$.MODULE$.INT64() == by) {
            return this.readLong();
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public BigInteger unpackBigInteger() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixInt(b)) {
            return BigInteger.valueOf(b);
        }
        byte by = b;
        if (Code$.MODULE$.UINT8() == by) {
            byte u8 = this.readByte();
            return BigInteger.valueOf(u8 & 0xFF);
        }
        if (Code$.MODULE$.UINT16() == by) {
            short u16 = this.readShort();
            return BigInteger.valueOf(u16 & 0xFFFF);
        }
        if (Code$.MODULE$.UINT32() == by) {
            int u32 = this.readInt();
            if (u32 < 0) {
                return BigInteger.valueOf((long)(u32 & Integer.MAX_VALUE) + 0x80000000L);
            }
            return BigInteger.valueOf(u32);
        }
        if (Code$.MODULE$.UINT64() == by) {
            long u64 = this.readLong();
            if (u64 < 0L) {
                return BigInteger.valueOf(u64 + Long.MAX_VALUE + 1L).setBit(63);
            }
            return BigInteger.valueOf(u64);
        }
        if (Code$.MODULE$.INT8() == by) {
            byte i8 = this.readByte();
            return BigInteger.valueOf(i8);
        }
        if (Code$.MODULE$.INT16() == by) {
            short i16 = this.readShort();
            return BigInteger.valueOf(i16);
        }
        if (Code$.MODULE$.INT32() == by) {
            int i32 = this.readInt();
            return BigInteger.valueOf(i32);
        }
        if (Code$.MODULE$.INT64() == by) {
            return BigInteger.valueOf(this.readLong());
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public float unpackFloat() {
        byte b;
        byte by = b = this.readByte();
        if (Code$.MODULE$.FLOAT32() == by) {
            return this.readFloat();
        }
        if (Code$.MODULE$.FLOAT64() == by) {
            return (float)this.readDouble();
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public double unpackDouble() {
        byte b;
        byte by = b = this.readByte();
        if (Code$.MODULE$.FLOAT32() == by) {
            return this.readFloat();
        }
        if (Code$.MODULE$.FLOAT64() == by) {
            return this.readDouble();
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public long unpackArrayHeaderOpt() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixedArray(b)) {
            return OptInt$.MODULE$.apply(b & 0xF);
        }
        byte by = b;
        if (Code$.MODULE$.ARRAY16() == by) {
            return OptInt$.MODULE$.apply(this.readNextLength16());
        }
        if (Code$.MODULE$.ARRAY32() == by) {
            return OptInt$.MODULE$.apply(this.readInt());
        }
        return OptInt$.MODULE$.empty();
    }

    public long unpackMapHeaderOpt() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixedMap(b)) {
            return OptInt$.MODULE$.apply(b & 0xF);
        }
        byte by = b;
        if (Code$.MODULE$.MAP16() == by) {
            return OptInt$.MODULE$.apply(this.readNextLength16());
        }
        if (Code$.MODULE$.MAP32() == by) {
            return OptInt$.MODULE$.apply(this.readInt());
        }
        return OptInt$.MODULE$.empty();
    }

    private long readStringHeader(byte b) {
        byte by = b;
        if (Code$.MODULE$.STR8() == by) {
            return OptInt$.MODULE$.apply(this.readNextLength8());
        }
        if (Code$.MODULE$.STR16() == by) {
            return OptInt$.MODULE$.apply(this.readNextLength16());
        }
        if (Code$.MODULE$.STR32() == by) {
            return this.readNextLength32();
        }
        return OptInt$.MODULE$.empty();
    }

    public long unpackRawStringHeader() {
        byte b = this.readByte();
        if (Code$.MODULE$.isFixedRaw(b)) {
            return OptInt$.MODULE$.apply(b & 0x1F);
        }
        return this.readStringHeader(b);
    }

    private int readNextLength8() {
        return this.readByte() & 0xFF;
    }

    private int readNextLength16() {
        return this.readShort() & 0xFFFF;
    }

    private long readNextLength32() {
        int u32 = this.readInt();
        if (u32 < 0) {
            return OptInt$.MODULE$.empty();
        }
        return OptInt$.MODULE$.apply(u32);
    }

    public void close() {
        this.buf.close();
    }

    public MsgType nextType() {
        if (this.buf.markSupported()) {
            MsgType msgType;
            this.buf.mark(1024);
            try {
                msgType = Code$.MODULE$.getType(this.readByte());
            }
            finally {
                this.buf.reset();
            }
            return msgType;
        }
        throw package$.MODULE$.error("mark not supported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] unpackBinary() {
        int n;
        byte b = this.readByte();
        if (Code$.MODULE$.isFixedRaw(b)) {
            n = 0x1F & b;
        } else {
            byte by = b;
            if (Code$.MODULE$.BIN8() == by) {
                n = this.readNextLength8();
            } else if (Code$.MODULE$.BIN16() == by) {
                n = this.readNextLength16();
            } else {
                int l;
                if (Code$.MODULE$.BIN32() != by) throw package$.MODULE$.error(new StringBuilder(18).append("not binary header ").append(b).toString());
                long l2 = this.readNextLength32();
                long l3 = OptInt$.MODULE$.unapply(l2);
                if (OptInt$.MODULE$.isEmpty$extension(l3)) throw package$.MODULE$.error("binary header length overflow");
                n = l = OptInt$.MODULE$.get$extension(l3);
            }
        }
        int len = n;
        byte[] array = new byte[len];
        this.buf.read(array);
        return array;
    }

    public void mapEnd() {
    }

    public boolean unpackBoolean() {
        return this.unpackBooleanOpt().get();
    }

    public void unpackNil() {
        Predef$.MODULE$.assert(this.unpackNilWithCheck());
    }

    public String unpackString() {
        int n;
        byte b = this.readByte();
        if (Code$.MODULE$.isFixStr(b)) {
            n = 0x1F & b;
        } else {
            byte by = b;
            if (Code$.MODULE$.STR8() == by) {
                n = this.readNextLength8();
            } else if (Code$.MODULE$.STR16() == by) {
                n = this.readNextLength16();
            } else if (Code$.MODULE$.STR32() == by) {
                n = OptInt$.MODULE$.get$extension(this.readNextLength32());
            } else {
                throw package$.MODULE$.error(new StringBuilder(18).append("not string header ").append(b).toString());
            }
        }
        int len = n;
        byte[] array = new byte[len];
        this.buf.read(array);
        return new String(array, "UTF-8");
    }

    public void arrayEnd() {
    }

    public byte unpackByte() {
        return this.unpackByteOpt().get();
    }

    public int unpackArrayHeader() {
        return OptInt$.MODULE$.get$extension(this.unpackArrayHeaderOpt());
    }

    public int unpackInt() {
        return OptInt$.MODULE$.get$extension(this.unpackIntOpt());
    }

    public short unpackShort() {
        return this.unpackShortOpt().get();
    }

    public int unpackMapHeader() {
        return OptInt$.MODULE$.get$extension(this.unpackMapHeaderOpt());
    }

    public byte[] readPayload(int length) {
        byte[] array = new byte[length];
        this.buf.read(array);
        return array;
    }

    public void readPayload(byte[] a) {
        this.buf.read(a);
    }

    public ExtTypeHeader unpackExtTypeHeader() {
        byte by = this.readByte();
        if (Code$.MODULE$.FIXEXT1() == by) {
            return new ExtTypeHeader(this.readByte(), 1);
        }
        if (Code$.MODULE$.FIXEXT2() == by) {
            return new ExtTypeHeader(this.readByte(), 2);
        }
        if (Code$.MODULE$.FIXEXT4() == by) {
            return new ExtTypeHeader(this.readByte(), 4);
        }
        if (Code$.MODULE$.FIXEXT8() == by) {
            return new ExtTypeHeader(this.readByte(), 8);
        }
        if (Code$.MODULE$.FIXEXT16() == by) {
            return new ExtTypeHeader(this.readByte(), 16);
        }
        if (Code$.MODULE$.EXT8() == by) {
            int length = this.readByte() & 0xFF;
            byte tpe = this.readByte();
            return new ExtTypeHeader(tpe, length);
        }
        if (Code$.MODULE$.EXT16() == by) {
            int length = this.readShort() & 0xFFFF;
            byte tpe = this.readByte();
            return new ExtTypeHeader(tpe, length);
        }
        if (Code$.MODULE$.EXT32() == by) {
            int length = this.readInt();
            byte tpe = this.readByte();
            return new ExtTypeHeader(tpe, length);
        }
        throw package$.MODULE$.error(new StringBuilder(16).append("unexpected type ").append(by).toString());
    }

    public MsgInBuffer(ByteArrayInputStream buf) {
        this.buf = buf;
    }
}

