/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import msgpack4z.MsgType;

public final class Code$ {
    public static final Code$ MODULE$;
    private static final byte POSFIXINT_MASK;
    private static final byte FIXMAP_PREFIX;
    private static final byte FIXARRAY_PREFIX;
    private static final byte FIXSTR_PREFIX;
    private static final byte NIL;
    private static final byte FALSE;
    private static final byte TRUE;
    private static final byte BIN8;
    private static final byte BIN16;
    private static final byte BIN32;
    private static final byte EXT8;
    private static final byte EXT16;
    private static final byte EXT32;
    private static final byte FLOAT32;
    private static final byte FLOAT64;
    private static final byte UINT8;
    private static final byte UINT16;
    private static final byte UINT32;
    private static final byte UINT64;
    private static final byte INT8;
    private static final byte INT16;
    private static final byte INT32;
    private static final byte INT64;
    private static final byte FIXEXT1;
    private static final byte FIXEXT2;
    private static final byte FIXEXT4;
    private static final byte FIXEXT8;
    private static final byte FIXEXT16;
    private static final byte STR8;
    private static final byte STR16;
    private static final byte STR32;
    private static final byte ARRAY16;
    private static final byte ARRAY32;
    private static final byte MAP16;
    private static final byte MAP32;
    private static final byte NEGFIXINT_PREFIX;
    private static final MsgType[] formatTable;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new Code$();
        POSFIXINT_MASK = (byte)128;
        FIXMAP_PREFIX = (byte)128;
        FIXARRAY_PREFIX = (byte)144;
        FIXSTR_PREFIX = (byte)160;
        NIL = (byte)192;
        FALSE = (byte)194;
        TRUE = (byte)195;
        BIN8 = (byte)196;
        BIN16 = (byte)197;
        BIN32 = (byte)198;
        EXT8 = (byte)199;
        EXT16 = (byte)200;
        EXT32 = (byte)201;
        FLOAT32 = (byte)202;
        FLOAT64 = (byte)203;
        UINT8 = (byte)204;
        UINT16 = (byte)205;
        UINT32 = (byte)206;
        UINT64 = (byte)207;
        INT8 = (byte)208;
        INT16 = (byte)209;
        INT32 = (byte)210;
        INT64 = (byte)211;
        FIXEXT1 = (byte)212;
        FIXEXT2 = (byte)213;
        FIXEXT4 = (byte)214;
        FIXEXT8 = (byte)215;
        FIXEXT16 = (byte)216;
        STR8 = (byte)217;
        STR16 = (byte)218;
        STR32 = (byte)219;
        ARRAY16 = (byte)220;
        ARRAY32 = (byte)221;
        MAP16 = (byte)222;
        MAP32 = (byte)223;
        NEGFIXINT_PREFIX = (byte)224;
        MsgType[] array = new MsgType[256];
        for (int b = 0; b <= 255; ++b) {
            array[b] = MODULE$.getType0((byte)b);
        }
        formatTable = var0;
    }

    public boolean isFixInt(byte b) {
        int v = b & 0xFF;
        return v <= 127 || v >= 224;
    }

    public boolean isPosFixInt(byte b) {
        return (byte)(b & this.POSFIXINT_MASK()) == 0;
    }

    public boolean isNegFixInt(byte b) {
        return (byte)(b & this.NEGFIXINT_PREFIX()) == this.NEGFIXINT_PREFIX();
    }

    public boolean isFixStr(byte b) {
        return (byte)(b & (byte)224) == this.FIXSTR_PREFIX();
    }

    public boolean isFixedArray(byte b) {
        return (byte)(b & (byte)240) == this.FIXARRAY_PREFIX();
    }

    public boolean isFixedMap(byte b) {
        return (byte)(b & (byte)240) == this.FIXMAP_PREFIX();
    }

    public boolean isFixedRaw(byte b) {
        return (byte)(b & (byte)224) == this.FIXSTR_PREFIX();
    }

    public byte POSFIXINT_MASK() {
        return POSFIXINT_MASK;
    }

    public byte FIXMAP_PREFIX() {
        return FIXMAP_PREFIX;
    }

    public byte FIXARRAY_PREFIX() {
        return FIXARRAY_PREFIX;
    }

    public byte FIXSTR_PREFIX() {
        return FIXSTR_PREFIX;
    }

    public byte NIL() {
        return NIL;
    }

    public byte FALSE() {
        return FALSE;
    }

    public byte TRUE() {
        return TRUE;
    }

    public byte BIN8() {
        return BIN8;
    }

    public byte BIN16() {
        return BIN16;
    }

    public byte BIN32() {
        return BIN32;
    }

    public byte EXT8() {
        return EXT8;
    }

    public byte EXT16() {
        return EXT16;
    }

    public byte EXT32() {
        return EXT32;
    }

    public byte FLOAT32() {
        return FLOAT32;
    }

    public byte FLOAT64() {
        return FLOAT64;
    }

    public byte UINT8() {
        return UINT8;
    }

    public byte UINT16() {
        return UINT16;
    }

    public byte UINT32() {
        return UINT32;
    }

    public byte UINT64() {
        return UINT64;
    }

    public byte INT8() {
        return INT8;
    }

    public byte INT16() {
        return INT16;
    }

    public byte INT32() {
        return INT32;
    }

    public byte INT64() {
        return INT64;
    }

    public byte FIXEXT1() {
        return FIXEXT1;
    }

    public byte FIXEXT2() {
        return FIXEXT2;
    }

    public byte FIXEXT4() {
        return FIXEXT4;
    }

    public byte FIXEXT8() {
        return FIXEXT8;
    }

    public byte FIXEXT16() {
        return FIXEXT16;
    }

    public byte STR8() {
        return STR8;
    }

    public byte STR16() {
        return STR16;
    }

    public byte STR32() {
        return STR32;
    }

    public byte ARRAY16() {
        return ARRAY16;
    }

    public byte ARRAY32() {
        return ARRAY32;
    }

    public byte MAP16() {
        return MAP16;
    }

    public byte MAP32() {
        return MAP32;
    }

    public byte NEGFIXINT_PREFIX() {
        return NEGFIXINT_PREFIX;
    }

    public MsgType getType(byte b) {
        MsgType t = formatTable[b & 0xFF];
        if (t == null) {
            throw new RuntimeException(new StringBuilder(13).append("invalid byte ").append(b).toString());
        }
        return t;
    }

    private MsgType getType0(byte b) {
        if (this.isPosFixInt(b) || this.isNegFixInt(b)) {
            return MsgType.INTEGER;
        }
        if (this.isFixStr(b)) {
            return MsgType.STRING;
        }
        if (this.isFixedArray(b)) {
            return MsgType.ARRAY;
        }
        if (this.isFixedMap(b)) {
            return MsgType.MAP;
        }
        byte by = b;
        if (this.NIL() == by) {
            return MsgType.NIL;
        }
        if (this.FALSE() == by ? true : this.TRUE() == by) {
            return MsgType.BOOLEAN;
        }
        if (this.BIN8() == by ? true : (this.BIN16() == by ? true : this.BIN32() == by)) {
            return MsgType.BINARY;
        }
        if (this.FLOAT32() == by ? true : this.FLOAT64() == by) {
            return MsgType.FLOAT;
        }
        if (this.UINT8() == by ? true : (this.UINT16() == by ? true : (this.UINT32() == by ? true : (this.UINT64() == by ? true : (this.INT8() == by ? true : (this.INT16() == by ? true : (this.INT32() == by ? true : this.INT64() == by))))))) {
            return MsgType.INTEGER;
        }
        if (this.STR8() == by ? true : (this.STR16() == by ? true : this.STR32() == by)) {
            return MsgType.STRING;
        }
        if (this.ARRAY16() == by ? true : this.ARRAY32() == by) {
            return MsgType.ARRAY;
        }
        if (this.MAP16() == by ? true : this.MAP32() == by) {
            return MsgType.MAP;
        }
        if (this.FIXEXT1() == by ? true : (this.FIXEXT2() == by ? true : (this.FIXEXT4() == by ? true : (this.FIXEXT8() == by ? true : (this.FIXEXT16() == by ? true : (this.EXT8() == by ? true : (this.EXT16() == by ? true : this.EXT32() == by))))))) {
            return MsgType.EXTENSION;
        }
        return null;
    }

    private Code$() {
    }
}

