/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import java.math.BigInteger;
import msgpack4z.CirceMsgpack;
import msgpack4z.CirceMsgpack$Result$;
import msgpack4z.CirceUnpackOptions;
import msgpack4z.CodecCirceJson;
import msgpack4z.CodecCirceJsonObject;
import msgpack4z.MsgPacker;
import msgpack4z.MsgType;
import msgpack4z.MsgUnpacker;
import msgpack4z.MsgpackCodec;
import msgpack4z.Other;
import msgpack4z.UnpackError;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scalaz.;
import scalaz.Equal;
import scalaz.Equal$;

public final class CirceMsgpack$ {
    public static final CirceMsgpack$ MODULE$;
    private final Equal<Json> circeJsonEqual;
    private final Equal<JsonObject> circeJsonObjectEqual;
    private final Equal<JsonNumber> circeJsonNumberEqual;
    private final BigInteger BigIntegerLongMax;
    public final BigDecimal msgpack4z$CirceMsgpack$$BigDecimalLongMax2x;
    private final BigInteger BigIntegerLongMin;

    static {
        new CirceMsgpack$();
    }

    public Equal<Json> circeJsonEqual() {
        return this.circeJsonEqual;
    }

    public Equal<JsonObject> circeJsonObjectEqual() {
        return this.circeJsonObjectEqual;
    }

    public Equal<JsonNumber> circeJsonNumberEqual() {
        return this.circeJsonNumberEqual;
    }

    public MsgpackCodec<Json> jsonCodec(CirceUnpackOptions options) {
        return new CodecCirceJson(options);
    }

    public MsgpackCodec<JsonObject> jsonObjectCodec(CirceUnpackOptions options) {
        return new CodecCirceJsonObject(options);
    }

    public Tuple2<MsgpackCodec<Json>, MsgpackCodec<JsonObject>> allCodec(CirceUnpackOptions options) {
        return new Tuple2(this.jsonCodec(options), this.jsonObjectCodec(options));
    }

    public void jsonObject2msgpack(MsgPacker packer, JsonObject obj) {
        List fields = obj.toList();
        packer.packMapHeader(fields.size());
        fields.foreach((Function1)new Serializable(packer){
            public static final long serialVersionUID = 0L;
            private final MsgPacker packer$1;

            public final void apply(Tuple2<String, Json> field) {
                this.packer$1.packString((String)field._1());
                CirceMsgpack$.MODULE$.json2msgpack(this.packer$1, (Json)field._2());
            }
            {
                this.packer$1 = packer$1;
            }
        });
        packer.mapEnd();
    }

    public void jsonArray2msgpack(MsgPacker packer, Seq<Json> array) {
        packer.packArrayHeader(array.size());
        array.foreach((Function1)new Serializable(packer){
            public static final long serialVersionUID = 0L;
            private final MsgPacker packer$3;

            public final void apply(Json x) {
                CirceMsgpack$.MODULE$.json2msgpack(this.packer$3, x);
            }
            {
                this.packer$3 = packer$3;
            }
        });
        packer.arrayEnd();
    }

    public void json2msgpack(MsgPacker packer, Json json) {
        json.fold((Function0)new Serializable(packer){
            public static final long serialVersionUID = 0L;
            private final MsgPacker packer$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.packer$2.packNil();
            }
            {
                this.packer$2 = packer$2;
            }
        }, (Function1)new Serializable(packer){
            public static final long serialVersionUID = 0L;
            private final MsgPacker packer$2;

            public final void apply(boolean value) {
                this.packer$2.packBoolean(value);
            }
            {
                this.packer$2 = packer$2;
            }
        }, (Function1)new Serializable(packer){
            public static final long serialVersionUID = 0L;
            private final MsgPacker packer$2;

            public final void apply(JsonNumber value) {
                Option option;
                block7: {
                    Option option2;
                    block10: {
                        block6: {
                            block9: {
                                block8: {
                                    BoxedUnit boxedUnit;
                                    block5: {
                                        option = value.toLong();
                                        if (!(option instanceof Some)) break block5;
                                        Some some = (Some)option;
                                        long l = BoxesRunTime.unboxToLong((Object)some.x());
                                        this.packer$2.packLong(l);
                                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                        break block6;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block7;
                                    option2 = value.toBigDecimal();
                                    if (!(option2 instanceof Some)) break block8;
                                    Some some = (Some)option2;
                                    BigDecimal b = (BigDecimal)some.x();
                                    if (b.isWhole() && BigDecimal$.MODULE$.long2bigDecimal(Long.MIN_VALUE).$less$eq(b) && b.$less(CirceMsgpack$.MODULE$.msgpack4z$CirceMsgpack$$BigDecimalLongMax2x)) {
                                        this.packer$2.packBigInteger(b.underlying().toBigIntegerExact());
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        this.packer$2.packDouble(value.toDouble());
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit3 = boxedUnit;
                                    break block9;
                                }
                                if (!None$.MODULE$.equals(option2)) break block10;
                                this.packer$2.packDouble(value.toDouble());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError((Object)option2);
                }
                throw new MatchError((Object)option);
            }
            {
                this.packer$2 = packer$2;
            }
        }, (Function1)new Serializable(packer){
            public static final long serialVersionUID = 0L;
            private final MsgPacker packer$2;

            public final void apply(String string) {
                this.packer$2.packString(string);
            }
            {
                this.packer$2 = packer$2;
            }
        }, (Function1)new Serializable(packer){
            public static final long serialVersionUID = 0L;
            private final MsgPacker packer$2;

            public final void apply(Vector<Json> array) {
                CirceMsgpack$.MODULE$.jsonArray2msgpack(this.packer$2, (Seq<Json>)array);
            }
            {
                this.packer$2 = packer$2;
            }
        }, (Function1)new Serializable(packer){
            public static final long serialVersionUID = 0L;
            private final MsgPacker packer$2;

            public final void apply(JsonObject obj) {
                CirceMsgpack$.MODULE$.jsonObject2msgpack(this.packer$2, obj);
            }
            {
                this.packer$2 = packer$2;
            }
        });
    }

    public .bslash.div<UnpackError, Json> msgpack2json(MsgUnpacker unpacker, CirceUnpackOptions unpackOptions) {
        CirceMsgpack.Result<Json> result = CirceMsgpack$Result$.MODULE$.empty();
        return this.msgpack2json0(unpacker, result, unpackOptions) ? new .bslash.div.minus((Object)result.value()) : new .minus.bslash.div((Object)result.error());
    }

    public .bslash.div<UnpackError, JsonObject> msgpack2jsonObject(MsgUnpacker unpacker, CirceUnpackOptions unpackOptions) {
        CirceMsgpack.Result<JsonObject> result = CirceMsgpack$Result$.MODULE$.empty();
        return this.msgpack2jsObj0(unpacker, result, unpackOptions) ? new .bslash.div.minus((Object)result.value()) : new .minus.bslash.div((Object)result.error());
    }

    public .bslash.div<UnpackError, List<Json>> msgpack2jsonArray(MsgUnpacker unpacker, CirceUnpackOptions unpackOptions) {
        CirceMsgpack.Result<List<Json>> result = CirceMsgpack$Result$.MODULE$.empty();
        return this.msgpack2jsArray0(unpacker, result, unpackOptions) ? new .bslash.div.minus(result.value()) : new .minus.bslash.div((Object)result.error());
    }

    private boolean msgpack2jsObj0(MsgUnpacker unpacker, CirceMsgpack.Result<JsonObject> result, CirceUnpackOptions unpackOptions) {
        int size = unpacker.unpackMapHeader();
        ObjectRef obj = ObjectRef.create((Object)JsonObject$.MODULE$.empty());
        IntRef i = IntRef.create((int)0);
        CirceMsgpack.Result mapElem = CirceMsgpack$Result$.MODULE$.empty();
        BooleanRef success = BooleanRef.create((boolean)true);
        while (i.elem < size && success.elem) {
            BoxedUnit boxedUnit;
            MsgType tpe;
            MsgType msgType = tpe = unpacker.nextType();
            MsgType.STRING$ sTRING$ = MsgType.STRING$.MODULE$;
            if (!(msgType != null ? !msgType.equals(sTRING$) : sTRING$ != null)) {
                this.process$1(unpacker.unpackString(), unpacker, result, unpackOptions, obj, i, mapElem, success);
                continue;
            }
            Option option = (Option)unpackOptions.nonStringKey().apply((Object)tpe, (Object)unpacker);
            if (option instanceof Some) {
                Some some = (Some)option;
                String key = (String)some.x();
                this.process$1(key, unpacker, result, unpackOptions, obj, i, mapElem, success);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                success.elem = false;
                result.error_$eq((UnpackError)new Other("not string key"));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)option);
        }
        unpacker.mapEnd();
        if (success.elem) {
            result.value_$eq((JsonObject)obj.elem);
        }
        return success.elem;
    }

    private boolean msgpack2jsArray0(MsgUnpacker unpacker, CirceMsgpack.Result<List<Json>> result, CirceUnpackOptions unpackOptions) {
        int size = unpacker.unpackArrayHeader();
        Json[] array = new Json[size];
        int i = 0;
        CirceMsgpack.Result<Object> arrayElem = new CirceMsgpack.Result<Object>(null, null);
        boolean success = true;
        while (i < size && success) {
            if (this.msgpack2json0(unpacker, arrayElem, unpackOptions)) {
                array[i] = arrayElem.value();
                ++i;
                continue;
            }
            result.error_$eq(arrayElem.error());
            success = false;
        }
        unpacker.arrayEnd();
        if (success) {
            result.value_$eq((List<Json>)Predef$.MODULE$.refArrayOps((Object[])array).toList());
        }
        return success;
    }

    private boolean isValidLong(BigInteger value) {
        return this.BigIntegerLongMin.compareTo(value) <= 0 && value.compareTo(this.BigIntegerLongMax) <= 0;
    }

    public boolean msgpack2json0(MsgUnpacker unpacker, CirceMsgpack.Result<Json> result, CirceUnpackOptions unpackOptions) {
        MsgType msgType;
        block22: {
            boolean bl;
            block14: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    Boolean bl2;
                                    block16: {
                                        block15: {
                                            block13: {
                                                msgType = unpacker.nextType();
                                                if (!MsgType.NIL$.MODULE$.equals(msgType)) break block13;
                                                unpacker.unpackNil();
                                                result.value_$eq(Json$.MODULE$.Null());
                                                bl = true;
                                                break block14;
                                            }
                                            if (!MsgType.BOOLEAN$.MODULE$.equals(msgType)) break block15;
                                            if (unpacker.unpackBoolean()) {
                                                result.value_$eq(Json$.MODULE$.True());
                                            } else {
                                                result.value_$eq(Json$.MODULE$.False());
                                            }
                                            bl = true;
                                            break block14;
                                        }
                                        if (!MsgType.INTEGER$.MODULE$.equals(msgType)) break block16;
                                        BigInteger value = unpacker.unpackBigInteger();
                                        if (this.isValidLong(value)) {
                                            result.value_$eq(Json$.MODULE$.fromLong(value.longValue()));
                                        } else {
                                            result.value_$eq(Json$.MODULE$.fromBigDecimal(package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(value))));
                                        }
                                        bl = true;
                                        break block14;
                                    }
                                    if (!MsgType.FLOAT$.MODULE$.equals(msgType)) break block17;
                                    double f = unpacker.unpackDouble();
                                    if (RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(f))) {
                                        bl2 = BoxesRunTime.boxToBoolean((boolean)CirceMsgpack$Result$.MODULE$.fromEither(unpackOptions.positiveInf(), result));
                                    } else if (RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(f))) {
                                        bl2 = BoxesRunTime.boxToBoolean((boolean)CirceMsgpack$Result$.MODULE$.fromEither(unpackOptions.negativeInf(), result));
                                    } else if (Double.isNaN(f)) {
                                        bl2 = BoxesRunTime.boxToBoolean((boolean)CirceMsgpack$Result$.MODULE$.fromEither(unpackOptions.nan(), result));
                                    } else {
                                        result.value_$eq(Json$.MODULE$.fromDoubleOrNull(f));
                                        bl2 = BoxedUnit.UNIT;
                                    }
                                    bl = true;
                                    break block14;
                                }
                                if (!MsgType.STRING$.MODULE$.equals(msgType)) break block18;
                                result.value_$eq(Json$.MODULE$.fromString(unpacker.unpackString()));
                                bl = true;
                                break block14;
                            }
                            if (!MsgType.ARRAY$.MODULE$.equals(msgType)) break block19;
                            CirceMsgpack.Result<List<Json>> result0 = CirceMsgpack$Result$.MODULE$.empty();
                            boolean r = this.msgpack2jsArray0(unpacker, result0, unpackOptions);
                            result.error_$eq(result0.error());
                            result.value_$eq(Json$.MODULE$.fromValues((Iterable)result0.value()));
                            bl = r;
                            break block14;
                        }
                        if (!MsgType.MAP$.MODULE$.equals(msgType)) break block20;
                        CirceMsgpack.Result<JsonObject> result0 = CirceMsgpack$Result$.MODULE$.empty();
                        boolean r = this.msgpack2jsObj0(unpacker, result0, unpackOptions);
                        result.error_$eq(result0.error());
                        result.value_$eq(Json$.MODULE$.fromJsonObject(result0.value()));
                        bl = r;
                        break block14;
                    }
                    if (!MsgType.BINARY$.MODULE$.equals(msgType)) break block21;
                    bl = CirceMsgpack$Result$.MODULE$.fromEither((.bslash.div)unpackOptions.binary().apply((Object)unpacker), result);
                    break block14;
                }
                if (!MsgType.EXTENSION$.MODULE$.equals(msgType)) break block22;
                bl = CirceMsgpack$Result$.MODULE$.fromEither((.bslash.div)unpackOptions.extension().apply((Object)unpacker), result);
            }
            return bl;
        }
        throw new MatchError((Object)msgType);
    }

    private final void process$1(String key, MsgUnpacker unpacker$1, CirceMsgpack.Result result$1, CirceUnpackOptions unpackOptions$3, ObjectRef obj$1, IntRef i$1, CirceMsgpack.Result mapElem$1, BooleanRef success$1) {
        if (this.msgpack2json0(unpacker$1, mapElem$1, unpackOptions$3)) {
            obj$1.elem = ((JsonObject)obj$1.elem).add(key, (Json)mapElem$1.value());
            ++i$1.elem;
        } else {
            result$1.error_$eq(mapElem$1.error());
            success$1.elem = false;
        }
    }

    private CirceMsgpack$() {
        MODULE$ = this;
        this.circeJsonEqual = Equal$.MODULE$.equalA();
        this.circeJsonObjectEqual = Equal$.MODULE$.equalA();
        this.circeJsonNumberEqual = Equal$.MODULE$.equalA();
        this.BigIntegerLongMax = BigInteger.valueOf(Long.MAX_VALUE);
        this.msgpack4z$CirceMsgpack$$BigDecimalLongMax2x = package$.MODULE$.BigDecimal().apply(Long.MAX_VALUE).$times(BigDecimal$.MODULE$.int2bigDecimal(2));
        this.BigIntegerLongMin = BigInteger.valueOf(Long.MIN_VALUE);
    }
}

