/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import argonaut.Json;
import argonaut.Json$;
import argonaut.JsonBigDecimal;
import argonaut.JsonDecimal;
import argonaut.JsonLong;
import argonaut.JsonNumber;
import argonaut.JsonObject;
import argonaut.JsonObject$;
import java.io.Serializable;
import java.math.BigInteger;
import msgpack4z.ArgonautMsgpack;
import msgpack4z.ArgonautMsgpack$Result$;
import msgpack4z.ArgonautUnpackOptions;
import msgpack4z.CodecArgonautJson;
import msgpack4z.CodecArgonautJsonArray;
import msgpack4z.CodecArgonautJsonObject;
import msgpack4z.MsgPacker;
import msgpack4z.MsgType;
import msgpack4z.MsgUnpacker;
import msgpack4z.MsgpackCodec;
import msgpack4z.Other;
import msgpack4z.UnpackError;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scalaz.;
import scalaz.$bslash$div$minus$;
import scalaz.$minus$bslash$div$;

public final class ArgonautMsgpack$ {
    public static final ArgonautMsgpack$ MODULE$ = new ArgonautMsgpack$();
    private static final BigInteger BigIntegerLongMax = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger BigIntegerLongMin = BigInteger.valueOf(Long.MIN_VALUE);

    public MsgpackCodec<Json> jsonCodec(ArgonautUnpackOptions options) {
        return new CodecArgonautJson(options);
    }

    public MsgpackCodec<List<Json>> jsonArrayCodec(ArgonautUnpackOptions options) {
        return new CodecArgonautJsonArray(options);
    }

    public MsgpackCodec<JsonObject> jsonObjectCodec(ArgonautUnpackOptions options) {
        return new CodecArgonautJsonObject(options);
    }

    public Tuple3<MsgpackCodec<Json>, MsgpackCodec<List<Json>>, MsgpackCodec<JsonObject>> allCodec(ArgonautUnpackOptions options) {
        return new Tuple3(this.jsonCodec(options), this.jsonArrayCodec(options), this.jsonObjectCodec(options));
    }

    public void jsonObject2msgpack(MsgPacker packer, JsonObject obj) {
        List fields = obj.toList();
        packer.packMapHeader(fields.size());
        fields.foreach((Function1 & Serializable)field -> {
            ArgonautMsgpack$.$anonfun$jsonObject2msgpack$1(packer, field);
            return BoxedUnit.UNIT;
        });
        packer.mapEnd();
    }

    public void jsonArray2msgpack(MsgPacker packer, List<Json> array) {
        packer.packArrayHeader(array.size());
        array.foreach((Function1 & Serializable)x -> {
            ArgonautMsgpack$.MODULE$.json2msgpack(packer, x);
            return BoxedUnit.UNIT;
        });
        packer.arrayEnd();
    }

    public void json2msgpack(MsgPacker packer, Json json) {
        json.fold((Function0)(JFunction0.mcV.sp & Serializable)() -> packer.packNil(), (Function1 & Serializable)value -> {
            packer.packBoolean(BoxesRunTime.unboxToBoolean((Object)value));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x0$1 -> {
            ArgonautMsgpack$.$anonfun$json2msgpack$3(packer, x0$1);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)string -> {
            packer.packString(string);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)array -> {
            ArgonautMsgpack$.MODULE$.jsonArray2msgpack(packer, (List<Json>)array);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)obj -> {
            ArgonautMsgpack$.MODULE$.jsonObject2msgpack(packer, obj);
            return BoxedUnit.UNIT;
        });
    }

    public .bslash.div<UnpackError, Json> msgpack2json(MsgUnpacker unpacker, ArgonautUnpackOptions unpackOptions) {
        ArgonautMsgpack.Result<Json> result = ArgonautMsgpack$Result$.MODULE$.empty();
        return this.msgpack2json0(unpacker, result, unpackOptions) ? $bslash$div$minus$.MODULE$.apply((Object)result.value()) : $minus$bslash$div$.MODULE$.apply((Object)result.error());
    }

    public .bslash.div<UnpackError, JsonObject> msgpack2jsonObject(MsgUnpacker unpacker, ArgonautUnpackOptions unpackOptions) {
        ArgonautMsgpack.Result<JsonObject> result = ArgonautMsgpack$Result$.MODULE$.empty();
        return this.msgpack2jsObj0(unpacker, result, unpackOptions) ? $bslash$div$minus$.MODULE$.apply((Object)result.value()) : $minus$bslash$div$.MODULE$.apply((Object)result.error());
    }

    public .bslash.div<UnpackError, List<Json>> msgpack2jsonArray(MsgUnpacker unpacker, ArgonautUnpackOptions unpackOptions) {
        ArgonautMsgpack.Result<List<Json>> result = ArgonautMsgpack$Result$.MODULE$.empty();
        return this.msgpack2jsArray0(unpacker, result, unpackOptions) ? $bslash$div$minus$.MODULE$.apply(result.value()) : $minus$bslash$div$.MODULE$.apply((Object)result.error());
    }

    private boolean msgpack2jsObj0(MsgUnpacker unpacker, ArgonautMsgpack.Result<JsonObject> result, ArgonautUnpackOptions unpackOptions) {
        BooleanRef success;
        block4: {
            int size = unpacker.unpackMapHeader();
            ObjectRef obj = ObjectRef.create((Object)JsonObject$.MODULE$.empty());
            IntRef i = IntRef.create((int)0);
            ArgonautMsgpack.Result mapElem = ArgonautMsgpack$Result$.MODULE$.empty();
            success = BooleanRef.create((boolean)true);
            while (i.elem < size && success.elem) {
                BoxedUnit boxedUnit;
                MsgType tpe;
                MsgType msgType = tpe = unpacker.nextType();
                MsgType.STRING$ sTRING$ = MsgType.STRING$.MODULE$;
                if (!(msgType != null ? !msgType.equals(sTRING$) : sTRING$ != null)) {
                    this.process$1(unpacker.unpackString(), unpacker, mapElem, unpackOptions, obj, i, result, success);
                    continue;
                }
                Option option = (Option)unpackOptions.nonStringKey().apply((Object)tpe, (Object)unpacker);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String key = (String)some.value();
                    this.process$1(key, unpacker, mapElem, unpackOptions, obj, i, result, success);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    success.elem = false;
                    result.error_$eq((UnpackError)new Other("not string key"));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)option);
            }
            unpacker.mapEnd();
            if (!success.elem) break block4;
            result.value_$eq((JsonObject)obj.elem);
        }
        return success.elem;
    }

    private boolean msgpack2jsArray0(MsgUnpacker unpacker, ArgonautMsgpack.Result<List<Json>> result, ArgonautUnpackOptions unpackOptions) {
        boolean success;
        block2: {
            int size = unpacker.unpackArrayHeader();
            Json[] array = new Json[size];
            int i = 0;
            ArgonautMsgpack.Result<Object> arrayElem = new ArgonautMsgpack.Result<Object>(null, null);
            success = true;
            while (i < size && success) {
                if (this.msgpack2json0(unpacker, arrayElem, unpackOptions)) {
                    array[i] = arrayElem.value();
                    ++i;
                    continue;
                }
                result.error_$eq(arrayElem.error());
                success = false;
            }
            unpacker.arrayEnd();
            if (!success) break block2;
            result.value_$eq((List<Json>)Predef$.MODULE$.wrapRefArray((Object[])array).toList());
        }
        return success;
    }

    private boolean isValidLong(BigInteger value) {
        return BigIntegerLongMin.compareTo(value) <= 0 && value.compareTo(BigIntegerLongMax) <= 0;
    }

    private boolean msgpack2json0(MsgUnpacker unpacker, ArgonautMsgpack.Result<Json> result, ArgonautUnpackOptions unpackOptions) {
        boolean bl;
        MsgType msgType = unpacker.nextType();
        if (MsgType.NIL$.MODULE$.equals(msgType)) {
            unpacker.unpackNil();
            result.value_$eq(Json$.MODULE$.jNull());
            bl = true;
        } else if (MsgType.BOOLEAN$.MODULE$.equals(msgType)) {
            if (unpacker.unpackBoolean()) {
                result.value_$eq(Json$.MODULE$.jTrue());
            } else {
                result.value_$eq(Json$.MODULE$.jFalse());
            }
            bl = true;
        } else if (MsgType.INTEGER$.MODULE$.equals(msgType)) {
            BigInteger value = unpacker.unpackBigInteger();
            if (this.isValidLong(value)) {
                result.value_$eq(Json$.MODULE$.jNumber((JsonNumber)new JsonLong(value.longValue())));
            } else {
                result.value_$eq(Json$.MODULE$.jNumber((JsonNumber)new JsonBigDecimal(package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(value)))));
            }
            bl = true;
        } else if (MsgType.FLOAT$.MODULE$.equals(msgType)) {
            Boolean bl2;
            double f = unpacker.unpackDouble();
            if (RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(f))) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)ArgonautMsgpack$Result$.MODULE$.fromEither(unpackOptions.positiveInf(), result));
            } else if (RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(f))) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)ArgonautMsgpack$Result$.MODULE$.fromEither(unpackOptions.negativeInf(), result));
            } else if (Double.isNaN(f)) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)ArgonautMsgpack$Result$.MODULE$.fromEither(unpackOptions.nan(), result));
            } else {
                result.value_$eq(Json$.MODULE$.jNumber(BigDecimal$.MODULE$.double2bigDecimal(f)));
                bl2 = BoxedUnit.UNIT;
            }
            bl = true;
        } else if (MsgType.STRING$.MODULE$.equals(msgType)) {
            result.value_$eq((Json)Json$.MODULE$.jString().apply((Object)unpacker.unpackString()));
            bl = true;
        } else if (MsgType.ARRAY$.MODULE$.equals(msgType)) {
            ArgonautMsgpack.Result<List<Json>> result0 = ArgonautMsgpack$Result$.MODULE$.empty();
            boolean r = this.msgpack2jsArray0(unpacker, result0, unpackOptions);
            result.error_$eq(result0.error());
            result.value_$eq((Json)Json$.MODULE$.jArray().apply(result0.value()));
            bl = r;
        } else if (MsgType.MAP$.MODULE$.equals(msgType)) {
            ArgonautMsgpack.Result<JsonObject> result0 = ArgonautMsgpack$Result$.MODULE$.empty();
            boolean r = this.msgpack2jsObj0(unpacker, result0, unpackOptions);
            result.error_$eq(result0.error());
            result.value_$eq((Json)Json$.MODULE$.jObject().apply((Object)result0.value()));
            bl = r;
        } else if (MsgType.BINARY$.MODULE$.equals(msgType)) {
            bl = ArgonautMsgpack$Result$.MODULE$.fromEither((.bslash.div)unpackOptions.binary().apply((Object)unpacker), result);
        } else if (MsgType.EXTENSION$.MODULE$.equals(msgType)) {
            bl = ArgonautMsgpack$Result$.MODULE$.fromEither((.bslash.div)unpackOptions.extension().apply((Object)unpacker), result);
        } else {
            throw new MatchError((Object)msgType);
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$jsonObject2msgpack$1(MsgPacker packer$1, Tuple2 field) {
        packer$1.packString((String)field._1());
        MODULE$.json2msgpack(packer$1, (Json)field._2());
    }

    public static final /* synthetic */ void $anonfun$json2msgpack$3(MsgPacker packer$3, JsonNumber x0$1) {
        JsonNumber jsonNumber = x0$1;
        if (jsonNumber instanceof JsonDecimal) {
            JsonDecimal jsonDecimal = (JsonDecimal)jsonNumber;
            String value = jsonDecimal.value();
            packer$3.packDouble(Double.parseDouble(value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsonNumber instanceof JsonBigDecimal) {
            JsonBigDecimal jsonBigDecimal = (JsonBigDecimal)jsonNumber;
            BigDecimal value = jsonBigDecimal.value();
            packer$3.packDouble(value.toDouble());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsonNumber instanceof JsonLong) {
            JsonLong jsonLong = (JsonLong)jsonNumber;
            long value = jsonLong.value();
            packer$3.packLong(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)jsonNumber);
        }
    }

    private final void process$1(String key, MsgUnpacker unpacker$1, ArgonautMsgpack.Result mapElem$1, ArgonautUnpackOptions unpackOptions$1, ObjectRef obj$1, IntRef i$1, ArgonautMsgpack.Result result$1, BooleanRef success$1) {
        if (this.msgpack2json0(unpacker$1, mapElem$1, unpackOptions$1)) {
            obj$1.elem = ((JsonObject)obj$1.elem).$plus(key, (Json)mapElem$1.value());
            ++i$1.elem;
        } else {
            result$1.error_$eq(mapElem$1.error());
            success$1.elem = false;
        }
    }

    private ArgonautMsgpack$() {
    }
}

