/*
 * Decompiled with CFR 0.152.
 */
package com.github.xmybatis.core;

import com.github.xmybatis.core.Entity;
import com.github.xmybatis.core.Example;
import com.github.xmybatis.core.annotation.Column;
import com.github.xmybatis.core.annotation.LeftJoin;
import com.github.xmybatis.core.annotation.Table;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SQLProvider {
    Logger log = LoggerFactory.getLogger(SQLProvider.class);
    private Class<? extends Entity> entityClass;
    protected static final String where0 = "      <foreach collection=\"oredCriteria\" item=\"criteria\" separator=\" or \">\r\n        <if test=\"criteria.valid\">\r\n          <trim prefix=\"(\" prefixOverrides=\"and\" suffix=\")\">\r\n            <foreach collection=\"criteria.criteria\" item=\"criterion\">\r\n              <choose>\r\n                <when test=\"criterion.noValue\">\r\n                  and ${criterion.condition}\r\n                </when>\r\n                <when test=\"criterion.singleValue\">\r\n                  and ${criterion.condition} #{criterion.value} ${criterion.suffix}\r\n                </when>\r\n                <when test=\"criterion.likeValue\">\r\n                  and ${criterion.condition} concat('${criterion.likePrefix}', #{criterion.value}, '${criterion.likeSuffix}')\r\n                </when>\r\n                <when test=\"criterion.betweenValue\">\r\n                  and ${criterion.condition} #{criterion.value} and #{criterion.secondValue}\r\n                </when>\r\n                <when test=\"criterion.listValue\">\r\n                  and ${criterion.condition}\r\n                  <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\r\n                    #{listItem}\r\n                  </foreach>\r\n                </when>\r\n              </choose>\r\n            </foreach>\r\n          </trim>\r\n        </if>\r\n      </foreach>\r\n";
    protected static final String where_u_d = "      <foreach collection=\"example.oredCriteria\" item=\"criteria\" separator=\" or \">\r\n        <if test=\"criteria.valid\">\r\n          <trim prefix=\"(\" prefixOverrides=\"and\" suffix=\")\">\r\n            <foreach collection=\"criteria.criteria\" item=\"criterion\">\r\n              <choose>\r\n                <when test=\"criterion.noValue\">\r\n                  and ${criterion.condition}\r\n                </when>\r\n                <when test=\"criterion.singleValue\">\r\n                  and ${criterion.condition} #{criterion.value} ${criterion.suffix}\r\n                </when>\r\n                <when test=\"criterion.likeValue\">\r\n                  and ${criterion.condition} concat('${criterion.likePrefix}', #{criterion.value}, '${criterion.likeSuffix}')\r\n                </when>\r\n                <when test=\"criterion.betweenValue\">\r\n                  and ${criterion.condition} #{criterion.value} and #{criterion.secondValue}\r\n                </when>\r\n                <when test=\"criterion.listValue\">\r\n                  and ${criterion.condition}\r\n                  <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\r\n                    #{listItem}\r\n                  </foreach>\r\n                </when>\r\n              </choose>\r\n            </foreach>\r\n          </trim>\r\n        </if>\r\n      </foreach>\r\n";

    protected SQLProvider() {
    }

    public SQLProvider(Class<? extends Entity> entityClass) {
        this.entityClass = entityClass;
    }

    private String getFullTableName(Entity info) {
        String tableName = info.getClass().getAnnotation(Table.class).value();
        return info.getSchema() == null ? tableName : String.format("%s.%s", info.getSchema(), tableName);
    }

    public String insertSelective(Entity info) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Field[] fields;
        SQL sql = new SQL();
        sql.INSERT_INTO(this.getFullTableName(info));
        for (Field f : fields = info.getClass().getDeclaredFields()) {
            Column c;
            Column methodAnnon = f.getAnnotation(Column.class);
            if (methodAnnon == null || (c = methodAnnon).readOnly()) continue;
            f.setAccessible(true);
            Object value = f.get(info);
            if (value == null) continue;
            sql.INTO_COLUMNS(new String[]{this.getAfterDot(c.value())});
            sql.INTO_VALUES(new String[]{"#{" + f.getName() + "}"});
        }
        return sql.toString();
    }

    public String insert(Object info) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Field[] fields;
        Table t = this.entityClass.getAnnotation(Table.class);
        String tableName = t.value();
        SQL sql = new SQL();
        sql.INSERT_INTO(tableName);
        for (Field f : fields = this.entityClass.getDeclaredFields()) {
            Column c;
            Column methodAnnon = f.getAnnotation(Column.class);
            if (methodAnnon == null || (c = methodAnnon).readOnly() || c.id()) continue;
            sql.INTO_COLUMNS(new String[]{"`" + this.getAfterDot(c.value()) + "`"});
            sql.INTO_VALUES(new String[]{"#{" + f.getName() + "}"});
        }
        return sql.toString();
    }

    public String updateSelectiveById(Entity info) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Field[] fields;
        Class<?> clz = info.getClass();
        Table t = clz.getAnnotation(Table.class);
        SQL sql = new SQL();
        String tableName = t.value();
        sql.UPDATE(this.getFullTableName(info));
        for (Field f : fields = clz.getDeclaredFields()) {
            Column c;
            Column methodAnnon = f.getAnnotation(Column.class);
            if (methodAnnon == null || (c = methodAnnon).readOnly()) continue;
            f.setAccessible(true);
            Object value = f.get(info);
            if (!c.id()) {
                if (value == null) continue;
                sql.SET(String.format("`%s`=#{%s}", this.getAfterDot(c.value()), f.getName()));
                continue;
            }
            sql.WHERE(String.format("`%s`=#{%s}", this.getAfterDot(c.value()), f.getName()));
        }
        return sql.toString();
    }

    public String updateSelectiveByExample(@Param(value="record") Entity info, @Param(value="example") Example example) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Field[] fields;
        Class<?> clz = info.getClass();
        Table t = clz.getAnnotation(Table.class);
        SQL sql = new SQL();
        String tableName = t.value();
        sql.UPDATE(StringUtils.isBlank((CharSequence)info.getSchema()) ? String.format("`%s`", tableName) : String.format("`%s`.`%s`", info.getSchema(), tableName));
        for (Field f : fields = clz.getDeclaredFields()) {
            Column c;
            Column methodAnnon = f.getAnnotation(Column.class);
            if (methodAnnon == null || (c = methodAnnon).readOnly()) continue;
            f.setAccessible(true);
            Object value = f.get(info);
            if (c.id() || value == null) continue;
            sql.SET(String.format("`%s`=#{record.%s}", this.getAfterDot(c.value()), f.getName()));
        }
        return "<script>" + sql.toString() + " " + this.genWhere_U_D("") + " </script>";
    }

    protected SQL selectSub(SQL sql) {
        Field[] fields;
        for (Field f : fields = this.entityClass.getDeclaredFields()) {
            Column methodAnnon = f.getAnnotation(Column.class);
            if (methodAnnon == null) continue;
            Column c = methodAnnon;
            if (c.alias().length() > 0) {
                sql.SELECT(String.format("%s AS `%s`", this.dealColumnName(c.value()), c.alias()));
                continue;
            }
            sql.SELECT(String.format("%s AS `%s`", this.dealColumnName(c.value()), f.getName()));
        }
        return sql;
    }

    protected SQL fromSub(SQL sql) {
        return this.fromSub(null, sql);
    }

    protected SQL fromSub(String schema, SQL sql) {
        LeftJoin[] joins;
        Table t = this.entityClass.getAnnotation(Table.class);
        String tableName = t.value();
        if (StringUtils.isBlank((CharSequence)t.alias())) {
            sql.FROM(StringUtils.isBlank((CharSequence)schema) ? tableName : String.format("%s.%s", schema, tableName));
        } else {
            sql.FROM(StringUtils.isBlank((CharSequence)schema) ? String.format("%s AS %s", tableName, t.alias()) : String.format("%s.%s AS %s", schema, tableName, t.alias()));
        }
        for (LeftJoin j : joins = t.leftJoin()) {
            if (j.joinTable().contains(".")) {
                sql.LEFT_OUTER_JOIN(j.joinTable() + (StringUtils.isBlank((CharSequence)j.as()) ? "" : " AS " + j.as()) + " ON " + j.on());
                continue;
            }
            sql.LEFT_OUTER_JOIN((StringUtils.isBlank((CharSequence)schema) ? j.joinTable() : String.format("%s.%s", schema, j.joinTable())) + (StringUtils.isBlank((CharSequence)j.as()) ? "" : " AS " + j.as()) + " ON " + j.on());
        }
        return sql;
    }

    protected SQL whereByExampleSub(SQL sql) {
        return sql;
    }

    public String selectById(@Param(value="schema") String schema, @Param(value="id") Integer id) {
        Field[] fields;
        SQL sql = new SQL();
        this.selectSub(sql);
        this.fromSub(schema, sql);
        for (Field f : fields = this.entityClass.getDeclaredFields()) {
            Column c;
            Column colAnnon = f.getAnnotation(Column.class);
            if (colAnnon == null || !(c = colAnnon).id()) continue;
            sql.WHERE(c.value() + "=#{id}");
        }
        return sql.toString();
    }

    public String selectByExample(Example ex) {
        return this.innerSelectByExample(ex, "");
    }

    protected String innerSelectByExample(Example ex, String exWhere) {
        SQL sql = new SQL();
        this.selectSub(sql);
        if (ex.getSchema() == null) {
            this.fromSub(sql);
        } else {
            this.fromSub(ex.getSchema(), sql);
        }
        if (ex.isDistinct()) {
            sql.SELECT_DISTINCT("");
        }
        String limit = " ";
        if (ex.getLimit() != null) {
            limit = " LIMIT " + ex.getLimit() + " ";
        }
        if (ex.getOffset() != null) {
            limit = limit + " OFFSET  " + ex.getOffset() + " ";
        }
        String sqlText = "<script>\r\n" + sql.toString() + this.genWhere(exWhere) + ex.getOrderByClause() + " " + limit + " \r\n</script>";
        return sqlText;
    }

    public String countByExample(Example ex) {
        return this.innerCountByExample(ex, "");
    }

    protected String innerCountByExample(Example ex, String exWhere) {
        SQL sql = new SQL();
        sql.SELECT("count(1)");
        if (ex.getSchema() == null) {
            this.fromSub(sql);
        } else {
            this.fromSub(ex.getSchema(), sql);
        }
        return "<script>" + sql.toString() + this.genWhere(exWhere) + " </script>";
    }

    public String deleteById(@Param(value="schema") String schema, @Param(value="id") int id) {
        Field[] fields;
        Table t = this.entityClass.getAnnotation(Table.class);
        SQL sql = new SQL();
        String fromTable = t.value();
        fromTable = fromTable.indexOf(".") > -1 || StringUtils.isBlank((CharSequence)schema) ? String.format("`%s`", fromTable) : String.format("`%s`.`%s`", schema, fromTable);
        sql.DELETE_FROM(fromTable);
        for (Field f : fields = this.entityClass.getDeclaredFields()) {
            Column c;
            Column methodAnnon = f.getAnnotation(Column.class);
            if (methodAnnon == null || !(c = methodAnnon).id()) continue;
            sql.WHERE(this.getAfterDot(c.value()) + "=#{id}");
        }
        return sql.toString();
    }

    public String deleteByExample(Example ex) {
        Table t = this.entityClass.getAnnotation(Table.class);
        SQL sql = new SQL();
        sql.DELETE_FROM(t.value());
        return "<script>" + sql.toString() + " " + this.genWhere("") + " </script>";
    }

    public String existsByExample(Example ex) {
        Table t = this.entityClass.getAnnotation(Table.class);
        return "<script>select exists(select 1 from " + t.value() + this.genWhere("") + " ) </script>";
    }

    private String genWhere(String exSQLText) {
        String text = exSQLText != null && !StringUtils.isBlank((CharSequence)exSQLText) ? " and (" + exSQLText + ") " : "";
        return " <where>\r\n      <foreach collection=\"oredCriteria\" item=\"criteria\" separator=\" or \">\r\n        <if test=\"criteria.valid\">\r\n          <trim prefix=\"(\" prefixOverrides=\"and\" suffix=\")\">\r\n            <foreach collection=\"criteria.criteria\" item=\"criterion\">\r\n              <choose>\r\n                <when test=\"criterion.noValue\">\r\n                  and ${criterion.condition}\r\n                </when>\r\n                <when test=\"criterion.singleValue\">\r\n                  and ${criterion.condition} #{criterion.value} ${criterion.suffix}\r\n                </when>\r\n                <when test=\"criterion.likeValue\">\r\n                  and ${criterion.condition} concat('${criterion.likePrefix}', #{criterion.value}, '${criterion.likeSuffix}')\r\n                </when>\r\n                <when test=\"criterion.betweenValue\">\r\n                  and ${criterion.condition} #{criterion.value} and #{criterion.secondValue}\r\n                </when>\r\n                <when test=\"criterion.listValue\">\r\n                  and ${criterion.condition}\r\n                  <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\r\n                    #{listItem}\r\n                  </foreach>\r\n                </when>\r\n              </choose>\r\n            </foreach>\r\n          </trim>\r\n        </if>\r\n      </foreach>\r\n" + text + "\r\n </where>";
    }

    private String genWhere_U_D(String exSQLText) {
        String text = exSQLText != null && !StringUtils.isBlank((CharSequence)exSQLText) ? " and (" + exSQLText + ") " : "";
        return " <where>\r\n      <foreach collection=\"example.oredCriteria\" item=\"criteria\" separator=\" or \">\r\n        <if test=\"criteria.valid\">\r\n          <trim prefix=\"(\" prefixOverrides=\"and\" suffix=\")\">\r\n            <foreach collection=\"criteria.criteria\" item=\"criterion\">\r\n              <choose>\r\n                <when test=\"criterion.noValue\">\r\n                  and ${criterion.condition}\r\n                </when>\r\n                <when test=\"criterion.singleValue\">\r\n                  and ${criterion.condition} #{criterion.value} ${criterion.suffix}\r\n                </when>\r\n                <when test=\"criterion.likeValue\">\r\n                  and ${criterion.condition} concat('${criterion.likePrefix}', #{criterion.value}, '${criterion.likeSuffix}')\r\n                </when>\r\n                <when test=\"criterion.betweenValue\">\r\n                  and ${criterion.condition} #{criterion.value} and #{criterion.secondValue}\r\n                </when>\r\n                <when test=\"criterion.listValue\">\r\n                  and ${criterion.condition}\r\n                  <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\r\n                    #{listItem}\r\n                  </foreach>\r\n                </when>\r\n              </choose>\r\n            </foreach>\r\n          </trim>\r\n        </if>\r\n      </foreach>\r\n" + text + "\r\n </where>";
    }

    private String getAfterDot(String s) {
        int i = s.indexOf(46);
        if (i > -1) {
            return s.substring(i + 1);
        }
        return s;
    }

    public String dealColumnName(String v) {
        String[] vv = v.split("\\.");
        if (vv.length == 2) {
            return String.format("`%s`.`%s`", vv[0], vv[1]);
        }
        return String.format("`%s`", v);
    }
}

