/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.validate;

import com.xinput.bootbase.validate.Range;
import java.lang.invoke.MethodHandles;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class RangeCheck
implements ConstraintValidator<Range, Object> {
    private static final Log LOG = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private double min;
    private double max;

    public void initialize(Range constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
        this.validateParameters();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            try {
                double v = Double.parseDouble(value.toString());
                return v >= this.min && v <= this.max;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (value instanceof Number) {
            try {
                return ((Number)value).doubleValue() >= this.min && ((Number)value).doubleValue() <= this.max;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private void validateParameters() {
        if (this.max < this.min) {
            throw LOG.getLengthCannotBeNegativeException();
        }
    }
}

