/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.xinput.bootbase.config.DefaultConfig;
import com.xinput.bootbase.domain.WechatUserInfo;
import com.xinput.bootbase.util.JsonUtils;
import com.xinput.bootbase.util.Logs;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.slf4j.Logger;

public class WechatUtils {
    private static final Logger logger = Logs.get();
    private static String wxUrl = "https://api.weixin.qq.com/sns/jscode2session?appid={0}&secret={1}&js_code={2}&grant_type=#{3}";

    public static WechatUserInfo code2Session(String code) {
        String requestUrl = MessageFormat.format(wxUrl, DefaultConfig.getWechatAppid(), DefaultConfig.getWechatSecret(), code, "authorization_code");
        WechatUserInfo authInfo = null;
        try {
            String result = Request.Get((String)requestUrl).execute().returnContent().asString();
            System.out.println(result);
            logger.info("code2session\u4fe1\u606f:[{}]", (Object)result);
            authInfo = JsonUtils.toBean(result, WechatUserInfo.class);
        }
        catch (ClientProtocolException e) {
            logger.error("\u767b\u5f55\u51ed\u8bc1\u6821\u9a8c\u5931\u8d25,code:[{}].", (Object)code, (Object)e);
        }
        catch (IOException e) {
            logger.error("\u767b\u5f55\u51ed\u8bc1\u6821\u9a8c\u5931\u8d25,code:[{}]", (Object)code, (Object)e);
        }
        return authInfo;
    }

    public static void main(String[] args) {
        String code = "033s42zG07ilfg2jJqxG0xGezG0s42zp";
        WechatUserInfo userInfo = WechatUtils.code2Session(code);
        System.out.println(JsonUtils.toJsonString(userInfo));
    }
}

