/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class StreamUtils {
    public static <R, A> List<A> collectColumn(Collection<R> collection, Function<R, A> function) {
        return collection.stream().map(function).collect(Collectors.toList());
    }

    public static <R, A> List<A> collectColumn(Collection<R> collection, Predicate<R> predicate, Function<R, A> function) {
        return collection.stream().filter(predicate).map(function).collect(Collectors.toList());
    }

    public static <R, A> List<A> collectDistinctColumn(Collection<R> collection, Function<R, A> function) {
        return collection.stream().map(function).distinct().collect(Collectors.toList());
    }

    public static <R, A> List<A> collectDistinctColumn(Collection<R> collection, Predicate<R> predicate, Function<R, A> function) {
        return collection.stream().filter(predicate).map(function).distinct().collect(Collectors.toList());
    }

    public static <R, A> Map<A, List<R>> group(Collection<R> collection, Function<R, A> function) {
        return collection.stream().collect(Collectors.groupingBy(function));
    }

    public static <R, A, P> Map<A, P> group(Collection<R> collection, Function<R, A> function, Function<R, P> valueMapper, BinaryOperator<P> mergeFunction) {
        return collection.stream().collect(Collectors.toMap(function, valueMapper, mergeFunction));
    }

    public static <R, K, V> Map<K, V> tomap(Collection<R> collection, Function<R, K> keyMapper, Function<R, V> valMapper, BinaryOperator<V> mergeFunction) {
        return collection.stream().collect(Collectors.toMap(keyMapper, valMapper, mergeFunction));
    }

    public static String union(List<String> list) {
        return list.stream().collect(Collectors.joining(","));
    }

    public static String union(List<String> list, String delimiter) {
        return list.stream().collect(Collectors.joining(delimiter));
    }

    public static String union(Collection<String> collection, String delimiter, String prefix, String suffix) {
        return collection.stream().collect(Collectors.joining(delimiter, prefix, suffix));
    }

    public static String unionNotEmptyString(Collection<String> collection, String delimiter) {
        return collection.stream().filter(col -> StringUtils.isNotBlank((CharSequence)col)).collect(Collectors.joining(delimiter));
    }

    public static String unionNotEmptyString(List<String> collection, String delimiter, String prefix, String suffix) {
        return collection.stream().filter(col -> StringUtils.isNotBlank((CharSequence)col)).collect(Collectors.joining(delimiter, prefix, suffix));
    }
}

