/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.xinput.bootbase.util.Logs;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class SimpleProperties {
    private static final Logger logger = Logs.get();
    private static ClassLoader defaultClassLoader;
    private Set<File> confs = new HashSet<File>(1);
    private Properties props = new Properties();

    public static SimpleProperties readConfiguration(String filename) {
        SimpleProperties simpleProperties = new SimpleProperties();
        simpleProperties.props = simpleProperties.readOneConfigurationFile(filename);
        return simpleProperties;
    }

    private Properties readOneConfigurationFile(String filename) {
        Properties propsFromFile;
        File conf;
        block16: {
            conf = new File(filename);
            InputStream is = null;
            propsFromFile = null;
            if (filename.contains("/") || filename.contains("\\")) {
                try {
                    is = new FileInputStream(conf);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(filename + " file load error", e);
                }
            }
            try {
                is = SimpleProperties.getResourceAsStream(filename);
            }
            catch (IOException e) {
                logger.error("Cannot read file: [{}].", (Object)filename);
                System.err.println("Cannot read " + filename);
            }
            if (this.confs.contains(conf)) {
                throw new RuntimeException("Detected recursive @include usage. Have seen the file " + filename + " before");
            }
            try {
                propsFromFile = SimpleProperties.readUtf8Properties(is);
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof IOException)) break block16;
                System.err.println("Cannot read " + filename);
            }
        }
        this.confs.add(conf);
        OrderSafeProperties newConfiguration = new OrderSafeProperties();
        Pattern pattern = Pattern.compile("^%([a-zA-Z0-9_\\-]+)\\.(.*)$");
        for (Object key : propsFromFile.keySet()) {
            Matcher matcher = pattern.matcher(key + "");
            if (matcher.matches()) continue;
            ((Properties)newConfiguration).put(key, propsFromFile.get(key).toString().trim());
        }
        propsFromFile = newConfiguration;
        pattern = Pattern.compile("\\$\\{([^}]+)}");
        for (Object key : propsFromFile.keySet()) {
            String value = propsFromFile.getProperty(key.toString());
            Matcher matcher = pattern.matcher(value);
            StringBuffer newValue = new StringBuffer(100);
            while (matcher.find()) {
                String jp = matcher.group(1);
                String r = System.getProperty(jp);
                if (r == null) {
                    r = System.getenv(jp);
                }
                if (r == null) {
                    System.err.println("Cannot replace " + jp + " in configuration (" + key + "=" + value + ")");
                    continue;
                }
                matcher.appendReplacement(newValue, r.replaceAll("\\\\", "\\\\\\\\"));
            }
            matcher.appendTail(newValue);
            propsFromFile.setProperty(key.toString(), newValue.toString());
        }
        HashMap<Object, Object> toInclude = new HashMap<Object, Object>(16);
        for (Object key : propsFromFile.keySet()) {
            if (!key.toString().startsWith("@include.")) continue;
            try {
                String filenameToInclude = propsFromFile.getProperty(key.toString());
                toInclude.putAll(this.readOneConfigurationFile(filenameToInclude));
            }
            catch (Exception ex) {
                System.err.println("Missing include: " + key + " Cause:" + ex);
            }
        }
        propsFromFile.putAll((Map<?, ?>)toInclude);
        return propsFromFile;
    }

    private static Properties readUtf8Properties(InputStream is) {
        OrderSafeProperties properties = new OrderSafeProperties();
        try {
            ((Properties)properties).load(is);
            OrderSafeProperties orderSafeProperties = properties;
            return orderSafeProperties;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            SimpleProperties.closeQuietly(is);
        }
    }

    public Properties getUnderlyingProperties() {
        return this.props;
    }

    public String getStringProperty(String name) {
        return this.getStringProperty(name, null);
    }

    public String getStringProperty(String name, String def) {
        String val = this.props.getProperty(name, def);
        if (val == null) {
            return def;
        }
        return (val = val.trim()).length() == 0 ? def : val;
    }

    public String[] getStringArrayProperty(String name) {
        return this.getStringArrayProperty(name, null);
    }

    public String[] getStringArrayProperty(String name, String[] def) {
        String vals = this.getStringProperty(name);
        if (vals == null) {
            return def;
        }
        StringTokenizer stok = new StringTokenizer(vals, ",");
        ArrayList<String> strs = new ArrayList<String>();
        try {
            while (stok.hasMoreTokens()) {
                strs.add(stok.nextToken().trim());
            }
            return strs.toArray(new String[strs.size()]);
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean def) {
        String val = this.getStringProperty(name);
        return val == null ? def : Boolean.valueOf(val);
    }

    public byte getByteProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Byte.parseByte(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public byte getByteProperty(String name, byte def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Byte.parseByte(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public char getCharProperty(String name) {
        return this.getCharProperty(name, '\u0000');
    }

    public char getCharProperty(String name, char def) {
        String param = this.getStringProperty(name);
        return param == null ? def : param.charAt(0);
    }

    public double getDoubleProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public double getDoubleProperty(String name, double def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public float getFloatProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public float getFloatProperty(String name, float def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public int getIntProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public int getIntProperty(String name, int def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public int[] getIntArrayProperty(String name) throws NumberFormatException {
        return this.getIntArrayProperty(name, null);
    }

    public int[] getIntArrayProperty(String name, int[] def) throws NumberFormatException {
        String vals = this.getStringProperty(name);
        if (vals == null) {
            return def;
        }
        StringTokenizer stok = new StringTokenizer(vals, ",");
        ArrayList<Integer> ints = new ArrayList<Integer>();
        try {
            while (stok.hasMoreTokens()) {
                try {
                    ints.add(new Integer(stok.nextToken().trim()));
                }
                catch (NumberFormatException nfe) {
                    throw new NumberFormatException(" '" + vals + "'");
                }
            }
            int[] outInts = new int[ints.size()];
            for (int i = 0; i < ints.size(); ++i) {
                outInts[i] = (Integer)ints.get(i);
            }
            return outInts;
        }
        catch (Exception e) {
            return def;
        }
    }

    public long getLongProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public long getLongProperty(String name, long def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public short getShortProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Short.parseShort(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public short getShortProperty(String name, short def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Short.parseShort(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public String[] getPropertyGroups(String prefix) {
        Enumeration<?> keys = this.props.propertyNames();
        HashSet<String> groups = new HashSet<String>(10);
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(prefix)) continue;
            String groupName = key.substring(prefix.length(), key.indexOf(46, prefix.length()));
            groups.add(groupName);
        }
        return groups.toArray(new String[groups.size()]);
    }

    public Properties getPropertyGroup(String prefix) {
        return this.getPropertyGroup(prefix, false, null);
    }

    public Properties getPropertyGroup(String prefix, boolean stripPrefix) {
        return this.getPropertyGroup(prefix, stripPrefix, null);
    }

    public Properties getPropertyGroup(String prefix, boolean stripPrefix, String[] excludedPrefixes) {
        Enumeration<?> keys = this.props.propertyNames();
        Properties group = new Properties();
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(prefix)) continue;
            boolean exclude = false;
            if (excludedPrefixes != null) {
                for (int i = 0; i < excludedPrefixes.length && !exclude; ++i) {
                    exclude = key.startsWith(excludedPrefixes[i]);
                }
            }
            if (exclude) continue;
            String value = this.getStringProperty(key, "");
            if (stripPrefix) {
                group.put(key.substring(prefix.length()), value);
                continue;
            }
            group.put(key, value);
        }
        return group;
    }

    private static String escapeJava(String str) {
        return SimpleProperties.escapeJavaStyleString(str, false, false);
    }

    private static String escapeJavaStyleString(String str, boolean escapeSingleQuotes, boolean escapeForwardSlash) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            SimpleProperties.escapeJavaStyleString(writer, str, escapeSingleQuotes, escapeForwardSlash);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void escapeJavaStyleString(Writer out, String str, boolean escapeSingleQuote, boolean escapeForwardSlash) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        block13: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.write("\\u" + SimpleProperties.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.write("\\u0" + SimpleProperties.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.write("\\u00" + SimpleProperties.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92);
                        out.write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92);
                        out.write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + SimpleProperties.hex(ch));
                            break;
                        }
                        out.write("\\u000" + SimpleProperties.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        out.write(92);
                    }
                    out.write(39);
                    continue block13;
                }
                case '\"': {
                    out.write(92);
                    out.write(34);
                    continue block13;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block13;
                }
                case '/': {
                    if (escapeForwardSlash) {
                        out.write(92);
                    }
                    out.write(47);
                    continue block13;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    private static List<String> readLines(InputStream input, String encoding) throws IOException {
        return SimpleProperties.readLines(input, Charset.forName(encoding));
    }

    private static List<String> readLines(InputStream input, Charset encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, encoding);
        return SimpleProperties.readLines(reader);
    }

    private static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = SimpleProperties.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    private static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static InputStream getResourceAsStream(String resource) throws IOException {
        return SimpleProperties.getResourceAsStream(SimpleProperties.getClassLoader(), resource);
    }

    public static InputStream getResourceAsStream(ClassLoader loader, String resource) throws IOException {
        InputStream in = null;
        if (loader != null) {
            in = loader.getResourceAsStream(resource);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(resource);
        }
        if (in == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return in;
    }

    private static ClassLoader getClassLoader() {
        if (defaultClassLoader != null) {
            return defaultClassLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private static class OrderSafeProperties
    extends Properties {
        private final LinkedHashSet<Object> keys = new LinkedHashSet();

        private OrderSafeProperties() {
        }

        @Override
        public void load(InputStream inputStream) throws IOException {
            List lines = SimpleProperties.readLines(inputStream, "utf-8");
            SimpleProperties.closeQuietly(inputStream);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (String line : lines) {
                line = line.replaceAll("\\\\\"", "\"").replaceAll("(^|[^\\\\])(\\\\')", "$1'");
                String escapedLine = SimpleProperties.escapeJava(line) + "\n";
                escapedLine = escapedLine.replaceAll("\\\\\\\\", "\\\\");
                out.write(escapedLine.getBytes("iso-8859-1"));
            }
            super.load(new ByteArrayInputStream(out.toByteArray()));
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }

        @Override
        public Set<Object> keySet() {
            return this.keys;
        }

        @Override
        public Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }

        @Override
        public Object remove(Object o) {
            this.keys.remove(o);
            return super.remove(o);
        }

        @Override
        public void clear() {
            this.keys.clear();
            super.clear();
        }

        @Override
        public void putAll(Map<? extends Object, ? extends Object> map) {
            this.keys.addAll(map.keySet());
            super.putAll(map);
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            LinkedHashSet<Map.Entry<Object, Object>> entrySet = new LinkedHashSet<Map.Entry<Object, Object>>(this.keys.size());
            for (Object e : this.keys) {
                entrySet.add(new Entry(e, this.get(e)));
            }
            return entrySet;
        }

        class Entry
        implements Map.Entry<Object, Object> {
            private final Object key;
            private final Object value;

            private Entry(Object key, Object value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public Object getKey() {
                return this.key;
            }

            @Override
            public Object getValue() {
                return this.value;
            }

            @Override
            public Object setValue(Object o) {
                throw new IllegalStateException("not implemented");
            }
        }
    }
}

