/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SignatureUtil {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String VERSION = "1";
    private static final String ALGORITHM = "HmacSHA256";
    private static final int DEFAULT_EXPIRE = 10;

    public static String computeSignature(String secretKey, String httpMethod, String path, Map<String, String> parameters) {
        Object[] sortedKeys = parameters.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        StringBuilder sbStringToSign = new StringBuilder();
        sbStringToSign.append(httpMethod).append("\n").append(path).append("\n");
        String signature = "";
        try {
            int count = 0;
            for (Object key : sortedKeys) {
                if (count != 0) {
                    sbStringToSign.append("&");
                }
                sbStringToSign.append(SignatureUtil.percentEncode((String)key)).append("=").append(SignatureUtil.percentEncode(parameters.get(key)));
                ++count;
            }
            String strToSign = sbStringToSign.toString();
            signature = SignatureUtil.calculateSignature(secretKey, strToSign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signature;
    }

    private static String calculateSignature(String key, String stringToSign) {
        byte[] signData = new byte[]{};
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(key.getBytes(DEFAULT_ENCODING), ALGORITHM));
            signData = mac.doFinal(stringToSign.getBytes(DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return new String(Base64.encodeBase64((byte[])signData));
    }

    private static String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, DEFAULT_ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    public static String map2QueryString(Map<?, ?> params) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Set<?> keySet = params.keySet();
            Object[] keys = keySet.toArray();
            for (int i = 0; i < keys.length; ++i) {
                stringBuilder.append(URLEncoder.encode(keys[i].toString(), DEFAULT_ENCODING)).append('=').append(URLEncoder.encode(params.get(keys[i]).toString(), DEFAULT_ENCODING));
                if (i >= keys.length - 1) continue;
                stringBuilder.append('&');
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to generate content from map", e);
        }
        return stringBuilder.toString();
    }
}

