/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.xinput.bootbase.util.Logs;
import com.xinput.bootbase.util.ReflectUtils;
import com.xinput.bootbase.util.SimpleProperties;
import com.xinput.bootbase.util.TypeUtils;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

public class RedisUtils {
    private static final Logger logger = Logs.get();
    private static Pool<Jedis> pool = null;
    private static SimpleProperties prop = SimpleProperties.readConfiguration("redis.properties");
    private static JedisCluster jedisCluster = null;
    private static Set<HostAndPort> jedisClusterNodes = new HashSet<HostAndPort>();
    private static String mode = prop.getStringProperty("redis.mode");
    public static final String NX = "NX";
    public static final String EX = "EX";
    public static final String OK = "OK";

    private static void init() {
        Integer timeout = prop.getIntProperty("redis.timeout");
        String password = prop.getStringProperty("redis.password");
        Integer port = prop.getIntProperty("redis.port");
        JedisPoolConfig poolConfig = RedisUtils.getPoolConfig();
        if (mode.equals("sharded")) {
            logger.error("sharded Not implemented");
        } else if (mode.equals("sentinel")) {
            String master = prop.getStringProperty("redis.master");
            String[] stnArray = prop.getStringArrayProperty("redis.sentinels");
            HashSet<String> stns = new HashSet<String>();
            for (String stn : stnArray) {
                stns.add(stn);
            }
            pool = new JedisSentinelPool(master, stns, (GenericObjectPoolConfig)poolConfig, timeout.intValue(), password);
        } else if (mode.equals("cluster")) {
            String[] ipsArray;
            for (String ip : ipsArray = prop.getStringArrayProperty("redis.ips")) {
                jedisClusterNodes.add(new HostAndPort(ip, port.intValue()));
            }
            jedisCluster = new JedisCluster(jedisClusterNodes, timeout.intValue(), (GenericObjectPoolConfig)poolConfig);
        } else {
            String ip = prop.getStringProperty("redis.ip");
            pool = new JedisPool((GenericObjectPoolConfig)poolConfig, ip, port.intValue(), timeout.intValue(), password);
        }
    }

    public static JedisPoolConfig getPoolConfig() {
        JedisPoolConfig jedisCfg = new JedisPoolConfig();
        Properties poolConfig = prop.getPropertyGroup("redis.pool", true);
        ReflectUtils reflect = ReflectUtils.on(jedisCfg);
        Method[] methods = JedisPoolConfig.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("set")) continue;
            String prop = methodName.replaceFirst("set", "");
            Object value = poolConfig.get(prop = Character.toLowerCase(prop.charAt(0)) + prop.substring(1));
            if (value == null) continue;
            logger.info("set prop success:{} --> {}", (Object)prop, value);
            ReflectUtils.on(jedisCfg).call(methodName, TypeUtils.cast(value, method.getParameterTypes()[0]));
        }
        return jedisCfg;
    }

    private static Jedis getJedis() {
        return (Jedis)RedisUtils.getPool().getResource();
    }

    private static Jedis getJedis(int index) {
        Jedis jedis = RedisUtils.getJedis();
        jedis.select(index);
        return jedis;
    }

    public static void execute(Consumer<JedisCommands> consumer) {
        RedisUtils.execute(consumer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Consumer<JedisCommands> consumer, int index) {
        Jedis jedis = null;
        try {
            if (mode.equals("cluster")) {
                JedisCluster jedisCluster = RedisUtils.getJedisCluster();
                consumer.accept((JedisCommands)jedisCluster);
            } else {
                jedis = RedisUtils.getJedis(index);
                consumer.accept((JedisCommands)jedis);
            }
        }
        catch (Exception e) {
            logger.error("consumer accept error! consumer:{} index:{}", new Object[]{consumer, index, e});
        }
        finally {
            if (!mode.equals("cluster")) {
                RedisUtils.closeJedis(jedis);
            }
        }
    }

    public static <R> R executeResult(Function<JedisCommands, R> function) {
        return RedisUtils.executeResult(function, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R executeResult(Function<JedisCommands, R> function, int index) {
        R apply = null;
        Jedis jedis = null;
        try {
            if (mode.equals("cluster")) {
                JedisCluster jedisCluster = RedisUtils.getJedisCluster();
                apply = function.apply((JedisCommands)jedisCluster);
            } else {
                jedis = RedisUtils.getJedis(index);
                apply = function.apply((JedisCommands)jedis);
            }
        }
        catch (Exception e) {
            logger.error("function apply error! consumer:{} index:{}", new Object[]{function, index, e});
        }
        finally {
            if (!mode.equals("cluster")) {
                RedisUtils.closeJedis(jedis);
            }
        }
        return apply;
    }

    private static void closeJedis(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    public static Pool<Jedis> getPool() {
        if (pool == null) {
            RedisUtils.init();
        }
        return pool;
    }

    public static JedisCluster getJedisCluster() {
        if (jedisCluster == null) {
            RedisUtils.init();
        }
        return jedisCluster;
    }
}

