/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.xinput.bootbase.util.CastUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropsUtils {
    private static Logger logger = LoggerFactory.getLogger(PropsUtils.class);

    public static Properties loadProps(String fileName) {
        Properties properties = null;
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
            if (null == is) {
                throw new FileNotFoundException(fileName + " file is not found");
            }
            properties = new Properties();
            properties.load(is);
        }
        catch (IOException e) {
            logger.error("load properties file failure", (Throwable)e);
        }
        return properties;
    }

    public static String getString(Properties properties, String key) {
        return PropsUtils.getString(properties, key, "");
    }

    public static String getString(Properties properties, String key, String defaultValue) {
        String value = defaultValue;
        if (properties.contains(key)) {
            value = properties.getProperty(key);
        }
        return value;
    }

    public static int getInt(Properties properties, String key) {
        return PropsUtils.getInt(properties, key, 0);
    }

    public static int getInt(Properties properties, String key, int defaultValue) {
        int value = defaultValue;
        if (properties.contains(key)) {
            value = CastUtils.castInt(properties.getProperty(key));
        }
        return value;
    }

    public static boolean getBoolean(Properties properties, String key) {
        return PropsUtils.getBoolean(properties, key, false);
    }

    public static boolean getBoolean(Properties properties, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (properties.contains(key)) {
            value = CastUtils.castBoolean(properties.getProperty(key));
        }
        return value;
    }

    public static long getLong(Properties properties, String key) {
        return PropsUtils.getLong(properties, key, 0L);
    }

    public static long getLong(Properties properties, String key, long defaultValue) {
        long value = defaultValue;
        if (properties.contains(key)) {
            value = CastUtils.castLong(properties.getProperty(key));
        }
        return value;
    }
}

