/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.xinput.bootbase.util.Logs;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class MimeTypes {
    private static final Logger logger = Logs.get();
    private static Properties mimetypes = null;
    private static Pattern extPattern = Pattern.compile("^.*\\.([^.]+)$");

    public static String getMimeType(String filename) {
        return MimeTypes.getMimeType(filename, "");
    }

    public static String getMimeType(String filename, String defaultMimeType) {
        Matcher matcher = extPattern.matcher(filename.toLowerCase());
        String ext = "";
        if (matcher.matches()) {
            ext = matcher.group(1);
        }
        if (ext.length() > 0) {
            String mimeType = MimeTypes.mimetypes().getProperty(ext);
            if (mimeType == null) {
                return defaultMimeType;
            }
            return mimeType;
        }
        return defaultMimeType;
    }

    public static String getContentType(String filename) {
        return MimeTypes.getContentType(filename, "application/octet-stream");
    }

    public static String getContentType(String filename, String defaultContentType) {
        String contentType = MimeTypes.getMimeType(filename, null);
        if (contentType == null) {
            contentType = defaultContentType;
        }
        return contentType;
    }

    public static boolean isValidMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        if (mimeType.indexOf(";") != -1) {
            return MimeTypes.mimetypes().contains(mimeType.split(";")[0]);
        }
        return MimeTypes.mimetypes().contains(mimeType);
    }

    private static synchronized void initMimetypes() {
        if (mimetypes != null) {
            return;
        }
        try {
            InputStream is = MimeTypes.class.getClassLoader().getResourceAsStream("com/precisource/util/mime-types.properties");
            mimetypes = new Properties();
            mimetypes.load(is);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage());
        }
    }

    private static Properties mimetypes() {
        if (mimetypes == null) {
            MimeTypes.initMimetypes();
        }
        return mimetypes;
    }
}

