/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MimeTypeUtils {
    private static final String DEFAULT_VALUE = "text/plain";

    public static String getContentType(File file) {
        if (file.isDirectory()) {
            return "the target is a directory";
        }
        AutoDetectParser parser = new AutoDetectParser();
        parser.setParsers((Map)Maps.newHashMap());
        Metadata metadata = new Metadata();
        metadata.add("resourceName", file.getName());
        try {
            FileInputStream stream = new FileInputStream(file);
            parser.parse((InputStream)stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
            ((InputStream)stream).close();
        }
        catch (IOException | TikaException | SAXException e) {
            return DEFAULT_VALUE;
        }
        return metadata.get("Content-Type");
    }
}

