/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.auth0.jwt.JWTSigner;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.JWTVerifyException;
import com.google.common.collect.Maps;
import com.xinput.bootbase.config.DefaultConfig;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;

public class JwtUtils {
    public static final String AUD = "aud";
    public static final String PLATFORM = "platform";
    public static final String EXP = "exp";
    public static final String IAT = "iat";

    public static String sign(String aud) {
        return JwtUtils.sign((Object)aud, "default");
    }

    public static String sign(Object aud) {
        return JwtUtils.sign(aud, "default");
    }

    public static String sign(Object aud, String platform) {
        return JwtUtils.sign(aud, platform, Maps.newHashMap());
    }

    public static String sign(Object aud, Map<String, Object> claims) {
        return JwtUtils.sign(aud, "default", claims);
    }

    public static String sign(Object aud, String platform, Map<String, Object> claims) {
        long iat = System.currentTimeMillis() / 1000L;
        long exp = iat + Long.valueOf(DefaultConfig.getTokenExp());
        JWTSigner signer = new JWTSigner(DefaultConfig.getApiSecureKey());
        HashMap signClaims = Maps.newHashMap();
        signClaims.put(AUD, aud);
        signClaims.put(PLATFORM, platform);
        signClaims.put(EXP, exp);
        signClaims.put(IAT, iat);
        signClaims.putAll(claims);
        String jwt = signer.sign((Map)signClaims);
        return jwt;
    }

    public static Map<String, Object> verify(String jwt) throws SignatureException, NoSuchAlgorithmException, JWTVerifyException, InvalidKeyException, IOException {
        JWTVerifier verifier = new JWTVerifier(DefaultConfig.getApiSecureKey());
        Map claims = verifier.verify(jwt);
        return claims;
    }
}

