/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.xinput.bootbase.util.Logs;
import com.xinput.bootbase.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;

public class JsonUtils {
    private static final Logger logger = Logs.get();
    private static ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setTimeZone(TimeZone.getTimeZone("GMT+8:00")).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).registerModule((Module)new JavaTimeModule().addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss"))).addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss"))));

    public static String toJsonString(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toJsonString(Object obj, boolean prettyFormat) {
        if (prettyFormat) {
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return null;
            }
        }
        return JsonUtils.toJsonString(obj);
    }

    public static <T> T toBean(String content, Class<T> clazz) {
        if (StringUtils.isNullOrEmpty(content)) {
            return null;
        }
        Object t = null;
        try {
            t = mapper.readValue(content, clazz);
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return (T)t;
    }

    public static <T> T toBean(Reader reader, Class<T> clazz) {
        if (reader == null) {
            return null;
        }
        Object t = null;
        try {
            t = mapper.readValue(reader, clazz);
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return (T)t;
    }

    public static <T> T toBean(InputStream stream, Class<T> clazz) {
        if (stream == null) {
            return null;
        }
        Object t = null;
        try {
            t = mapper.readValue(stream, clazz);
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return (T)t;
    }

    public static <T> List<T> toList(String content, Class<T> clazz) {
        if (content == null) {
            return null;
        }
        return (List)JsonUtils.readValueList(content, ArrayList.class, clazz);
    }

    private static Object readValueList(String content, Class collectionClass, Class clazz) {
        if (content == null) {
            return null;
        }
        Object o = null;
        try {
            o = mapper.readValue(content, JsonUtils.getCollectionType(collectionClass, clazz));
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return o;
    }

    private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }
}

