/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.google.common.collect.Maps;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class HttpUtils {
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset\\s*=\\s*([a-z0-9-]*)", 2);
    public static final Pattern META_CHARSET_PATTERN = Pattern.compile("<meta[^>]*?charset\\s*=\\s*['\"]?([a-z0-9-]*)", 2);

    public static boolean isHttps(String url) {
        return url.toLowerCase().startsWith("https");
    }

    public static Map<String, List<String>> decodeParamMap(String url) {
        return HttpUtils.decodeParamMap(url, HttpConstants.DEFAULT_CHARSET);
    }

    public static Map<String, List<String>> decodeParamMap(String url, Charset charset) {
        QueryStringDecoder decoderQuery = new QueryStringDecoder(url, charset);
        return decoderQuery.parameters();
    }

    public static Map<String, String> decodeParamHashMap(String url) {
        return HttpUtils.decodeParamHashMap(url, HttpConstants.DEFAULT_CHARSET);
    }

    public static Map<String, String> decodeParamHashMap(String url, Charset charset) {
        QueryStringDecoder decoderQuery = new QueryStringDecoder(url, charset);
        Map paramMaps = decoderQuery.parameters();
        HashMap maps = Maps.newHashMapWithExpectedSize((int)paramMaps.size());
        paramMaps.forEach((param, paramValues) -> paramValues.forEach(paramValue -> maps.put(param, paramValue)));
        return maps;
    }
}

