/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.univocity.parsers.common.processor.BeanListProcessor;
import com.univocity.parsers.common.processor.core.Processor;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.xinput.bootbase.util.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.List;

public class FileHelper {
    public static <T> T readFileBean(String fileName, Class<T> clazz) throws IOException {
        String demoTaskString = Files.asCharSource((File)new File(fileName), (Charset)Charsets.UTF_8).read();
        return JsonUtils.toBean(demoTaskString, clazz);
    }

    public static <T> List<T> readFileList(String fileName, Class<T> clazz) throws IOException {
        String demoTaskString = Files.asCharSource((File)new File(fileName), (Charset)Charsets.UTF_8).read();
        return JsonUtils.toList(demoTaskString, clazz);
    }

    public static <T> List<T> readCsv(String csvText, Class<T> clazz) {
        return FileHelper.readCsv(csvText, 0, clazz);
    }

    public static <T> List<T> readCsv(String csvText, int skipRowNum, Class<T> clazz) {
        BeanListProcessor rowProcessor = new BeanListProcessor(clazz);
        CsvParserSettings parserSettings = new CsvParserSettings();
        parserSettings.setProcessor((Processor)rowProcessor);
        ((CsvFormat)parserSettings.getFormat()).setLineSeparator("\n");
        ((CsvFormat)parserSettings.getFormat()).setDelimiter('\t');
        parserSettings.setNumberOfRowsToSkip((long)skipRowNum);
        CsvParser parser = new CsvParser(parserSettings);
        parser.parse((Reader)new StringReader(csvText));
        return rowProcessor.getBeans();
    }
}

