/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.xinput.bootbase.util.StringUtils;

public class DesensitizeUtils {
    public static final String PHONE_REGEX = "^1\\d{10}$";
    public static final String PHONE_BLUR_REGEX = "(\\d{3})\\d{4}(\\d{4})";
    public static final String PHONE_BLUR_REPLACE_REGEX = "$1****$2";

    public static String chineseName(String fullName) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "";
        }
        String name = StringUtils.left((String)fullName, (int)1);
        return StringUtils.rightPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)"*");
    }

    public static final boolean checkPhone(String phone) {
        if (StringUtils.isEmpty((CharSequence)phone)) {
            return false;
        }
        return phone.matches(PHONE_REGEX);
    }

    public static final boolean checkIdCard(String idCard) {
        if (StringUtils.isEmpty((CharSequence)idCard)) {
            return false;
        }
        int idCardLength = idCard.length();
        return 15 == idCardLength || 18 == idCardLength;
    }

    public static final String phone(String phone) {
        boolean checkFlag = DesensitizeUtils.checkPhone(phone);
        if (!checkFlag) {
            return phone;
        }
        return phone.replaceAll(PHONE_BLUR_REGEX, PHONE_BLUR_REPLACE_REGEX);
    }

    public static final String idCard(String idCard) {
        if (StringUtils.isBlank((CharSequence)idCard)) {
            return "";
        }
        String newIdCard = "";
        int length = idCard.length();
        switch (length) {
            case 15: {
                newIdCard = StringUtils.left((String)idCard, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)idCard, (int)3), (int)StringUtils.length((CharSequence)idCard), (String)"*"), (String)"******"));
                break;
            }
            case 18: {
                newIdCard = StringUtils.left((String)idCard, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)idCard, (int)4), (int)StringUtils.length((CharSequence)idCard), (String)"*"), (String)"******"));
                break;
            }
            default: {
                newIdCard = idCard;
            }
        }
        return newIdCard;
    }

    public static String bankCard(String cardNum) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        return StringUtils.left((String)cardNum, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)4), (int)StringUtils.length((CharSequence)cardNum), (String)"*"), (String)"******"));
    }

    public static String password(String password) {
        return "******";
    }
}

