/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.xinput.bootbase.util.StringUtils;

public class CastUtils {
    public static String castString(Object obj) {
        return CastUtils.castString(obj, "");
    }

    public static String castString(Object obj, String defaultValue) {
        return obj != null ? String.valueOf(obj) : defaultValue;
    }

    public static double castDouble(Object obj) {
        return CastUtils.castDouble(obj, 0.0);
    }

    public static double castDouble(Object obj, double defaultValue) {
        String value;
        double doubleValue = defaultValue;
        if (null != obj && StringUtils.isNotEmpty((CharSequence)(value = CastUtils.castString(obj)))) {
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                doubleValue = defaultValue;
            }
        }
        return doubleValue;
    }

    public static long castLong(Object obj) {
        return CastUtils.castLong(obj, 0L);
    }

    public static long castLong(Object obj, long defaultValue) {
        String value;
        long longValue = defaultValue;
        if (null != obj && StringUtils.isNotEmpty((CharSequence)(value = CastUtils.castString(obj)))) {
            try {
                longValue = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                longValue = defaultValue;
            }
        }
        return longValue;
    }

    public static int castInt(Object obj) {
        return CastUtils.castInt(obj, 0);
    }

    public static int castInt(Object obj, int defaultValue) {
        String value;
        int intValue = defaultValue;
        if (null != obj && StringUtils.isNotEmpty((CharSequence)(value = CastUtils.castString(obj)))) {
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                intValue = defaultValue;
            }
        }
        return intValue;
    }

    public static boolean castBoolean(Object obj) {
        return CastUtils.castBoolean(obj, false);
    }

    public static boolean castBoolean(Object obj, boolean defaultValue) {
        boolean booleanValue = defaultValue;
        if (null != obj) {
            String value = CastUtils.castString(obj);
            booleanValue = Boolean.parseBoolean(value);
        }
        return booleanValue;
    }
}

