/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class BuilderUtils<T> {
    private final Supplier<T> instantiator;
    private List<Consumer<T>> modifiers = Lists.newArrayList();

    public BuilderUtils(Supplier<T> instantiator) {
        this.instantiator = instantiator;
    }

    public static <T> BuilderUtils<T> of(Supplier<T> instantiator) {
        return new BuilderUtils<T>(instantiator);
    }

    public <P1> BuilderUtils<T> with(Consumer1<T, P1> consumer, P1 p1) {
        Consumer<Object> c = instance -> consumer.accept(instance, p1);
        this.modifiers.add(c);
        return this;
    }

    public <P1, P2> BuilderUtils<T> with(Consumer2<T, P1, P2> consumer, P1 p1, P2 p2) {
        Consumer<Object> c = instance -> consumer.accept(instance, p1, p2);
        this.modifiers.add(c);
        return this;
    }

    public T build() {
        Object value = this.instantiator.get();
        this.modifiers.forEach(modifier -> modifier.accept(value));
        this.modifiers.clear();
        return value;
    }

    @FunctionalInterface
    public static interface Consumer2<T, P1, P2> {
        public void accept(T var1, P1 var2, P2 var3);
    }

    @FunctionalInterface
    public static interface Consumer1<T, P1> {
        public void accept(T var1, P1 var2);
    }
}

