/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.util;

import com.github.dozermapper.core.DozerBeanMapperBuilder;
import com.github.dozermapper.core.Mapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;

public class BeanUtils {
    private static final Mapper MAPPER = DozerBeanMapperBuilder.buildDefault();

    public static <T, S> List<T> convertor(List<S> source, Class<T> clz) {
        if (CollectionUtils.isEmpty(source)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)source.size());
        source.forEach(s -> list.add(MAPPER.map(s, clz)));
        return list;
    }

    public static <T, S> Set<T> convertor(Set<S> source, Class<T> clz) {
        if (source == null) {
            return null;
        }
        TreeSet<Object> set = new TreeSet<Object>();
        for (S s : source) {
            set.add(MAPPER.map(s, clz));
        }
        return set;
    }

    public static <T, S> T convertor(S source, Class<T> clz) {
        if (source == null) {
            return null;
        }
        return (T)MAPPER.map(source, clz);
    }

    public static void convertor(Object source, Object object) {
        MAPPER.map(source, object);
    }

    public static <T> void copyConvertor(T source, Object object) {
        MAPPER.map(source, object);
    }
}

