/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.interceptor;

import com.xinput.bootbase.config.SpringContentUtils;
import com.xinput.bootbase.util.HttpUtils;
import com.xinput.bootbase.util.StringUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Component
public class BaseWebSocketInterceptor
implements HandshakeInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(BaseWebSocketInterceptor.class);
    private static final String TOKEN_FIELD = "token";

    public boolean beforeHandshake(ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse, WebSocketHandler webSocketHandler, Map<String, Object> map) throws Exception {
        String urlQuery = serverHttpRequest.getURI().toString();
        if (logger.isDebugEnabled()) {
            logger.debug("websocket starts handshaking. urlQuery:[{}].", (Object)urlQuery);
        }
        if ("dev".equalsIgnoreCase(SpringContentUtils.getActiveProfile())) {
            logger.info("the mode is [dev]", (Object)urlQuery);
            return true;
        }
        Map<String, String> paramMap = HttpUtils.decodeParamHashMap(urlQuery);
        String token = paramMap.getOrDefault(TOKEN_FIELD, "");
        if (StringUtils.isNullOrEmpty(token)) {
            logger.error("token is empty.");
            return false;
        }
        return true;
    }

    public void afterHandshake(ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse, WebSocketHandler webSocketHandler, Exception e) {
    }
}

