/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.interceptor;

import com.auth0.jwt.JWTExpiredException;
import com.xinput.bootbase.annotation.PassSecure;
import com.xinput.bootbase.config.SpringContentUtils;
import com.xinput.bootbase.domain.BaseHttp;
import com.xinput.bootbase.domain.Result;
import com.xinput.bootbase.exception.BaseException;
import com.xinput.bootbase.util.JwtUtils;
import com.xinput.bootbase.util.ObjectId;
import com.xinput.bootbase.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class BaseHandlerInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private ThreadLocal<BaseHttp> baseHttpThreadLocal;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        HttpMethod.OPTIONS.toString();
        if (HttpMethod.OPTIONS.toString().equalsIgnoreCase(request.getMethod())) {
            response.setStatus(200);
            return true;
        }
        this.baseHttpThreadLocal.set(new BaseHttp(request, response));
        this.setHeader(request, response);
        this.securtJwt(request, object);
        return true;
    }

    private void setHeader(HttpServletRequest request, HttpServletResponse response) {
        String requestId = (String)request.getAttribute("X-Request-Id");
        requestId = StringUtils.isNotEmpty((CharSequence)requestId) ? new StringBuilder(20).append(ObjectId.get().toString()).append("-").append(requestId).toString() : ObjectId.get().toString();
        request.setAttribute("X-Request-Id", (Object)requestId);
        String sessionId = request.getSession().getId();
        if (StringUtils.isNotEmpty((CharSequence)sessionId)) {
            response.addHeader("X-Session-Id", sessionId);
        }
        response.setContentType("application/json;charset=UTF-8");
        if ("application/json".equalsIgnoreCase(response.getContentType())) {
            response.setContentType("application/json;charset=UTF-8");
        }
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Origin, Authorization, Content-Type, If-Match, If-Modified-Since, If-None-Match, If-Unmodified-Since, Accept-Encoding, X-Request-Id");
        if (HttpMethod.OPTIONS.toString().equalsIgnoreCase(request.getMethod())) {
            response.setHeader("Access-Control-Allow-Methods", "OPTIONS, GET, POST, PATCH, PUT, DELETE");
            response.setHeader("Access-Control-Max-Age", "86400");
        }
    }

    private void securtJwt(HttpServletRequest request, Object object) {
        PassSecure passToken;
        if (!(object instanceof HandlerMethod)) {
            return;
        }
        if ("dev".equalsIgnoreCase(SpringContentUtils.getActiveProfile())) {
            return;
        }
        HandlerMethod handlerMethod = (HandlerMethod)object;
        Method method = handlerMethod.getMethod();
        if (method.isAnnotationPresent(PassSecure.class) && (passToken = method.getAnnotation(PassSecure.class)).required()) {
            return;
        }
        String token = StringUtils.trim((String)StringUtils.substringAfter((String)request.getHeader("authorization"), (String)"Bearer"));
        Result result = new Result();
        result.setCodeWithDefaultMsg(1200);
        if (StringUtils.isNullOrEmpty(token)) {
            this.unauthorized(result);
            return;
        }
        try {
            Map<String, Object> claims = JwtUtils.verify(token);
            String aud = String.valueOf(claims.get("aud"));
            request.setAttribute("aud", (Object)aud);
        }
        catch (JWTExpiredException e) {
            result.setCodeWithDefaultMsg(1210);
            this.unauthorized(result);
            return;
        }
        catch (Exception e) {
            result.setCodeWithDefaultMsg(1200);
            this.unauthorized(result);
        }
    }

    private void unauthorized(Result result) {
        throw new BaseException(HttpStatus.UNAUTHORIZED, result.getCode(), result.getMessage());
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        request.getSession().invalidate();
        if (this.baseHttpThreadLocal != null) {
            this.baseHttpThreadLocal.remove();
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

