/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.handler;

import com.xinput.bootbase.domain.BaseHttp;
import com.xinput.bootbase.domain.Result;
import com.xinput.bootbase.exception.BaseException;
import com.xinput.bootbase.exception.BaseFileException;
import com.xinput.bootbase.exception.BaseUnexpectedException;
import com.xinput.bootbase.util.BuilderUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Autowired
    private ThreadLocal<BaseHttp> baseHttpThreadLocal;

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<Result> constraintViolationExceptionHandler(HttpServletRequest req, HttpServletResponse resp, ConstraintViolationException e) {
        logger.error("{} {} ConstraintViolationException. ", new Object[]{req.getMethod(), req.getRequestURI(), e});
        String detailMessage = e.getMessage();
        if (detailMessage.contains(":")) {
            detailMessage = detailMessage.substring(detailMessage.indexOf(":") + 1);
        }
        Result result = BuilderUtils.of(Result::new).with(Result::setCode, 1100).with(Result::setMessage, detailMessage).build();
        this.clear(req);
        return ResponseEntity.status((int)HttpStatus.BAD_REQUEST.value()).body((Object)result);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<Result> methodArgumentNotValidException(HttpServletRequest req, HttpServletResponse resp, MethodArgumentNotValidException e) {
        List errors = e.getBindingResult().getAllErrors();
        StringBuffer errorMsg = new StringBuffer();
        errors.stream().forEach(x -> errorMsg.append(x.getDefaultMessage()).append(";"));
        Result result = BuilderUtils.of(Result::new).with(Result::setCode, 1100).with(Result::setMessage, errorMsg.toString()).build();
        this.clear(req);
        return ResponseEntity.status((int)HttpStatus.BAD_REQUEST.value()).body((Object)result);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<Result> httpMessageNotReadableExceptionHandler(HttpServletRequest req, HttpServletResponse resp, HttpMessageNotReadableException e) {
        String detailMessage = e.getMessage();
        if (detailMessage.contains(":")) {
            detailMessage = detailMessage.substring(0, detailMessage.indexOf(":"));
        }
        Result result = BuilderUtils.of(Result::new).with(Result::setCode, 1100).with(Result::setMessage, detailMessage).build();
        this.clear(req);
        return ResponseEntity.status((int)HttpStatus.BAD_REQUEST.value()).body((Object)result);
    }

    @ExceptionHandler(value={NullPointerException.class})
    public ResponseEntity<Result> constraintViolationExceptionHandler(HttpServletRequest req, HttpServletResponse resp, NullPointerException npe) {
        logger.error("{} {} NullPointerException.", new Object[]{req.getMethod(), req.getRequestURI(), npe});
        String detailMessage = npe.getStackTrace()[0].toString();
        Result result = BuilderUtils.of(Result::new).with(Result::setCode, 5000).with(Result::setMessage, detailMessage).build();
        this.clear(req);
        return ResponseEntity.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).body((Object)result);
    }

    @ExceptionHandler(value={BaseFileException.class})
    public ResponseEntity<Object> baseFileExceptionHandler(HttpServletRequest req, HttpServletResponse resp, BaseFileException bfe) {
        this.clear(req);
        ResponseEntity responseEntity = ResponseEntity.ok().contentLength(bfe.getSize().longValue()).body((Object)bfe.getResource());
        return responseEntity;
    }

    @ExceptionHandler(value={BaseException.class})
    public ResponseEntity<Result> baseExceptionHandler(HttpServletRequest req, HttpServletResponse resp, BaseException be) {
        ResponseEntity responseEntity;
        switch (be.getHttpStatus()) {
            case OK: {
                Object msg = be.getMsg();
                if (msg == null) {
                    responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
                    break;
                }
                responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body(be.getMsg());
                break;
            }
            case CREATED: 
            case NO_CONTENT: {
                responseEntity = ResponseEntity.status((HttpStatus)be.getHttpStatus()).body(be.getMsg());
                break;
            }
            default: {
                Result result = BuilderUtils.of(Result::new).with(Result::setCode, be.getCode()).with(Result::setMessage, be.getMsg()).build();
                responseEntity = ResponseEntity.status((HttpStatus)be.getHttpStatus()).body((Object)result);
            }
        }
        this.clear(req);
        return responseEntity;
    }

    @ExceptionHandler(value={BaseUnexpectedException.class})
    public ResponseEntity<Result> baseUnexpectedExceptionHandler(HttpServletRequest req, HttpServletResponse resp, BaseUnexpectedException une) {
        logger.error("request-id:[{}] request:[{}:{}]", new Object[]{req.getAttribute("X-Request-Id"), req.getMethod(), req.getRequestURI(), une});
        return this.global(req, une.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Result> exceptionHandler(HttpServletRequest req, Exception e) {
        logger.error("request-id:[{}] request:[{}:{}]", new Object[]{req.getAttribute("X-Request-Id"), req.getMethod(), req.getRequestURI(), e});
        return this.global(req, e.getMessage());
    }

    @ExceptionHandler(value={Error.class})
    public ResponseEntity<Result> errorHandler(HttpServletRequest req, Error error) {
        logger.error("request-id:[{}] request:[{}:{}]", new Object[]{req.getAttribute("X-Request-Id"), req.getMethod(), req.getRequestURI(), error});
        return this.global(req, error.getMessage());
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<Result> throwableHandler(HttpServletRequest req, Throwable throwable) {
        logger.error("request-id:[{}] request:[{}:{}]", new Object[]{req.getAttribute("X-Request-Id"), req.getMethod(), req.getRequestURI(), throwable});
        return this.global(req, throwable.getMessage());
    }

    private ResponseEntity<Result> global(HttpServletRequest req, String errorMsg) {
        Result result = BuilderUtils.of(Result::new).with(Result::setCode, 5000).with(Result::setMessage, errorMsg).build();
        this.clear(req);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)result);
    }

    private void clear(HttpServletRequest req) {
        if (req != null && req.getSession() != null) {
            req.getSession().invalidate();
        }
        if (this.baseHttpThreadLocal != null) {
            this.baseHttpThreadLocal.remove();
        }
    }
}

