/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.handler;

import com.xinput.bootbase.config.DefaultConfig;
import com.xinput.bootbase.config.SpringContentUtils;
import com.xinput.bootbase.domain.WssManager;
import com.xinput.bootbase.util.HttpUtils;
import com.xinput.bootbase.util.JwtUtils;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public abstract class AbstractTextWebSocketHandler
extends TextWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTextWebSocketHandler.class);
    protected static final String TOKEN_FIELD = "token";

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        if ("dev".equalsIgnoreCase(SpringContentUtils.getActiveProfile())) {
            WssManager.add(DefaultConfig.getMockUserId(), session);
            return;
        }
        Map<String, String> paramMap = HttpUtils.decodeParamHashMap(session.getUri().toString());
        String token = paramMap.getOrDefault(TOKEN_FIELD, "");
        if (Objects.isNull(token)) {
            logger.error("\u975e\u6d4b\u8bd5\u73af\u5883\uff0cwebSocket\u8fde\u63a5\u5fc5\u987b\u5e26\u6709token\u5c5e\u6027");
            throw new RuntimeException("\u957f\u8fde\u63a5\u6ca1\u6709token");
        }
        Map<String, Object> claims = JwtUtils.verify(token);
        String userId = String.valueOf(claims.getOrDefault("aud", ""));
        String platform = String.valueOf(claims.getOrDefault("platform", "default"));
        if (logger.isDebugEnabled()) {
            logger.debug("\u7528\u6237[ {} ]\u521b\u5efa\u8fde\u63a5", (Object)token);
        }
        session.getAttributes().put("aud", userId);
        session.getAttributes().put("platform", platform);
        WssManager.add(platform + "-" + userId, session);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        if ("dev".equalsIgnoreCase(SpringContentUtils.getActiveProfile())) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u7528\u6237 [{}] \u65ad\u5f00\u8fde\u63a5", (Object)DefaultConfig.getMockUserId());
            }
            WssManager.remove(DefaultConfig.getMockUserId());
            session.close();
            return;
        }
        Object userId = session.getAttributes().get("aud");
        String platform = session.getAttributes().getOrDefault("platform", "default");
        if (Objects.nonNull(userId)) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u7528\u6237 [{}] \u65ad\u5f00\u8fde\u63a5", userId);
            }
            WssManager.remove(platform + "-" + userId);
        }
        session.close();
    }
}

