/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.domain;

import com.xinput.bootbase.config.DefaultConfig;
import com.xinput.bootbase.config.SpringContentUtils;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public class WssManager {
    private static final Logger logger = LoggerFactory.getLogger(WssManager.class);
    private static ConcurrentHashMap<String, WebSocketSession> webSocketSessionMap = new ConcurrentHashMap();

    public static void add(String key, WebSocketSession session) {
        webSocketSessionMap.put(key, session);
    }

    public static WebSocketSession remove(String key) {
        return webSocketSessionMap.remove(key);
    }

    public static void removeAndClose(String key) {
        WebSocketSession session = WssManager.remove(key);
        if (session != null) {
            try {
                session.close();
            }
            catch (IOException e) {
                logger.error("Websocket session close exception ", (Throwable)e);
            }
        }
    }

    public static ConcurrentHashMap<String, WebSocketSession> getAll() {
        return webSocketSessionMap;
    }

    public static WebSocketSession get(String key) {
        return webSocketSessionMap.get(key);
    }

    public static String getUserId(WebSocketSession session) {
        if ("dev".equalsIgnoreCase(SpringContentUtils.getActiveProfile())) {
            return DefaultConfig.getMockUserId();
        }
        Object obj = session.getAttributes().get("aud");
        if (obj != null) {
            return String.valueOf(obj);
        }
        return null;
    }
}

