/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.dao;

import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public abstract class BaseMongoDao<T> {
    protected MongoTemplate mongoTemplate;

    protected abstract Class<T> getEntityClass();

    protected abstract void setMongoTemplate(MongoTemplate var1);

    public T save(T bean) {
        this.mongoTemplate.save(bean);
        return bean;
    }

    public T insert(T bean) {
        this.mongoTemplate.insert(bean);
        return bean;
    }

    public void insertAll(List<T> beans) {
        this.mongoTemplate.insertAll(beans);
    }

    public void insert(List<T> beans) {
        this.mongoTemplate.insert(beans);
    }

    public void delete(Query query) {
        this.mongoTemplate.remove(query, this.getEntityClass());
    }

    public void remove(T bean) {
        this.mongoTemplate.remove(bean);
    }

    public T findAndRemove(Query query) {
        return (T)this.mongoTemplate.findAndRemove(query, this.getEntityClass());
    }

    public List<T> findAllAndRemove(Query query) {
        return this.mongoTemplate.findAllAndRemove(query, this.getEntityClass());
    }

    public void updateFirst(Query query, Update update) {
        this.mongoTemplate.updateFirst(query, update, this.getEntityClass());
    }

    public void updateMulti(Query query, Update update) {
        this.mongoTemplate.updateMulti(query, update, this.getEntityClass());
    }

    public void upsert(Query query, Update update) {
        this.mongoTemplate.upsert(query, update, this.getEntityClass());
    }

    public T findAndModify(Query query, Update update) {
        return (T)this.mongoTemplate.findAndModify(query, update, this.getEntityClass());
    }

    public T findById(String id) {
        return (T)this.mongoTemplate.findById((Object)id, this.getEntityClass());
    }

    public T findOne(Query query) {
        return (T)this.mongoTemplate.findOne(query, this.getEntityClass());
    }

    public List<T> findAll() {
        return this.mongoTemplate.findAll(this.getEntityClass());
    }

    public List<T> find(Query query) {
        return this.mongoTemplate.find(query, this.getEntityClass());
    }

    public long count(Query query) {
        return this.mongoTemplate.count(query, this.getEntityClass());
    }

    public List<T> find(Query query, List<Sort.Order> orders, Integer skip, Integer limit) {
        if (null != orders && orders.size() > 0) {
            query.with(Sort.by(orders));
        }
        if (limit != null) {
            query.limit(limit.intValue());
        }
        if (skip != null) {
            query.skip((long)skip.intValue());
        }
        return this.mongoTemplate.find(query, this.getEntityClass());
    }
}

