/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.config;

import com.google.common.collect.Lists;
import com.xinput.bootbase.util.SimpleProperties;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class DefaultConfig {
    private static final long TOKEN_EXP = 86400L;
    private static final long REFRESH_TOKEN_EXP = 604800L;
    private static SimpleProperties SP;

    public static final String getMockUserId() {
        return DefaultConfig.get("mock.userId", "1");
    }

    public static final String getMockUserName() {
        return DefaultConfig.get("mock.userName", "xinput-001");
    }

    public static final String getCookieTokenName() {
        return DefaultConfig.get("api.cookie.token", "jwt");
    }

    public static final boolean getCookieSecure() {
        return DefaultConfig.getBoolean("api.cookie.enable", Boolean.FALSE);
    }

    public static final boolean getSecureEnable() {
        return DefaultConfig.getBoolean("api.cookie.enable", Boolean.TRUE);
    }

    public static String getTokenExp() {
        return DefaultConfig.get("token.exp", String.valueOf(86400L));
    }

    public static String getRefreshToeknExp() {
        return DefaultConfig.get("refresh.token.exp", String.valueOf(604800L));
    }

    public static String getApiSecureKey() {
        return DefaultConfig.get("api.secret.key", "xinput-boot");
    }

    public static String getWechatAppid() {
        return DefaultConfig.get("wechat.appid");
    }

    public static String getWechatSecret() {
        return DefaultConfig.get("wechat.secret");
    }

    public static String getBucketKey() {
        return DefaultConfig.get("bucket.access.key");
    }

    public static String getBucketSecretKey() {
        return DefaultConfig.get("bucket.access.secret");
    }

    public static int getDefaultLimit() {
        return DefaultConfig.getInt("limit.default", 10);
    }

    public static int getMaxLimit() {
        return DefaultConfig.getInt("limit.max", 50);
    }

    public static int getMaxOffset() {
        return DefaultConfig.getInt("offset.max", 1000000);
    }

    public static final int getInt(String key, int defaultValue) {
        if (SP == null) {
            return 0;
        }
        return SP.getIntProperty(key, defaultValue);
    }

    public static final String get(String key) {
        return DefaultConfig.get(key, "");
    }

    public static final String get(String key, String defaultValue) {
        if (SP == null) {
            return defaultValue;
        }
        return SP.getStringProperty(key, defaultValue);
    }

    public static final boolean getBoolean(String key) {
        return DefaultConfig.getBoolean(key, Boolean.FALSE);
    }

    public static final boolean getBoolean(String key, boolean defaultValue) {
        if (SP == null) {
            return defaultValue;
        }
        return SP.getBooleanProperty(key, defaultValue);
    }

    public static final List<String> getList(String key) {
        return DefaultConfig.getList(key, Lists.newArrayList());
    }

    public static final List<String> getList(String key, List<String> defaultList) {
        if (SP == null) {
            return defaultList;
        }
        Object[] arrs = SP.getStringArrayProperty(key);
        if (ArrayUtils.isEmpty((Object[])arrs)) {
            return Lists.newArrayList((Object[])arrs);
        }
        return defaultList;
    }

    static {
        try {
            SP = SimpleProperties.readConfiguration("system.properties");
        }
        catch (Exception e) {
            SP = null;
        }
    }
}

