/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.api;

import com.xinput.bootbase.config.DefaultConfig;
import com.xinput.bootbase.domain.BaseHttp;
import com.xinput.bootbase.domain.Result;
import com.xinput.bootbase.exception.BaseException;
import com.xinput.bootbase.exception.BaseFileException;
import com.xinput.bootbase.exception.BaseUnexpectedException;
import com.xinput.bootbase.util.MimeTypes;
import com.xinput.bootbase.util.StringUtils;
import com.xinput.bootbase.util.TimeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.net.URLCodec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public abstract class BaseService {
    private static final String INLINE_DISPOSITION_TYPE = "inline";
    private static final String ATTACHMENT_DISPOSITION_TYPE = "attachment";
    private static final URLCodec ENCODER = new URLCodec();
    @Autowired
    private ThreadLocal<BaseHttp> baseHttpThreadLocal;

    protected void setJwtCookie(String jwt, String duration) {
        Cookie cookie = new Cookie(DefaultConfig.getCookieTokenName(), jwt);
        cookie.setPath("/");
        cookie.setSecure(DefaultConfig.getCookieSecure());
        cookie.setHttpOnly(true);
        cookie.setMaxAge(TimeUtils.parseDuration(duration));
        this.baseHttpThreadLocal.get().getResponsen().addCookie(cookie);
    }

    protected void renderBinary(File file) {
        this.render(file, null, file.getName(), true);
    }

    protected void renderBinary(File file, String name) {
        this.render(file, null, name, false);
    }

    protected void renderBinary(InputStream is) {
        this.render(null, is, null, true);
    }

    protected void renderBinary(InputStream is, String name) {
        this.render(null, is, name, false);
    }

    private void render(File file, InputStream is, String name, boolean inline) {
        HttpServletResponse response = this.baseHttpThreadLocal.get().getResponsen();
        if (name != null) {
            this.setContentTypeIfNotSet(response, MimeTypes.getContentType(name));
        }
        try {
            if (StringUtils.isEmpty((CharSequence)response.getHeader("Content-Disposition"))) {
                this.addContentDispositionHeader(response, name, inline);
            }
            if (file != null) {
                BaseService.renderFile(file);
            } else {
                BaseService.renderInputStream(is, response);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderInputStream(InputStream inputStream, HttpServletResponse response) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        byte[] cache = new byte[1024];
        int nRead = 0;
        while ((nRead = inputStream.read(cache)) != -1) {
            outputStream.write(cache, 0, nRead);
            outputStream.flush();
        }
        outputStream.flush();
    }

    private static void renderFile(File file) {
        if (!file.exists()) {
            throw new BaseUnexpectedException("Your file does not exists (" + file + ")");
        }
        if (!file.canRead()) {
            throw new BaseUnexpectedException("Can't read your file (" + file + ")");
        }
        if (!file.isFile()) {
            throw new BaseUnexpectedException("Your file is not a real file (" + file + ")");
        }
        InputStreamResource resource = null;
        try {
            resource = new InputStreamResource((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new BaseUnexpectedException("Your file does not found (" + file + ")");
        }
        throw new BaseFileException(resource, file.length());
    }

    private void setContentTypeIfNotSet(HttpServletResponse response, String contentType) {
        if (StringUtils.isEmpty((CharSequence)response.getContentType())) {
            response.setContentType(contentType);
        }
    }

    private void addContentDispositionHeader(HttpServletResponse response, String name, boolean inline) throws UnsupportedEncodingException {
        if (name == null) {
            response.setHeader("Content-Disposition", this.dispositionType(inline));
        } else if (this.canAsciiEncode(name)) {
            String contentDisposition = "%s; filename=\"%s\"";
            response.setHeader("Content-Disposition", String.format(contentDisposition, this.dispositionType(inline), name));
        } else {
            String encoding = response.getCharacterEncoding();
            String contentDisposition = "%1$s; filename*=" + encoding + "''%2$s; filename=\"%2$s\"";
            response.setHeader("Content-Disposition", String.format(contentDisposition, this.dispositionType(inline), ENCODER.encode(name, encoding)));
        }
    }

    private String dispositionType(boolean inline) {
        return inline ? INLINE_DISPOSITION_TYPE : ATTACHMENT_DISPOSITION_TYPE;
    }

    private boolean canAsciiEncode(String string) {
        CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
        return asciiEncoder.canEncode(string);
    }

    protected void badRequestIfNull(Object object, String message) {
        if (object == null) {
            this.badRequest(message);
        }
    }

    protected void badRequest() {
        this.badRequest("Bad request");
    }

    protected void badRequest(String message) throws BaseException {
        throw new BaseException(HttpStatus.BAD_REQUEST, 2100, message);
    }

    protected void badRequest(Result result) {
        throw new BaseException(HttpStatus.BAD_REQUEST, result.getCode(), result.getMessage());
    }

    protected void unauthorized(Result result) {
        throw new BaseException(HttpStatus.UNAUTHORIZED, result.getCode(), result.getMessage());
    }

    public void unauthorized(String message) {
        throw new BaseException(HttpStatus.UNAUTHORIZED, 1200, message);
    }

    public void unauthorized() {
        throw new BaseException(HttpStatus.UNAUTHORIZED, 1200);
    }

    protected void notFound(String message) {
        throw new BaseException(HttpStatus.NOT_FOUND, 2100, message);
    }

    protected void notFound() {
        this.notFound("");
    }

    protected void notFoundIfNull(Object o) {
        if (o == null) {
            this.notFound();
        }
    }

    protected void notFoundIfNull(Object o, String message) {
        if (o == null) {
            this.notFound(message);
        }
    }

    protected void error() {
        throw new BaseException(HttpStatus.INTERNAL_SERVER_ERROR, 5000);
    }

    protected void error(String message) {
        throw new BaseException(HttpStatus.INTERNAL_SERVER_ERROR, 5000, message);
    }

    protected void error(Result result) {
        throw new BaseException(HttpStatus.INTERNAL_SERVER_ERROR, result.getCode(), result.getMessage());
    }

    public void limitExceeded(String message) {
        throw new BaseException(HttpStatus.BANDWIDTH_LIMIT_EXCEEDED, 2500, message);
    }
}

