/*
 * Decompiled with CFR 0.152.
 */
package com.xinput.bootbase.api;

import com.google.common.collect.Maps;
import com.xinput.bootbase.config.DefaultConfig;
import com.xinput.bootbase.config.SpringContentUtils;
import com.xinput.bootbase.domain.BaseHttp;
import com.xinput.bootbase.domain.Header;
import com.xinput.bootbase.domain.Result;
import com.xinput.bootbase.exception.BaseException;
import com.xinput.bootbase.exception.BaseFileException;
import com.xinput.bootbase.exception.BaseUnexpectedException;
import com.xinput.bootbase.util.JsonUtils;
import com.xinput.bootbase.util.MimeTypes;
import com.xinput.bootbase.util.StreamUtils;
import com.xinput.bootbase.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public abstract class BaseController {
    private static final String INLINE_DISPOSITION_TYPE = "inline";
    private static final String ATTACHMENT_DISPOSITION_TYPE = "attachment";
    private static final URLCodec encoder = new URLCodec();
    @Autowired
    private ThreadLocal<BaseHttp> baseHttpThreadLocal;

    protected String currentUserId() {
        if ("dev".equalsIgnoreCase(SpringContentUtils.getActiveProfile())) {
            return DefaultConfig.getMockUserId();
        }
        Object obj = this.baseHttpThreadLocal.get().getRequest().getAttribute("aud");
        if (obj != null) {
            return String.valueOf(obj);
        }
        return "";
    }

    protected void setTotalCount(long totalCount) {
        this.setTotalCount("X-Total-Count", totalCount);
    }

    protected void setTotalCount(String headerName, long totalCount) {
        this.setHeader(headerName, String.valueOf(totalCount));
    }

    protected void setHeader(String headerName, String value) {
        HttpServletResponse response = this.baseHttpThreadLocal.get().getResponsen();
        String headerValue = response.getHeader("Access-Control-Expose-Headers");
        response.setHeader("Access-Control-Expose-Headers", headerValue + "," + headerName);
        response.setHeader(headerName, value);
    }

    protected void setHeader(List<Header> headers) {
        HttpServletResponse response = this.baseHttpThreadLocal.get().getResponsen();
        String headerNames = StreamUtils.union(StreamUtils.collectColumn(headers, Header::getName));
        String headerValue = response.getHeader("Access-Control-Expose-Headers");
        response.setHeader("Access-Control-Expose-Headers", headerValue + "," + headerNames);
        if (CollectionUtils.isEmpty(headers)) {
            headers.forEach(header -> response.setHeader(header.getName(), String.valueOf(header.getValue())));
        }
    }

    protected void renderEmptyList() {
        HttpServletResponse response = this.baseHttpThreadLocal.get().getResponsen();
        String headerValue = response.getHeader("Access-Control-Expose-Headers");
        response.setHeader("Access-Control-Expose-Headers", headerValue + "," + "X-Total-Count");
        response.setHeader("X-Total-Count", "0");
        throw new BaseException(HttpStatus.OK, Lists.newArrayList());
    }

    protected void ok() {
        throw new BaseException(HttpStatus.OK);
    }

    protected void renderBinary(File file) {
        this.render(file, null, file.getName(), true);
    }

    protected void renderBinary(File file, String name) {
        this.render(file, null, name, false);
    }

    protected void renderBinary(InputStream is) {
        this.render(null, is, null, true);
    }

    protected void renderBinary(InputStream is, String name) {
        this.render(null, is, name, false);
    }

    private void render(File file, InputStream is, String name, boolean inline) {
        HttpServletResponse response = this.baseHttpThreadLocal.get().getResponsen();
        if (name != null) {
            this.setContentTypeIfNotSet(response, MimeTypes.getContentType(name));
        }
        try {
            if (StringUtils.isEmpty((CharSequence)response.getHeader("Content-Disposition"))) {
                this.addContentDispositionHeader(response, name, inline);
            }
            if (file != null) {
                BaseController.renderFile(file);
            } else {
                BaseController.renderInputStream(is, response);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderInputStream(InputStream inputStream, HttpServletResponse response) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        byte[] cache = new byte[1024];
        int nRead = 0;
        while ((nRead = inputStream.read(cache)) != -1) {
            outputStream.write(cache, 0, nRead);
            outputStream.flush();
        }
        outputStream.flush();
    }

    private static void renderFile(File file) {
        if (!file.exists()) {
            throw new BaseUnexpectedException("Your file does not exists (" + file + ")");
        }
        if (!file.canRead()) {
            throw new BaseUnexpectedException("Can't read your file (" + file + ")");
        }
        if (!file.isFile()) {
            throw new BaseUnexpectedException("Your file is not a real file (" + file + ")");
        }
        InputStreamResource resource = null;
        try {
            resource = new InputStreamResource((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new BaseUnexpectedException("Your file does not found (" + file + ")");
        }
        throw new BaseFileException(resource, file.length());
    }

    private void setContentTypeIfNotSet(HttpServletResponse response, String contentType) {
        if (StringUtils.isEmpty((CharSequence)response.getContentType())) {
            response.setContentType(contentType);
        }
    }

    private void addContentDispositionHeader(HttpServletResponse response, String name, boolean inline) throws UnsupportedEncodingException {
        if (name == null) {
            response.setHeader("Content-Disposition", this.dispositionType(inline));
        } else if (this.canAsciiEncode(name)) {
            String contentDisposition = "%s; filename=\"%s\"";
            response.setHeader("Content-Disposition", String.format(contentDisposition, this.dispositionType(inline), name));
        } else {
            String encoding = response.getCharacterEncoding();
            String contentDisposition = "%1$s; filename*=" + encoding + "''%2$s; filename=\"%2$s\"";
            response.setHeader("Content-Disposition", String.format(contentDisposition, this.dispositionType(inline), encoder.encode(name, encoding)));
        }
    }

    private String dispositionType(boolean inline) {
        return inline ? INLINE_DISPOSITION_TYPE : ATTACHMENT_DISPOSITION_TYPE;
    }

    private boolean canAsciiEncode(String string) {
        CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
        return asciiEncoder.canEncode(string);
    }

    protected void created(Object data) {
        throw new BaseException(HttpStatus.CREATED, data);
    }

    protected void created(String message) {
        throw new BaseException(HttpStatus.CREATED, message);
    }

    protected void noContent() {
        throw new BaseException(HttpStatus.NO_CONTENT);
    }

    protected void resetContent() {
        throw new BaseException(HttpStatus.RESET_CONTENT);
    }

    protected void redirect(String url) {
        HttpServletResponse response = this.baseHttpThreadLocal.get().getResponsen();
        response.setHeader("Location", url);
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            HashMap map = Maps.newHashMap();
            map.put("url", url);
            map.put("code", "resource not exists");
            map.put("request_id", this.baseHttpThreadLocal.get().getRequest().getAttribute("X-Request-Id"));
            throw new BaseException(HttpStatus.NOT_FOUND, 2100, JsonUtils.toJsonString(map));
        }
    }

    protected void badRequestIfNull(Object object, String message) {
        if (object == null) {
            this.badRequest(message);
        }
    }

    protected void badRequest() {
        this.badRequest("Bad request");
    }

    protected void badRequest(String message) throws BaseException {
        throw new BaseException(HttpStatus.BAD_REQUEST, 2100, message);
    }

    protected void badRequest(Result result) {
        throw new BaseException(HttpStatus.BAD_REQUEST, result.getCode(), result.getMessage());
    }

    public void forbidden() {
        throw new BaseException(HttpStatus.FORBIDDEN, 1400);
    }

    public void forbidden(String message) {
        throw new BaseException(HttpStatus.BANDWIDTH_LIMIT_EXCEEDED, 2500, message);
    }

    public void forbidden(Result result) {
        throw new BaseException(HttpStatus.BANDWIDTH_LIMIT_EXCEEDED, result.getCode(), result.getMessage());
    }

    protected void notFound(String message) {
        throw new BaseException(HttpStatus.NOT_FOUND, 2100, message);
    }

    protected void notFound() {
        this.notFound("");
    }

    protected void notFoundIfNull(Object o) {
        if (o == null) {
            this.notFound();
        }
    }

    protected void notFoundIfNull(Object o, String message) {
        if (o == null) {
            this.notFound(message);
        }
    }
}

