/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ai2b.post.processing.service;

import com.baidu.ai2b.post.processing.config.PostProcessingConfig;
import com.baidu.ai2b.post.processing.model.PostProcessingRequest;
import com.baidu.ai2b.post.processing.model.PostProcessingResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class PostProcessingService {
    private static final Logger log = LoggerFactory.getLogger(PostProcessingService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private PostProcessingConfig postProcessingConfig;

    public String sendRequest(String content, String name) {
        if (!this.postProcessingConfig.isEnable() || !StringUtils.hasText((String)content)) {
            return content;
        }
        String url = String.format("http://%s:%s%s", this.postProcessingConfig.getIp(), this.postProcessingConfig.getPort(), this.postProcessingConfig.getUrl());
        PostProcessingRequest request = this.wrapPostProcessingRequest(content, name);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/json");
        HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
        try {
            PostProcessingResponse response = (PostProcessingResponse)this.restTemplate.postForObject(url, (Object)entity, PostProcessingResponse.class, new Object[0]);
            if (response != null && response.isSuccess() && response.getResult() != null) {
                content = response.getResult().getContent();
            }
        }
        catch (Exception e) {
            log.warn("failed to get post processing result, exception: ", (Throwable)e);
        }
        return content;
    }

    public String sendRequest(String content) {
        return this.sendRequest(content, this.postProcessingConfig.getName());
    }

    private PostProcessingRequest wrapPostProcessingRequest(String content, String name) {
        PostProcessingRequest request = new PostProcessingRequest();
        request.setName(this.postProcessingConfig.getName());
        if (StringUtils.hasText((String)name)) {
            request.setName(name);
        }
        request.setTimes(this.postProcessingConfig.getTimes());
        request.setEnableHotWord(this.postProcessingConfig.isEnableHotWord());
        request.setEnableFilterWord(this.postProcessingConfig.isEnableFilterWord());
        request.setEnableWordTable(this.postProcessingConfig.isEnableWordTable());
        request.setEnableWordTableRegex(this.postProcessingConfig.isEnableWordTableRegex());
        request.setEnableSensitiveWord(this.postProcessingConfig.isEnableSensitiveWord());
        request.setEnableDigitalNormalization(this.postProcessingConfig.isEnableDigitalNormalization());
        request.setEnableCapitalLetters(this.postProcessingConfig.isEnableCapitalLetters());
        request.setEnableRemovePunctuation(this.postProcessingConfig.isEnableRemovePunctuation());
        request.setContent(content);
        return request;
    }
}

