package com.baidu.ai2b.post.processing.service;

import com.baidu.ai2b.post.processing.config.PostProcessingConfig;
import com.baidu.ai2b.post.processing.model.PostProcessingRequest;
import com.baidu.ai2b.post.processing.model.PostProcessingResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;


/**
 * 类<code>PostProcessingService</code>用于：
 *
 * @author Xia Shuai(xiashuai01@baidu.com)
 * @version 1.0
 **/
@Service
@Slf4j
public class PostProcessingService {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private PostProcessingConfig postProcessingConfig;

    /**
     * 请求后处理，获取后处理结果
     *
     * @param content 待替换文本
     * @param name    使用的名称
     * @return 处理后结果
     */
    public String sendRequest(String content, String name) {
        if (!postProcessingConfig.isEnable() || !StringUtils.hasText(content)) {
            return content;
        }
        String url = String.format("http://%s:%s%s",
                postProcessingConfig.getIp(),
                postProcessingConfig.getPort(),
                postProcessingConfig.getUrl());

        // 设置请求参数
        PostProcessingRequest request = wrapPostProcessingRequest(content, name);

        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/json");
        HttpEntity<PostProcessingRequest> entity = new HttpEntity<>(request, headers);
        try {
            PostProcessingResponse response = restTemplate.postForObject(url, entity, PostProcessingResponse.class);
            if (response != null && response.isSuccess() && response.getResult() != null) {
                content = response.getResult().getContent();
            }
        } catch (Exception e) {
            log.warn("failed to get post processing result, exception: ", e);
        }

        return content;
    }

    /**
     * 请求后处理，获取后处理结果
     *
     * @param content 待替换文本
     * @return 处理后结果
     */
    public String sendRequest(String content) {
        return sendRequest(content, postProcessingConfig.getName());
    }

    /**
     * 包装PostProcessingRequest对象
     *
     * @param content 文本内容
     * @param name    名称
     * @return PostProcessingRequest对象
     */
    private PostProcessingRequest wrapPostProcessingRequest(String content, String name) {
        PostProcessingRequest request = new PostProcessingRequest();
        request.setName(postProcessingConfig.getName());
        if (StringUtils.hasText(name)) {
            request.setName(name);
        }
        request.setTimes(postProcessingConfig.getTimes());
        request.setEnableHotWord(postProcessingConfig.isEnableHotWord());
        request.setEnableFilterWord(postProcessingConfig.isEnableFilterWord());
        request.setEnableWordTable(postProcessingConfig.isEnableWordTable());
        request.setEnableWordTableRegex(postProcessingConfig.isEnableWordTableRegex());
        request.setEnableSensitiveWord(postProcessingConfig.isEnableSensitiveWord());
        request.setEnableDigitalNormalization(postProcessingConfig.isEnableDigitalNormalization());
        request.setEnableCapitalLetters(postProcessingConfig.isEnableCapitalLetters());
        request.setEnableRemovePunctuation(postProcessingConfig.isEnableRemovePunctuation());

        request.setContent(content);

        return request;
    }
}
