package com.baidu.ai2b.post.processing.config;


import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;

/**
 * 类<code>RestTemplateConfig</code>用于：
 *
 * @author Xia Shuai(xiashuai01@baidu.com)
 * @version 1.0
 **/
@Configuration
public class RestTemplateConfig {
    /**
     * 创建一个RestTemplate对象，用于发送HTTP请求。
     *
     * @param factory 自定义的ClientHttpRequestFactory对象，用于创建底层的HTTP请求
     * @return 返回一个配置好的RestTemplate对象
     */
    @Bean
    public RestTemplate restTemplate(ClientHttpRequestFactory factory) {
        RestTemplate restTemplate = new RestTemplate(factory);
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }

    /**
     * 创建一个简单的ClientHttpRequestFactory对象，并设置读取超时和连接超时时间
     *
     * @return 返回一个ClientHttpRequestFactory对象
     */
    @Bean
    public ClientHttpRequestFactory simpleClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(60000);
        factory.setConnectTimeout(5000);
        return factory;
    }
}
