/*
 * Copyright 1999-2015 dangdang.com.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * </p>
 */

package com.github.xiaoluo.elasticjob.lite.autoconfigure;

import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperConfiguration;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import com.github.xiaoluo.elasticjob.lite.properties.ZookeeperProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created with IntelliJ IDEA.
 *
 * @author: lee 2020/12/03
 */
@Configuration
@ConditionalOnExpression("'${elaticjob.zookeeper.server-lists}'.length() > 0")
@EnableConfigurationProperties({ZookeeperProperties.class})
public class RegistryCenterConfiguration {

    @Autowired
    ZookeeperProperties zookeeperProperties;

    @Bean(initMethod = "init")
    public ZookeeperRegistryCenter regCenter() {
        if (StringUtils.isBlank(zookeeperProperties.getServerLists()) && StringUtils.isBlank(zookeeperProperties.getNamespace())) {
            throw new RuntimeException("not exist zookeeper serverList&&nameSpace !");
        }
        ZookeeperConfiguration zookeeperConfiguration = new ZookeeperConfiguration(zookeeperProperties.getServerLists(),
                zookeeperProperties.getNamespace());
        BeanUtils.copyProperties(zookeeperProperties, zookeeperConfiguration);
        return new ZookeeperRegistryCenter(zookeeperConfiguration);
    }
}
