package com.github.xiaoluo.elasticjob.lite.properties;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 *
 * @author: lee 2020/12/03
 */
@ConfigurationProperties(
        prefix = "elasticjob.zookeeper"
)
@NoArgsConstructor
@Data
@ToString
public class ZookeeperProperties implements Serializable {
    /**
     * 连接Zookeeper服务器的列表,包括IP地址和端口号,多个地址用逗号分隔。
     * 如: host1:2181,host2:2181
     */
    private String serverLists;
    /**
     * zookeeper命名空间
     */
    private String namespace;
    /**
     * zookeeper等待重试的间隔时间的初始值 默认1000，单位：毫秒
     */
    private Integer baseSleepTimeMilliseconds = 1000;
    /**
     * zookeeper等待重试的间隔时间的最大值 默认3000，单位：毫秒
     */
    private Integer maxSleepTimeMilliseconds = 3000;
    /**
     * zookeeper最大重试次数 默认3
     */
    private Integer maxRetries = 3;
    /**
     * 会话超时时间 默认60000，单位：毫秒
     */
    private Integer sessionTimeoutMilliseconds = 6000;
    /**
     * 连接超时时间 默认15000，单位：毫秒
     */
    private Integer connectionTimeoutMilliseconds = 15000;
    /**
     * 连接Zookeeper的权限令牌.
     * 缺省为不需要权限验证.
     */
    private String digest;

}
