/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.typehandler;

import com.rabbit.core.enumation.IEnum;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class StringEnumTypeHandler<E extends Enum<?>>
extends BaseTypeHandler<IEnum> {
    private Class<E> clazz;

    public StringEnumTypeHandler() {
    }

    public StringEnumTypeHandler(Class<E> enumType) {
        if (enumType == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.clazz = enumType;
    }

    public void setNonNullParameter(PreparedStatement preparedStatement, int i, IEnum iEnum, JdbcType jdbcType) throws SQLException {
        preparedStatement.setString(i, (String)iEnum.getValue());
    }

    public IEnum getNullableResult(ResultSet resultSet, String s) throws SQLException {
        return (IEnum)this.convert(this.clazz, resultSet.getString(s));
    }

    public IEnum getNullableResult(ResultSet resultSet, int i) throws SQLException {
        return (IEnum)this.convert(this.clazz, resultSet.getString(i));
    }

    public IEnum getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        return (IEnum)this.convert(this.clazz, callableStatement.getString(i));
    }

    private <T extends Enum<?>> T convert(Class<T> enumClass, String value) {
        Enum[] enumConstants;
        for (Enum t : enumConstants = (Enum[])enumClass.getEnumConstants()) {
            if (!((IEnum)((Object)t)).getValue().toString().equals(value)) continue;
            return (T)t;
        }
        return null;
    }
}

