/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.typehandler;

import com.rabbit.core.enumation.IEnum;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class IEnumTypeHandler<E extends Enum<?>>
extends BaseTypeHandler<IEnum> {
    private Class<E> clazz;

    public IEnumTypeHandler() {
    }

    public IEnumTypeHandler(Class<E> enumType) {
        if (enumType == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.clazz = enumType;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, IEnum parameter, JdbcType jdbcType) throws SQLException {
        ps.setInt(i, (Integer)parameter.getValue());
    }

    public IEnum getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return (IEnum)this.convert(this.clazz, rs.getInt(columnName));
    }

    public IEnum getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return (IEnum)this.convert(this.clazz, rs.getInt(columnIndex));
    }

    public IEnum getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return (IEnum)this.convert(this.clazz, cs.getInt(columnIndex));
    }

    private <T extends Enum<?>> T convert(Class<T> enumClass, int value) {
        Enum[] enumConstants;
        for (Enum t : enumConstants = (Enum[])enumClass.getEnumConstants()) {
            if ((Integer)((IEnum)((Object)t)).getValue() != value) continue;
            return (T)t;
        }
        return null;
    }
}

