/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.json.JSONUtil;
import com.rabbit.common.exception.MyBatisRabbitPlugException;
import com.rabbit.common.utils.ArrayUtils;
import com.rabbit.common.utils.CollectionUtils;
import com.rabbit.common.utils.StringUtils;
import com.rabbit.core.annotation.Create;
import com.rabbit.core.annotation.Delete;
import com.rabbit.core.annotation.FillingStrategy;
import com.rabbit.core.annotation.Id;
import com.rabbit.core.annotation.Update;
import com.rabbit.core.bean.TableFieldInfo;
import com.rabbit.core.bean.TableInfo;
import com.rabbit.core.constructor.BaseAbstractWrapper;
import com.rabbit.core.constructor.DeleteWrapper;
import com.rabbit.core.constructor.InsertWrapper;
import com.rabbit.core.constructor.QueryWrapper;
import com.rabbit.core.constructor.UpdateWrapper;
import com.rabbit.core.enumation.MySqlKeyWord;
import com.rabbit.core.enumation.PrimaryKey;
import com.rabbit.core.enumation.SqlKey;
import com.rabbit.core.mapper.BaseMapper;
import com.rabbit.core.parse.ParseClass2TableInfo;
import com.rabbit.core.service.BaseService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class BaseServiceImpl<Mapper extends BaseMapper>
extends BaseAbstractWrapper
implements BaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseServiceImpl.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private Mapper baseMapper;

    @Override
    public <T> T queryObject(QueryWrapper queryWrapper, Class<T> clazz) {
        if (Objects.isNull(clazz)) {
            throw new MyBatisRabbitPlugException("queryObject -> clazz is null......");
        }
        this.copyQueryWrapper(queryWrapper, clazz);
        Map<String, Object> sqlMap = queryWrapper.mergeSqlMap();
        HashMap<String, Object> queryValMap = new HashMap<String, Object>(16);
        queryValMap.put("valMap", sqlMap.get("VALUE"));
        Map<String, Object> objMap = this.baseMapper.getObject(sqlMap, queryValMap);
        if (CollectionUtils.isEmpty(objMap)) {
            return null;
        }
        TableInfo tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(clazz);
        this.convertEnumVal(tableInfo.getColumnMap(), Arrays.asList(objMap));
        Object bean = BeanUtil.mapToBean(objMap, clazz, (boolean)true);
        return (T)bean;
    }

    @Override
    public <T> List<T> queryObjectList(QueryWrapper queryWrapper, Class<T> clazz) {
        if (Objects.isNull(clazz)) {
            throw new MyBatisRabbitPlugException("queryObjectList -> clazz is null......");
        }
        this.copyQueryWrapper(queryWrapper, clazz);
        Map<String, Object> sqlMap = queryWrapper.mergeSqlMap();
        HashMap<String, Object> queryValMap = new HashMap<String, Object>(16);
        queryValMap.put("valMap", sqlMap.get("VALUE"));
        List<Map<String, Object>> objMapList = this.baseMapper.getObjectList(sqlMap, queryValMap);
        if (CollectionUtils.isEmpty(objMapList)) {
            return Collections.emptyList();
        }
        ArrayList<Object> beanList = new ArrayList<Object>();
        TableInfo tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(clazz);
        this.convertEnumVal(tableInfo.getColumnMap(), objMapList);
        for (Map<String, Object> item : objMapList) {
            Object bean = BeanUtil.mapToBean(item, clazz, (boolean)true);
            if (Objects.isNull(bean)) continue;
            beanList.add(bean);
        }
        return beanList;
    }

    @Override
    public <T> T queryObjectById(Object id, Class<T> clazz) {
        if (Objects.isNull(clazz)) {
            throw new MyBatisRabbitPlugException("queryObjectById -> clazz is null......");
        }
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        QueryWrapper<Object> queryWrapper = new QueryWrapper<Object>(obj);
        TableInfo tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(clazz);
        Field pkField = tableInfo.getPrimaryKey();
        TableFieldInfo tableFieldInfo = tableInfo.getColumnMap().get(pkField.getName());
        queryWrapper.where(tableFieldInfo.getColumnName(), id, new String[0]);
        Map<String, Object> sqlMap = queryWrapper.mergeSqlMap();
        HashMap<String, Object> queryValMap = new HashMap<String, Object>(16);
        queryValMap.put("valMap", sqlMap.get("VALUE"));
        Map<String, Object> objMap = this.baseMapper.getObject(sqlMap, queryValMap);
        if (CollectionUtils.isEmpty(objMap)) {
            return null;
        }
        this.convertEnumVal(tableInfo.getColumnMap(), Arrays.asList(objMap));
        if (CollectionUtils.isEmpty(objMap)) {
            return null;
        }
        Object bean = BeanUtil.mapToBean(objMap, clazz, (boolean)true);
        return (T)bean;
    }

    @Override
    public List<Map<String, Object>> queryCustomSql(String sql) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sql)) {
            throw new MyBatisRabbitPlugException("queryCustomSql -> sql is null......");
        }
        List<Map<String, Object>> objMapList = this.baseMapper.customSqlObject(sql);
        if (CollectionUtils.isEmpty(objMapList)) {
            return Collections.emptyList();
        }
        return objMapList;
    }

    @Override
    public Long deleteObject(Object objectId, Class<?> clazz) {
        if (Objects.isNull(objectId)) {
            throw new MyBatisRabbitPlugException("\u4e3b\u952eId\u4e3a\u7a7a......");
        }
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DeleteWrapper<Object> deleteWrapper = new DeleteWrapper<Object>(obj);
        TableInfo tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(obj.getClass());
        if (Objects.isNull(tableInfo.getPrimaryKey())) {
            throw new MyBatisRabbitPlugException("\u672a\u6307\u5b9a\u4e3b\u952e\u5b57\u6bb5...");
        }
        Map<String, String> sqlMap = deleteWrapper.sqlGenerate();
        Long logicDelResult = this.logicDel(clazz, Arrays.asList(objectId));
        if (!Objects.isNull(logicDelResult)) {
            return logicDelResult;
        }
        LOGGER.info(" ");
        LOGGER.info("{}: begin delete data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info("{}: sqlMap ==>{}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr(sqlMap));
        LOGGER.info("{}: objectId ==>{}", (Object)"Mybatis-Rabbit-Plug", objectId);
        long result = this.baseMapper.deleteObject(objectId, sqlMap);
        LOGGER.info("{}: end delete data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info(" ");
        return result;
    }

    @Override
    public Long deleteBatchByIdObject(List<Object> objectIdList, Class<?> clazz) {
        if (CollectionUtils.isEmpty(objectIdList)) {
            throw new MyBatisRabbitPlugException("\u4e3b\u952e\u96c6\u5408\u4e3a\u7a7a......");
        }
        long beginTime = System.currentTimeMillis();
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DeleteWrapper<Object> deleteWrapper = new DeleteWrapper<Object>(obj);
        TableInfo tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(obj.getClass());
        if (Objects.isNull(tableInfo.getPrimaryKey())) {
            throw new MyBatisRabbitPlugException("\u672a\u6307\u5b9a\u4e3b\u952e\u5b57\u6bb5...");
        }
        Map<String, String> sqlMap = deleteWrapper.sqlGenerate();
        String where = sqlMap.get(SqlKey.DELETE_WHERE.getValue());
        where = where.substring(0, where.indexOf("=")) + " " + MySqlKeyWord.IN.getValue();
        sqlMap.put(SqlKey.DELETE_WHERE.getValue(), where);
        Long logicDelResult = this.logicDel(clazz, objectIdList);
        if (!Objects.isNull(logicDelResult)) {
            return logicDelResult;
        }
        LOGGER.info(" ");
        LOGGER.info("{}: begin deleteBatch data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info("{}: sqlMap ==>{}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr(sqlMap));
        LOGGER.info("{}: objectIdList ==>{}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr(objectIdList));
        long result = 0L;
        result = this.batchExecute(objectIdList, sqlMap, null, Delete.class);
        long endTime = System.currentTimeMillis();
        LOGGER.info("{}: success total: {}", (Object)"Mybatis-Rabbit-Plug", (Object)result);
        LOGGER.info("{}: \u672c\u6b21\u6279\u91cf\u5220\u9664\u5171\u8017\u65f6: {}s", (Object)"Mybatis-Rabbit-Plug", (Object)Float.valueOf((float)(endTime - beginTime) / 1000.0f));
        LOGGER.info("{}: end deleteBatch data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info(" ");
        return result;
    }

    @Override
    public <E> Long updateObject(E object, UpdateWrapper updateWrapper) {
        if (Objects.isNull(object)) {
            throw new MyBatisRabbitPlugException("\u8981\u4fee\u6539\u7684bean\u4e3a\u7a7a......");
        }
        Map beanMap = BeanUtil.beanToMap(object);
        UpdateWrapper<E> updateSqlGenerate = new UpdateWrapper<E>(object);
        TableInfo tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(object.getClass());
        Map<String, Object> mergeSqlMap = null;
        mergeSqlMap = !Objects.isNull(updateWrapper) ? updateWrapper.mergeSqlMap() : updateSqlGenerate.mergeSqlMap();
        Map<String, Object> sqlMap = updateSqlGenerate.sqlGenerate(mergeSqlMap);
        try {
            this.setFillingStrategyContent(beanMap, object, Update.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.info(" ");
        LOGGER.info("{}: begin update data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info("{}: sqlMap ==>{}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr(sqlMap));
        LOGGER.info("{}: beanMap ==>{}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr((Object)beanMap));
        long result = this.baseMapper.updateObject(beanMap, sqlMap);
        LOGGER.info("{}: end update data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info(" ");
        return result;
    }

    @Override
    public <E> Long updateBatchByIdObject(List<E> objectList) {
        if (CollectionUtils.isEmpty(objectList)) {
            throw new MyBatisRabbitPlugException("\u4fee\u6539\u5b9e\u4f8b\u96c6\u5408\u4e3a\u7a7a......");
        }
        long beginTime = System.currentTimeMillis();
        UpdateWrapper<E> updateWrapper = new UpdateWrapper<E>(objectList.get(0));
        TableInfo tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(objectList.get(0).getClass());
        if (Objects.isNull(tableInfo.getPrimaryKey())) {
            throw new MyBatisRabbitPlugException("\u672a\u6307\u5b9a\u4e3b\u952e\u5b57\u6bb5...");
        }
        List objMapList = objectList.stream().map(x -> BeanUtil.beanToMap((Object)x)).collect(Collectors.toList());
        Map<String, Object> sqlMap = updateWrapper.sqlGenerate(null);
        String where = sqlMap.get(SqlKey.UPDATE_WHERE.getValue()).toString();
        where = where.replace("objectMap", "obj");
        sqlMap.put(SqlKey.UPDATE_WHERE.getValue(), where);
        Map paramterMap = (Map)sqlMap.get(SqlKey.UPDATE_VALUE.getValue());
        for (String item : paramterMap.keySet()) {
            paramterMap.put(item, ((String)paramterMap.get(item)).replace("objectMap", "obj"));
        }
        try {
            for (int i = 0; i < objectList.size(); ++i) {
                this.setFillingStrategyContent((Map)objMapList.get(i), objectList.get(i), Update.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.info(" ");
        LOGGER.info("{}: begin updateBatch data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info("{}: sqlMap ==>{}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr(sqlMap));
        LOGGER.info("{}: objMap ==>{}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr(objMapList));
        long result = 0L;
        result = this.batchExecute(objMapList, null, sqlMap, Update.class);
        long endTime = System.currentTimeMillis();
        LOGGER.info("{}: success total: {}", (Object)"Mybatis-Rabbit-Plug", (Object)result);
        LOGGER.info("{}: \u672c\u6b21\u6279\u91cf\u4fee\u6539\u5171\u8017\u65f6: {}s", (Object)"Mybatis-Rabbit-Plug", (Object)Float.valueOf((float)(endTime - beginTime) / 1000.0f));
        LOGGER.info("{}: end updateBatch data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info(" ");
        return result;
    }

    @Override
    public String addObject(Object obj) {
        if (Objects.isNull(obj)) {
            throw new MyBatisRabbitPlugException("bean\u4e3a\u7a7a......");
        }
        String pk = null;
        InsertWrapper<Object> insertWrapper = new InsertWrapper<Object>(obj);
        Map<String, String> sqlMap = insertWrapper.sqlGenerate();
        TableInfo tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(obj.getClass());
        Field primaryKey = tableInfo.getPrimaryKey();
        if (Objects.isNull(primaryKey)) {
            throw new MyBatisRabbitPlugException("\u89e3\u6790\u65f6\u672a\u83b7\u53d6\u5230\u4e3b\u952e\u5b57\u6bb5......");
        }
        Map beanMap = BeanUtil.beanToMap((Object)obj);
        Id id = primaryKey.getAnnotation(Id.class);
        PrimaryKey pkEnum = id.generateType();
        if (id.isIncrementColumn()) {
            beanMap.put("tempPrimKey", "");
        }
        if (MapUtil.isEmpty((Map)beanMap)) {
            throw new MyBatisRabbitPlugException("beanMap\u8f6c\u6362\u5931\u8d25......");
        }
        if (beanMap.containsKey(primaryKey.getName()) && !id.isIncrementColumn()) {
            if (Objects.isNull(beanMap.get(primaryKey.getName()))) {
                switch (pkEnum) {
                    case UUID32: {
                        beanMap.put(primaryKey.getName(), IdUtil.simpleUUID());
                        break;
                    }
                    case OBJECTID: {
                        beanMap.put(primaryKey.getName(), IdUtil.objectId());
                        break;
                    }
                    case SNOWFLAKE: {
                        Snowflake snowflake = IdUtil.getSnowflake((long)id.workerId(), (long)id.datacenterId());
                        beanMap.put(primaryKey.getName(), snowflake.nextId());
                        break;
                    }
                }
                pk = beanMap.get(primaryKey.getName()).toString();
            } else {
                pk = beanMap.get(primaryKey.getName()).toString();
            }
        } else {
            pk = "default-tab-pk";
        }
        try {
            this.setFillingStrategyContent(beanMap, obj, Create.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.info(" ");
        LOGGER.info("{}: begin add data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info("{}: sqlMap ==>{}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr(sqlMap));
        LOGGER.info("{}: beanMap ==>{}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr((Object)beanMap));
        this.baseMapper.addObject(beanMap, sqlMap);
        LOGGER.info("{}: end add data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info(" ");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"default-tab-pk", (CharSequence)pk)) {
            pk = beanMap.get("tempPrimKey").toString();
        }
        return pk;
    }

    @Override
    public <E> Long addBatchObject(List<E> objectList) {
        if (CollectionUtils.isEmpty(objectList)) {
            throw new MyBatisRabbitPlugException("\u65b0\u589e\u5b9e\u4f8b\u96c6\u5408\u4e3a\u7a7a......");
        }
        long beginTime = System.currentTimeMillis();
        InsertWrapper<E> insertWrapper = new InsertWrapper<E>(objectList.get(0));
        Map<String, String> sqlMap = insertWrapper.sqlGenerate();
        TableInfo tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(objectList.get(0).getClass());
        Field primaryKey = tableInfo.getPrimaryKey();
        if (Objects.isNull(primaryKey)) {
            throw new MyBatisRabbitPlugException("\u89e3\u6790\u65f6\u672a\u83b7\u53d6\u5230\u4e3b\u952e\u5b57\u6bb5......");
        }
        Id id = primaryKey.getAnnotation(Id.class);
        PrimaryKey pkEnum = id.generateType();
        List objMap = objectList.stream().map(x -> BeanUtil.beanToMap((Object)x)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(objMap)) {
            throw new MyBatisRabbitPlugException("beanMap\u8f6c\u6362\u5931\u8d25......");
        }
        for (Map item : objMap) {
            if (!Objects.isNull(item.get(primaryKey.getName())) || id.isIncrementColumn()) continue;
            switch (pkEnum) {
                case UUID32: {
                    item.put(primaryKey.getName(), IdUtil.simpleUUID());
                    break;
                }
                case OBJECTID: {
                    item.put(primaryKey.getName(), IdUtil.objectId());
                    break;
                }
                case SNOWFLAKE: {
                    Snowflake snowflake = IdUtil.getSnowflake((long)id.workerId(), (long)id.datacenterId());
                    item.put(primaryKey.getName(), snowflake.nextId());
                    break;
                }
            }
        }
        for (int i = 0; i < objectList.size(); ++i) {
            try {
                this.setFillingStrategyContent((Map)objMap.get(i), objectList.get(i), Create.class);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LOGGER.info(" ");
        LOGGER.info("{}: begin addBatch data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info("{}: sqlMap ==>{}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr(sqlMap));
        LOGGER.info("{}: objMap ==>{}", (Object)"Mybatis-Rabbit-Plug", (Object)JSONUtil.toJsonStr(objMap));
        long result = 0L;
        result = this.batchExecute(objMap, sqlMap, null, Create.class);
        long endTime = System.currentTimeMillis();
        LOGGER.info("{}: success total: {}", (Object)"Mybatis-Rabbit-Plug", (Object)result);
        LOGGER.info("{}: \u672c\u6b21\u6279\u91cf\u65b0\u589e\u5171\u8017\u65f6: {}s", (Object)"Mybatis-Rabbit-Plug", (Object)Float.valueOf((float)(endTime - beginTime) / 1000.0f));
        LOGGER.info("{}: end addBatch data...", (Object)"Mybatis-Rabbit-Plug");
        LOGGER.info(" ");
        return result;
    }

    @Deprecated
    private Class<?> getFillingStrategyClass() {
        List<String> classNameList = Arrays.asList(this.applicationContext.getBeanDefinitionNames());
        for (String item : classNameList) {
            Object obj = this.applicationContext.getBean(item);
            if (!obj.getClass().isAnnotationPresent(FillingStrategy.class)) continue;
            return obj.getClass();
        }
        return null;
    }

    private void setFillingStrategyContent(Map<String, Object> beanMap, Object obj, Class<? extends Annotation> methodType) throws Exception {
        Map<Class<? extends Annotation>, Method> fillMethodMap;
        Method fillMethod;
        TableInfo tableInfo = ParseClass2TableInfo.parseClazzToTableInfo(obj.getClass());
        if (Objects.nonNull(tableInfo) && Objects.nonNull(fillMethod = (fillMethodMap = tableInfo.getFillMethods()).get(methodType))) {
            fillMethod.invoke(obj, new Object[0]);
            Map parseObj = BeanUtil.beanToMap((Object)obj);
            for (String key : parseObj.keySet()) {
                if (!beanMap.containsKey(key) || !Objects.isNull(beanMap.get(key)) || !Objects.nonNull(parseObj.get(key))) continue;
                beanMap.put(key, parseObj.get(key));
            }
        }
    }

    private void copyQueryWrapper(QueryWrapper source, Class<?> clazz) {
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        QueryWrapper<Object> query = new QueryWrapper<Object>(obj);
        source.getSqlMap().put(SqlKey.TABLE_NAME.getValue(), query.getTableInfo().getTableName());
    }

    private void convertEnumVal(Map<String, TableFieldInfo> fieldInfoMap, List<Map<String, Object>> objMapList) {
        HashMap<String, TableFieldInfo> enumPropertyMap = new HashMap<String, TableFieldInfo>(16);
        for (Map.Entry<String, TableFieldInfo> entry : fieldInfoMap.entrySet()) {
            Class<?> clazz = entry.getValue().getPropertyType();
            if (!clazz.isEnum()) continue;
            enumPropertyMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, TableFieldInfo> entry : enumPropertyMap.entrySet()) {
            Class<?> enumClass = entry.getValue().getPropertyType();
            try {
                Class<?> parameterClass = this.extractModelClass(enumClass);
                Method method = enumClass.getMethod("convert", parameterClass);
                for (Map<String, Object> objMap : objMapList) {
                    String enumName;
                    Object parameter = objMap.get(entry.getValue().getColumnName());
                    if (Objects.isNull(parameter)) continue;
                    Enum iEnum = (Enum)method.invoke(null, parameter);
                    String string = enumName = iEnum == null ? "" : iEnum.name();
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)enumName)) {
                        objMap.put(entry.getValue().getColumnName(), enumName);
                        continue;
                    }
                    objMap.put(entry.getValue().getColumnName(), null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Long logicDel(Class<?> beanClass, List<Object> objectIdList) {
        boolean physicsDel;
        Delete delete = null;
        String delField = "";
        Object obj = null;
        Map<String, TableFieldInfo> tableFieldInfoMap = null;
        TableInfo tableInfo = ParseClass2TableInfo.getTableInfo(beanClass);
        if (Objects.nonNull(tableInfo)) {
            tableFieldInfoMap = tableInfo.getColumnMap();
            for (Map.Entry<String, TableFieldInfo> item : tableFieldInfoMap.entrySet()) {
                if (!item.getValue().getField().isAnnotationPresent(Delete.class)) continue;
                delete = item.getValue().getField().getAnnotation(Delete.class);
                delField = item.getValue().getField().getName();
                break;
            }
        }
        if (Objects.nonNull(delete) && !(physicsDel = delete.physicsDel())) {
            TableFieldInfo tbField = tableInfo.getColumnMap().get(tableInfo.getPrimaryKey().getName());
            int value = delete.value();
            ArrayList<Object> objBeanList = new ArrayList<Object>();
            for (Object id : objectIdList) {
                try {
                    obj = beanClass.newInstance();
                    Method pkMethod = beanClass.getMethod("set" + StringUtils.capitalize((String)tbField.getPropertyName()), tbField.getPropertyType());
                    pkMethod.invoke(obj, id);
                    Method delMethod = beanClass.getMethod("set" + StringUtils.capitalize((String)delField), Integer.class);
                    delMethod.invoke(obj, value);
                    objBeanList.add(obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.updateBatchByIdObject(objBeanList);
        }
        return null;
    }

    private <T> long batchExecute(List<T> list, Map<String, String> sqlMap, Map<String, Object> upSqlMap, Class<? extends Annotation> methodType) {
        if (CollectionUtils.isEmpty(list)) {
            throw new MyBatisRabbitPlugException(" target list is null......");
        }
        long result = 0L;
        if (list.size() > 500) {
            int currentBatch = 1;
            int total = list.size();
            int batch = total % 500 == 0 ? total / 500 : total / 500 + 1;
            int limit = (currentBatch - 1) * 500;
            List<Object> tempList = new LinkedList();
            for (int x = 1; x <= batch; ++x) {
                tempList = limit + 500 > total ? list.subList(limit, list.size()) : list.subList(limit, x * 500);
                if (Objects.equals(methodType, Create.class)) {
                    result += this.baseMapper.addBatchObject(tempList, sqlMap).longValue();
                } else if (Objects.equals(methodType, Update.class)) {
                    result += this.baseMapper.updateBatchByIdObject(tempList, upSqlMap).longValue();
                } else if (Objects.equals(methodType, Delete.class)) {
                    result += this.baseMapper.deleteBatchByIdObject(tempList, sqlMap).longValue();
                }
                limit = (++currentBatch - 1) * 500;
            }
        } else if (Objects.equals(methodType, Create.class)) {
            result = this.baseMapper.addBatchObject(list, sqlMap);
        } else if (Objects.equals(methodType, Update.class)) {
            result = this.baseMapper.updateBatchByIdObject(list, upSqlMap);
        } else if (Objects.equals(methodType, Delete.class)) {
            result = this.baseMapper.deleteBatchByIdObject(list, sqlMap);
        }
        return result;
    }

    private Class<?> extractModelClass(Class<?> clazz) {
        Type[] types = clazz.getGenericInterfaces();
        ParameterizedType target = null;
        for (Type type : types) {
            Object t;
            Object[] objectArray;
            int n;
            int n2;
            if (!(type instanceof ParameterizedType)) continue;
            Object[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            if (!ArrayUtils.isNotEmpty((Object[])typeArray) || (n2 = 0) >= (n = (objectArray = typeArray).length) || (t = objectArray[n2]) instanceof TypeVariable || t instanceof WildcardType) break;
            target = (ParameterizedType)type;
            break;
        }
        return target == null ? null : (Class)target.getActualTypeArguments()[0];
    }
}

