/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.parse;

import com.rabbit.common.utils.ClassUtils;
import com.rabbit.common.utils.StringUtils;
import com.rabbit.core.annotation.Column;
import com.rabbit.core.annotation.Create;
import com.rabbit.core.annotation.Id;
import com.rabbit.core.annotation.Table;
import com.rabbit.core.annotation.Update;
import com.rabbit.core.bean.TableFieldInfo;
import com.rabbit.core.bean.TableInfo;
import com.rabbit.core.enumation.MySqlColumnType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Transient;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParseClass2TableInfo {
    private static final Logger logger = LoggerFactory.getLogger(ParseClass2TableInfo.class);
    protected static final String TAG = "Mybatis-Rabbit-Plug";
    private static final Map<Class<?>, TableInfo> TABLE_INFO_CACHE = new ConcurrentHashMap();

    private static void addTableInfoCache(Class<?> clazz, TableInfo tableInfo) {
        if (clazz != null && !Objects.isNull(tableInfo)) {
            TABLE_INFO_CACHE.put(ClassUtils.getUserClass(clazz), tableInfo);
        }
    }

    public static TableInfo getTableInfo(Class<?> clazz) {
        return TABLE_INFO_CACHE.get(ClassUtils.getUserClass(clazz));
    }

    public static Map<Class<?>, TableInfo> getAllTableInfo() {
        return TABLE_INFO_CACHE;
    }

    private static void removeTableInfoCache(Class<?> clazz) {
        TABLE_INFO_CACHE.remove(ClassUtils.getUserClass(clazz));
    }

    private static void clearTableInfoCache() {
        TABLE_INFO_CACHE.clear();
    }

    public static TableInfo parseClazzToTableInfo(Class<?> clazz) {
        String tableName;
        TableInfo tableInfo = ParseClass2TableInfo.getTableInfo(clazz);
        if (tableInfo != null) {
            return tableInfo;
        }
        HashMap<String, TableFieldInfo> tbFieldMap = new HashMap<String, TableFieldInfo>();
        logger.info("{} - start parse tableInfo ......", (Object)TAG);
        tableInfo = new TableInfo();
        if (clazz.isAnnotationPresent(Table.class)) {
            Table table = clazz.getAnnotation(Table.class);
            tableName = table.value();
        } else {
            String className = clazz.getSimpleName();
            tableName = StringUtils.camelToUnderline((String)StringUtils.firstToLowerCase((String)className));
        }
        tableInfo.setTableName(tableName);
        logger.info("{} - parse result db.tableName ==> {}", (Object)TAG, (Object)tableName);
        List<Field> fieldList = ParseClass2TableInfo.getClassFields(clazz);
        for (Field item : fieldList) {
            if (item.isAnnotationPresent(Transient.class)) continue;
            TableFieldInfo tbField = new TableFieldInfo();
            String columnName = "";
            String propertyName = "";
            if (!item.isAnnotationPresent(Column.class) && !item.isAnnotationPresent(Id.class)) {
                propertyName = item.getName();
                columnName = StringUtils.camelToUnderline((String)propertyName);
                tbField.setJdbcType(ParseClass2TableInfo.getColumnType(item.getGenericType()));
                tbField.setField(item);
                tbField.setColumnName(columnName);
                tbField.setPropertyName(propertyName);
                Class<?> clazzFieldType = item.getType();
                tbField.setPropertyType(clazzFieldType);
                tbFieldMap.put(propertyName, tbField);
                continue;
            }
            Column column = item.getAnnotation(Column.class);
            Id id = item.getAnnotation(Id.class);
            if (!Objects.isNull(column)) {
                if (!column.isTableColumn()) continue;
                columnName = column.value();
                tbField.setJdbcType(column.jdbcType());
                if (MySqlColumnType.VARCHAR.equals(column.jdbcType())) {
                    tbField.setJdbcType(ParseClass2TableInfo.getColumnType(item.getGenericType()));
                }
                tbField.setTypeHandler(column.typeHandler());
            } else if (!Objects.isNull(id)) {
                columnName = id.value();
                tableInfo.setPrimaryKey(item);
                tbField.setJdbcType(id.jdbcType());
                if (MySqlColumnType.VARCHAR.equals(id.jdbcType())) {
                    tbField.setJdbcType(ParseClass2TableInfo.getColumnType(item.getGenericType()));
                }
            }
            HashMap<Class<? extends Annotation>, Method> fillMap = new HashMap<Class<? extends Annotation>, Method>();
            List<Method> classMethods = ParseClass2TableInfo.getClassMethods(clazz);
            classMethods.stream().filter(method -> ObjectUtils.isNotEmpty((Object)method.getAnnotation(Create.class))).findFirst().ifPresent(method -> fillMap.computeIfAbsent(Create.class, key -> method));
            classMethods.stream().filter(method -> ObjectUtils.isNotEmpty((Object)method.getAnnotation(Update.class))).findFirst().ifPresent(method -> fillMap.computeIfAbsent(Update.class, key -> method));
            tableInfo.setFillMethods(fillMap);
            if (StringUtils.isBlank((CharSequence)columnName)) {
                propertyName = item.getName();
                columnName = StringUtils.camelToUnderline((String)propertyName);
            }
            tbField.setField(item);
            tbField.setColumnName(columnName);
            tbField.setPropertyName(propertyName);
            Class<?> clazzFieldType = item.getType();
            tbField.setPropertyType(clazzFieldType);
            tbFieldMap.put(propertyName, tbField);
        }
        logger.info("{} - complete parse tableInfo ......", (Object)TAG);
        tableInfo.setColumnMap(tbFieldMap);
        ParseClass2TableInfo.addTableInfoCache(ClassUtils.getUserClass(clazz), tableInfo);
        return tableInfo;
    }

    private static List<Method> getClassMethods(Class parameterType) {
        ArrayList<Method> methodList = new ArrayList<Method>(Arrays.asList(parameterType.getDeclaredMethods()));
        if (ObjectUtils.isEmpty(parameterType.getSuperclass())) {
            return methodList;
        }
        methodList.addAll(ParseClass2TableInfo.getClassMethods(parameterType.getSuperclass()));
        return methodList;
    }

    private static List<Field> getClassFields(Class parameterType) {
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(parameterType.getDeclaredFields()));
        if (ObjectUtils.isEmpty(parameterType.getSuperclass())) {
            return fieldList;
        }
        fieldList.addAll(ParseClass2TableInfo.getClassFields(parameterType.getSuperclass()));
        return fieldList;
    }

    public static MySqlColumnType getColumnType(Type type) {
        Class clazz = null;
        if (type instanceof Class) {
            clazz = (Class)type;
            if (Integer.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.INTEGER;
            }
            if (String.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.VARCHAR;
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.DOUBLE;
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.FLOAT;
            }
            if (BigDecimal.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.DECIMAL;
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.DATE;
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.BIGINT;
            }
            if (Boolean.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.TINYINT;
            }
            if (Short.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.SHORT;
            }
            if (Character.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.CHAR;
            }
            if (LocalDate.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.DATE;
            }
            if (LocalDateTime.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.TIMESTAMP;
            }
            if (Timestamp.class.isAssignableFrom(clazz)) {
                return MySqlColumnType.TIMESTAMP;
            }
        }
        return MySqlColumnType.TINYINT;
    }
}

