/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.module;

import com.rabbit.core.module.RabbitConfiguration;
import com.rabbit.core.module.RabbitXMLConfigBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class RabbitMybatisSqlSessionFactoryBuilder
extends SqlSessionFactoryBuilder {
    public SqlSessionFactory build(Reader reader, String environment, Properties properties) {
        SqlSessionFactory factory;
        try {
            RabbitXMLConfigBuilder parser = new RabbitXMLConfigBuilder(reader, environment, properties);
            factory = this.build(parser.parse());
        }
        catch (Exception var14) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)var14);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return factory;
    }

    public SqlSessionFactory build(InputStream inputStream, String environment, Properties properties) {
        SqlSessionFactory factory;
        try {
            RabbitXMLConfigBuilder parser = new RabbitXMLConfigBuilder(inputStream, environment, properties);
            factory = this.build(parser.parse());
        }
        catch (Exception var14) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)var14);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return factory;
    }

    public SqlSessionFactory build(Configuration config) {
        RabbitConfiguration configuration = (RabbitConfiguration)config;
        SqlSessionFactory factory = super.build((Configuration)configuration);
        return factory;
    }
}

