/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.module;

import com.rabbit.core.module.RabbitConfiguration;
import com.rabbit.core.util.RabbitConfigUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.CacheNamespace;
import org.apache.ibatis.annotations.CacheNamespaceRef;
import org.apache.ibatis.annotations.Case;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Lang;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Property;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.TypeDiscriminator;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.CacheRefResolver;
import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.annotation.MapperAnnotationBuilder;
import org.apache.ibatis.builder.annotation.MethodResolver;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.FetchType;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.parsing.PropertyParser;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.UnknownTypeHandler;

public class RabbitMapperAnnotationBuilder
extends MapperAnnotationBuilder {
    private static final Set<Class<? extends Annotation>> SQL_ANNOTATION_TYPES = new HashSet<Class<? extends Annotation>>();
    private static final Set<Class<? extends Annotation>> SQL_PROVIDER_ANNOTATION_TYPES = new HashSet<Class<? extends Annotation>>();
    private final RabbitConfiguration configuration;
    private final MapperBuilderAssistant assistant;
    private final Class<?> type;

    public RabbitMapperAnnotationBuilder(RabbitConfiguration configuration, Class<?> type) {
        super((Configuration)configuration, type);
        String resource = type.getName().replace('.', '/') + ".java (best guess)";
        this.assistant = new MapperBuilderAssistant((Configuration)configuration, resource);
        this.configuration = configuration;
        this.type = type;
    }

    public void parse() {
        String resource = this.type.toString();
        if (!this.configuration.isResourceLoaded(resource)) {
            Method[] methods;
            this.loadXmlResource();
            this.configuration.addLoadedResource(resource);
            String typeName = this.type.getName();
            this.assistant.setCurrentNamespace(typeName);
            this.parseCache();
            this.parseCacheRef();
            Method[] var4 = methods = this.type.getMethods();
            int var5 = methods.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                Method method = var4[var6];
                try {
                    if (method.isBridge()) continue;
                    this.parseStatement(method);
                    continue;
                }
                catch (IncompleteElementException var9) {
                    this.configuration.addIncompleteMethod(new MethodResolver((MapperAnnotationBuilder)this, method));
                }
            }
            if (RabbitConfigUtils.isSupperMapperChildren(this.configuration, this.type)) {
                RabbitConfigUtils.getSqlInjector(this.configuration).inspectInject(this.assistant, this.type);
            }
        }
        this.parsePendingMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePendingMethods() {
        Collection incompleteMethods;
        Collection collection = incompleteMethods = this.configuration.getIncompleteMethods();
        synchronized (collection) {
            Iterator iter = incompleteMethods.iterator();
            while (iter.hasNext()) {
                try {
                    ((MethodResolver)iter.next()).resolve();
                    iter.remove();
                }
                catch (IncompleteElementException incompleteElementException) {}
            }
        }
    }

    private void loadXmlResource() {
        if (!this.configuration.isResourceLoaded("namespace:" + this.type.getName())) {
            String xmlResource = this.type.getName().replace('.', '/') + ".xml";
            InputStream inputStream = this.type.getResourceAsStream("/" + xmlResource);
            if (inputStream == null) {
                try {
                    inputStream = Resources.getResourceAsStream((ClassLoader)this.type.getClassLoader(), (String)xmlResource);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                XMLMapperBuilder xmlParser = new XMLMapperBuilder(inputStream, this.assistant.getConfiguration(), xmlResource, this.configuration.getSqlFragments(), this.type.getName());
                xmlParser.parse();
            }
        }
    }

    private void parseCache() {
        CacheNamespace cacheDomain = this.type.getAnnotation(CacheNamespace.class);
        if (cacheDomain != null) {
            Integer size = cacheDomain.size() == 0 ? null : Integer.valueOf(cacheDomain.size());
            Long flushInterval = cacheDomain.flushInterval() == 0L ? null : Long.valueOf(cacheDomain.flushInterval());
            Properties props = this.convertToProperties(cacheDomain.properties());
            this.assistant.useNewCache(cacheDomain.implementation(), cacheDomain.eviction(), flushInterval, size, cacheDomain.readWrite(), cacheDomain.blocking(), props);
        }
    }

    private Properties convertToProperties(Property[] properties) {
        if (properties.length == 0) {
            return null;
        }
        Properties props = new Properties();
        Property[] var3 = properties;
        int var4 = properties.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            Property property = var3[var5];
            props.setProperty(property.name(), PropertyParser.parse((String)property.value(), (Properties)this.configuration.getVariables()));
        }
        return props;
    }

    private void parseCacheRef() {
        CacheNamespaceRef cacheDomainRef = this.type.getAnnotation(CacheNamespaceRef.class);
        if (cacheDomainRef != null) {
            Class refType = cacheDomainRef.value();
            String refName = cacheDomainRef.name();
            if (refType == Void.TYPE && refName.isEmpty()) {
                throw new BuilderException("Should be specified either value() or name() attribute in the @CacheNamespaceRef");
            }
            if (refType != Void.TYPE && !refName.isEmpty()) {
                throw new BuilderException("Cannot use both value() and name() attribute in the @CacheNamespaceRef");
            }
            String namespace = refType != Void.TYPE ? refType.getName() : refName;
            try {
                this.assistant.useCacheRef(namespace);
            }
            catch (IncompleteElementException var6) {
                this.configuration.addIncompleteCacheRef(new CacheRefResolver(this.assistant, namespace));
            }
        }
    }

    private String parseResultMap(Method method) {
        Class<?> returnType = this.getReturnType(method);
        ConstructorArgs args = method.getAnnotation(ConstructorArgs.class);
        Results results = method.getAnnotation(Results.class);
        TypeDiscriminator typeDiscriminator = method.getAnnotation(TypeDiscriminator.class);
        String resultMapId = this.generateResultMapName(method);
        this.applyResultMap(resultMapId, returnType, this.argsIf(args), this.resultsIf(results), typeDiscriminator);
        return resultMapId;
    }

    private String generateResultMapName(Method method) {
        Results results = method.getAnnotation(Results.class);
        if (results != null && !results.id().isEmpty()) {
            return this.type.getName() + "." + results.id();
        }
        StringBuilder suffix = new StringBuilder();
        for (Class<?> c : method.getParameterTypes()) {
            suffix.append("-");
            suffix.append(c.getSimpleName());
        }
        if (suffix.length() < 1) {
            suffix.append("-void");
        }
        return this.type.getName() + "." + method.getName() + suffix;
    }

    private void applyResultMap(String resultMapId, Class<?> returnType, Arg[] args, Result[] results, TypeDiscriminator discriminator) {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        this.applyConstructorArgs(args, returnType, resultMappings);
        this.applyResults(results, returnType, resultMappings);
        Discriminator disc = this.applyDiscriminator(resultMapId, returnType, discriminator);
        this.assistant.addResultMap(resultMapId, returnType, (String)null, disc, resultMappings, (Boolean)null);
        this.createDiscriminatorResultMaps(resultMapId, returnType, discriminator);
    }

    private void createDiscriminatorResultMaps(String resultMapId, Class<?> resultType, TypeDiscriminator discriminator) {
        if (discriminator != null) {
            for (Case c : discriminator.cases()) {
                String caseResultMapId = resultMapId + "-" + c.value();
                ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
                this.applyConstructorArgs(c.constructArgs(), resultType, resultMappings);
                this.applyResults(c.results(), resultType, resultMappings);
                this.assistant.addResultMap(caseResultMapId, c.type(), resultMapId, (Discriminator)null, resultMappings, (Boolean)null);
            }
        }
    }

    private Discriminator applyDiscriminator(String resultMapId, Class<?> resultType, TypeDiscriminator discriminator) {
        if (discriminator == null) {
            return null;
        }
        String column = discriminator.column();
        Class javaType = discriminator.javaType() == Void.TYPE ? String.class : discriminator.javaType();
        JdbcType jdbcType = discriminator.jdbcType() == JdbcType.UNDEFINED ? null : discriminator.jdbcType();
        Class<UnknownTypeHandler> typeHandler = UnknownTypeHandler.class;
        Case[] cases = discriminator.cases();
        HashMap<String, String> discriminatorMap = new HashMap<String, String>();
        Case[] var10 = cases;
        int var11 = cases.length;
        for (int var12 = 0; var12 < var11; ++var12) {
            Case c = var10[var12];
            String value = c.value();
            String caseResultMapId = resultMapId + "-" + value;
            discriminatorMap.put(value, caseResultMapId);
        }
        return this.assistant.buildDiscriminator(resultType, column, javaType, jdbcType, typeHandler, discriminatorMap);
    }

    void parseStatement(Method method) {
        LanguageDriver languageDriver;
        Class<?> parameterTypeClass = this.getParameterType(method);
        SqlSource sqlSource = this.getSqlSourceFromAnnotations(method, parameterTypeClass, languageDriver = this.getLanguageDriver(method));
        if (sqlSource != null) {
            NoKeyGenerator keyGenerator;
            Options options = method.getAnnotation(Options.class);
            String mappedStatementId = this.type.getName() + "." + method.getName();
            Integer fetchSize = null;
            Integer timeout = null;
            StatementType statementType = StatementType.PREPARED;
            ResultSetType resultSetType = null;
            SqlCommandType sqlCommandType = this.getSqlCommandType(method);
            boolean isSelect = sqlCommandType == SqlCommandType.SELECT;
            boolean flushCache = !isSelect;
            boolean useCache = isSelect;
            String keyProperty = null;
            String keyColumn = null;
            if (!SqlCommandType.INSERT.equals((Object)sqlCommandType) && !SqlCommandType.UPDATE.equals((Object)sqlCommandType)) {
                keyGenerator = NoKeyGenerator.INSTANCE;
            } else {
                SelectKey selectKey = method.getAnnotation(SelectKey.class);
                if (selectKey != null) {
                    keyGenerator = this.handleSelectKeyAnnotation(selectKey, mappedStatementId, this.getParameterType(method), languageDriver);
                    keyProperty = selectKey.keyProperty();
                } else if (options == null) {
                    keyGenerator = this.configuration.isUseGeneratedKeys() ? Jdbc3KeyGenerator.INSTANCE : NoKeyGenerator.INSTANCE;
                } else {
                    keyGenerator = options.useGeneratedKeys() ? Jdbc3KeyGenerator.INSTANCE : NoKeyGenerator.INSTANCE;
                    keyProperty = options.keyProperty();
                    keyColumn = options.keyColumn();
                }
            }
            if (options != null) {
                if (Options.FlushCachePolicy.TRUE.equals((Object)options.flushCache())) {
                    flushCache = true;
                } else if (Options.FlushCachePolicy.FALSE.equals((Object)options.flushCache())) {
                    flushCache = false;
                }
                useCache = options.useCache();
                fetchSize = options.fetchSize() <= -1 && options.fetchSize() != Integer.MIN_VALUE ? null : Integer.valueOf(options.fetchSize());
                timeout = options.timeout() > -1 ? Integer.valueOf(options.timeout()) : null;
                statementType = options.statementType();
                resultSetType = options.resultSetType();
            }
            String resultMapId = null;
            ResultMap resultMapAnnotation = method.getAnnotation(ResultMap.class);
            if (resultMapAnnotation != null) {
                resultMapId = String.join((CharSequence)",", resultMapAnnotation.value());
            } else if (isSelect) {
                resultMapId = this.parseResultMap(method);
            }
            this.assistant.addMappedStatement(mappedStatementId, sqlSource, statementType, sqlCommandType, fetchSize, timeout, (String)null, parameterTypeClass, resultMapId, this.getReturnType(method), resultSetType, flushCache, useCache, false, (KeyGenerator)keyGenerator, keyProperty, keyColumn, (String)null, languageDriver, options != null ? this.nullOrEmpty(options.resultSets()) : null);
        }
    }

    private LanguageDriver getLanguageDriver(Method method) {
        Lang lang = method.getAnnotation(Lang.class);
        Class langClass = null;
        if (lang != null) {
            langClass = lang.value();
        }
        return this.configuration.getLanguageDriver(langClass);
    }

    private Class<?> getParameterType(Method method) {
        Class<?>[] parameterTypes;
        Class<Object> parameterType = null;
        Class<?>[] var4 = parameterTypes = method.getParameterTypes();
        int var5 = parameterTypes.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            Class<?> currentParameterType = var4[var6];
            if (RowBounds.class.isAssignableFrom(currentParameterType) || ResultHandler.class.isAssignableFrom(currentParameterType)) continue;
            parameterType = parameterType == null ? currentParameterType : MapperMethod.ParamMap.class;
        }
        return parameterType;
    }

    private Class<?> getReturnType(Method method) {
        Class returnType = method.getReturnType();
        Type resolvedReturnType = TypeParameterResolver.resolveReturnType((Method)method, this.type);
        if (resolvedReturnType instanceof Class) {
            ResultType rt;
            returnType = (Class)resolvedReturnType;
            if (returnType.isArray()) {
                returnType = returnType.getComponentType();
            }
            if (Void.TYPE.equals(returnType) && (rt = method.getAnnotation(ResultType.class)) != null) {
                returnType = rt.value();
            }
        } else if (resolvedReturnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)resolvedReturnType;
            Class rawType = (Class)parameterizedType.getRawType();
            if (!Collection.class.isAssignableFrom(rawType) && !Cursor.class.isAssignableFrom(rawType)) {
                Type[] actualTypeArguments;
                Type returnTypeParameter;
                if (method.isAnnotationPresent(MapKey.class) && Map.class.isAssignableFrom(rawType)) {
                    Type[] actualTypeArguments2 = parameterizedType.getActualTypeArguments();
                    if (actualTypeArguments2 != null && actualTypeArguments2.length == 2) {
                        Type returnTypeParameter2 = actualTypeArguments2[1];
                        if (returnTypeParameter2 instanceof Class) {
                            returnType = (Class)returnTypeParameter2;
                        } else if (returnTypeParameter2 instanceof ParameterizedType) {
                            returnType = (Class)((ParameterizedType)returnTypeParameter2).getRawType();
                        }
                    }
                } else if (Optional.class.equals((Object)rawType) && (returnTypeParameter = (actualTypeArguments = parameterizedType.getActualTypeArguments())[0]) instanceof Class) {
                    returnType = (Class)returnTypeParameter;
                }
            } else {
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments != null && actualTypeArguments.length == 1) {
                    Type returnTypeParameter = actualTypeArguments[0];
                    if (returnTypeParameter instanceof Class) {
                        returnType = (Class)returnTypeParameter;
                    } else if (returnTypeParameter instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)returnTypeParameter).getRawType();
                    } else if (returnTypeParameter instanceof GenericArrayType) {
                        Class componentType = (Class)((GenericArrayType)returnTypeParameter).getGenericComponentType();
                        returnType = Array.newInstance(componentType, 0).getClass();
                    }
                }
            }
        }
        return returnType;
    }

    private SqlSource getSqlSourceFromAnnotations(Method method, Class<?> parameterType, LanguageDriver languageDriver) {
        try {
            Class<? extends Annotation> sqlAnnotationType = this.getSqlAnnotationType(method);
            Class<? extends Annotation> sqlProviderAnnotationType = this.getSqlProviderAnnotationType(method);
            if (sqlAnnotationType != null) {
                if (sqlProviderAnnotationType != null) {
                    throw new BindingException("You cannot supply both a static SQL and SqlProvider to method named " + method.getName());
                }
                Annotation sqlProviderAnnotation = method.getAnnotation(sqlAnnotationType);
                String[] strings = (String[])sqlProviderAnnotation.getClass().getMethod("value", new Class[0]).invoke((Object)sqlProviderAnnotation, new Object[0]);
                return this.buildSqlSourceFromStrings(strings, parameterType, languageDriver);
            }
            if (sqlProviderAnnotationType != null) {
                Annotation sqlProviderAnnotation = method.getAnnotation(sqlProviderAnnotationType);
                return new ProviderSqlSource(this.assistant.getConfiguration(), sqlProviderAnnotation, this.type, method);
            }
            return null;
        }
        catch (Exception var8) {
            throw new BuilderException("Could not find value method on SQL annotation.  Cause: " + var8, (Throwable)var8);
        }
    }

    private SqlSource buildSqlSourceFromStrings(String[] strings, Class<?> parameterTypeClass, LanguageDriver languageDriver) {
        StringBuilder sql = new StringBuilder();
        String[] var5 = strings;
        int var6 = strings.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            String fragment = var5[var7];
            sql.append(fragment);
            sql.append(" ");
        }
        return languageDriver.createSqlSource((Configuration)this.configuration, sql.toString().trim(), parameterTypeClass);
    }

    private SqlCommandType getSqlCommandType(Method method) {
        Class<? extends Annotation> type = this.getSqlAnnotationType(method);
        if (type == null) {
            type = this.getSqlProviderAnnotationType(method);
            if (type == null) {
                return SqlCommandType.UNKNOWN;
            }
            if (type == SelectProvider.class) {
                type = Select.class;
            } else if (type == InsertProvider.class) {
                type = Insert.class;
            } else if (type == UpdateProvider.class) {
                type = Update.class;
            } else if (type == DeleteProvider.class) {
                type = Delete.class;
            }
        }
        return SqlCommandType.valueOf((String)type.getSimpleName().toUpperCase(Locale.ENGLISH));
    }

    private Class<? extends Annotation> getSqlAnnotationType(Method method) {
        return this.chooseAnnotationType(method, SQL_ANNOTATION_TYPES);
    }

    private Class<? extends Annotation> getSqlProviderAnnotationType(Method method) {
        return this.chooseAnnotationType(method, SQL_PROVIDER_ANNOTATION_TYPES);
    }

    private Class<? extends Annotation> chooseAnnotationType(Method method, Set<Class<? extends Annotation>> types) {
        Class<? extends Annotation> type;
        Annotation annotation;
        Iterator<Class<? extends Annotation>> var3 = types.iterator();
        do {
            if (var3.hasNext()) continue;
            return null;
        } while ((annotation = method.getAnnotation(type = var3.next())) == null);
        return type;
    }

    private void applyResults(Result[] results, Class<?> resultType, List<ResultMapping> resultMappings) {
        Result[] var4 = results;
        int var5 = results.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            Result result = var4[var6];
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if (result.id()) {
                flags.add(ResultFlag.ID);
            }
            Class<UnknownTypeHandler> typeHandler = UnknownTypeHandler.class;
            ResultMapping resultMapping = this.assistant.buildResultMapping(resultType, this.nullOrEmpty(result.property()), this.nullOrEmpty(result.column()), result.javaType() == Void.TYPE ? null : result.javaType(), result.jdbcType() == JdbcType.UNDEFINED ? null : result.jdbcType(), this.hasNestedSelect(result) ? this.nestedSelectId(result) : null, (String)null, (String)null, (String)null, typeHandler, flags, (String)null, (String)null, this.isLazy(result));
            resultMappings.add(resultMapping);
        }
    }

    private String nestedSelectId(Result result) {
        String nestedSelect = result.one().select();
        if (nestedSelect.length() < 1) {
            nestedSelect = result.many().select();
        }
        if (!nestedSelect.contains(".")) {
            nestedSelect = this.type.getName() + "." + nestedSelect;
        }
        return nestedSelect;
    }

    private boolean isLazy(Result result) {
        boolean isLazy = this.configuration.isLazyLoadingEnabled();
        if (result.one().select().length() > 0 && FetchType.DEFAULT != result.one().fetchType()) {
            isLazy = result.one().fetchType() == FetchType.LAZY;
        } else if (result.many().select().length() > 0 && FetchType.DEFAULT != result.many().fetchType()) {
            isLazy = result.many().fetchType() == FetchType.LAZY;
        }
        return isLazy;
    }

    private boolean hasNestedSelect(Result result) {
        if (result.one().select().length() > 0 && result.many().select().length() > 0) {
            throw new BuilderException("Cannot use both @One and @Many annotations in the same @Result");
        }
        return result.one().select().length() > 0 || result.many().select().length() > 0;
    }

    private void applyConstructorArgs(Arg[] args, Class<?> resultType, List<ResultMapping> resultMappings) {
        Arg[] var4 = args;
        int var5 = args.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            Arg arg = var4[var6];
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            flags.add(ResultFlag.CONSTRUCTOR);
            if (arg.id()) {
                flags.add(ResultFlag.ID);
            }
            Class<UnknownTypeHandler> typeHandler = UnknownTypeHandler.class;
            ResultMapping resultMapping = this.assistant.buildResultMapping(resultType, this.nullOrEmpty(arg.name()), this.nullOrEmpty(arg.column()), arg.javaType() == Void.TYPE ? null : arg.javaType(), arg.jdbcType() == JdbcType.UNDEFINED ? null : arg.jdbcType(), this.nullOrEmpty(arg.select()), this.nullOrEmpty(arg.resultMap()), (String)null, this.nullOrEmpty(arg.columnPrefix()), typeHandler, flags, (String)null, (String)null, false);
            resultMappings.add(resultMapping);
        }
    }

    private String nullOrEmpty(String value) {
        return value != null && value.trim().length() != 0 ? value : null;
    }

    private Result[] resultsIf(Results results) {
        return results == null ? new Result[]{} : results.value();
    }

    private Arg[] argsIf(ConstructorArgs args) {
        return args == null ? new Arg[]{} : args.value();
    }

    private KeyGenerator handleSelectKeyAnnotation(SelectKey selectKeyAnnotation, String baseStatementId, Class<?> parameterTypeClass, LanguageDriver languageDriver) {
        String id = baseStatementId + "!selectKey";
        Class resultTypeClass = selectKeyAnnotation.resultType();
        StatementType statementType = selectKeyAnnotation.statementType();
        String keyProperty = selectKeyAnnotation.keyProperty();
        String keyColumn = selectKeyAnnotation.keyColumn();
        boolean executeBefore = selectKeyAnnotation.before();
        boolean useCache = false;
        NoKeyGenerator keyGenerator = NoKeyGenerator.INSTANCE;
        Integer fetchSize = null;
        Integer timeout = null;
        boolean flushCache = false;
        String parameterMap = null;
        String resultMap = null;
        ResultSetType resultSetTypeEnum = null;
        SqlSource sqlSource = this.buildSqlSourceFromStrings(selectKeyAnnotation.statement(), parameterTypeClass, languageDriver);
        SqlCommandType sqlCommandType = SqlCommandType.SELECT;
        this.assistant.addMappedStatement(id, sqlSource, statementType, sqlCommandType, fetchSize, timeout, parameterMap, parameterTypeClass, resultMap, resultTypeClass, resultSetTypeEnum, flushCache, useCache, false, (KeyGenerator)keyGenerator, keyProperty, keyColumn, (String)null, languageDriver, (String)null);
        id = this.assistant.applyCurrentNamespace(id, false);
        MappedStatement keyStatement = this.configuration.getMappedStatement(id, false);
        SelectKeyGenerator answer = new SelectKeyGenerator(keyStatement, executeBefore);
        this.configuration.addKeyGenerator(id, (KeyGenerator)answer);
        return answer;
    }

    static {
        SQL_ANNOTATION_TYPES.add(Select.class);
        SQL_ANNOTATION_TYPES.add(Insert.class);
        SQL_ANNOTATION_TYPES.add(Update.class);
        SQL_ANNOTATION_TYPES.add(Delete.class);
        SQL_PROVIDER_ANNOTATION_TYPES.add(SelectProvider.class);
        SQL_PROVIDER_ANNOTATION_TYPES.add(InsertProvider.class);
        SQL_PROVIDER_ANNOTATION_TYPES.add(UpdateProvider.class);
        SQL_PROVIDER_ANNOTATION_TYPES.add(DeleteProvider.class);
    }
}

