/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.module;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import com.rabbit.common.utils.StringUtils;
import com.rabbit.core.annotation.Create;
import com.rabbit.core.annotation.Id;
import com.rabbit.core.annotation.Update;
import com.rabbit.core.bean.TableFieldInfo;
import com.rabbit.core.bean.TableInfo;
import com.rabbit.core.constructor.DeleteWrapper;
import com.rabbit.core.constructor.UpdateWrapper;
import com.rabbit.core.enumation.PrimaryKey;
import com.rabbit.core.parse.ParseClass2TableInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class RabbitDefaultParameterHandler
extends DefaultParameterHandler {
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final MappedStatement mappedStatement;
    private final Object parameterObject;
    private final BoundSql boundSql;
    private final Configuration configuration;

    public RabbitDefaultParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) throws InvocationTargetException, IllegalAccessException {
        super(mappedStatement, parameterObject, boundSql);
        Field primaryKey;
        this.mappedStatement = mappedStatement;
        this.configuration = mappedStatement.getConfiguration();
        this.typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        this.parameterObject = parameterObject;
        this.boundSql = boundSql;
        Class<?> parameterClass = null;
        List objectList = new ArrayList<Object>();
        if (parameterObject instanceof Map) {
            Map paramMap = (Map)parameterObject;
            Iterator iterator = paramMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry key = iterator.next();
                if (key.getValue() instanceof List) {
                    objectList = (List)key.getValue();
                } else {
                    objectList.add(key.getValue());
                }
            }
            if (objectList.size() > 0) {
                parameterClass = objectList.get(0) != null ? objectList.get(0).getClass() : null;
            }
        } else {
            objectList.add(parameterObject);
            parameterClass = parameterObject.getClass();
        }
        if (mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE || mappedStatement.getSqlCommandType() == SqlCommandType.DELETE) {
            if (parameterObject instanceof UpdateWrapper) {
                UpdateWrapper updateWrapper = (UpdateWrapper)parameterObject;
                updateWrapper.setQueryWrapper(updateWrapper.getValMap());
            } else if (parameterObject instanceof DeleteWrapper) {
                DeleteWrapper deleteWrapper = (DeleteWrapper)parameterObject;
                deleteWrapper.setQueryWrapper(deleteWrapper.getValMap());
            }
        }
        if (ObjectUtils.isEmpty(parameterClass)) {
            return;
        }
        TableInfo tableInfo = ParseClass2TableInfo.getTableInfo(parameterClass);
        if (ObjectUtils.isNotEmpty((Object)tableInfo)) {
            Map<Class<? extends Annotation>, Method> fillMethodMap = tableInfo.getFillMethods();
            Method createMethod = fillMethodMap.get(Create.class);
            Method updateMethod = fillMethodMap.get(Update.class);
            if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT && ObjectUtils.isNotEmpty((Object)createMethod)) {
                createMethod.setAccessible(true);
                for (Object item : objectList) {
                    createMethod.invoke(item, new Object[0]);
                }
            }
            if (mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE && ObjectUtils.isNotEmpty((Object)updateMethod)) {
                updateMethod.setAccessible(true);
                for (Object item : objectList) {
                    updateMethod.invoke(item, new Object[0]);
                }
            }
        }
        Field field = primaryKey = Objects.isNull(tableInfo) ? null : tableInfo.getPrimaryKey();
        if (Objects.nonNull(primaryKey) && mappedStatement.getSqlCommandType() == SqlCommandType.INSERT) {
            Id id = primaryKey.getAnnotation(Id.class);
            PrimaryKey pkEnum = id.generateType();
            Object idValue = null;
            if (id.isKeyGenerator() && !id.isIncrementColumn() && ObjectUtils.isNotEmpty((Object)pkEnum)) {
                for (Object item : objectList) {
                    switch (pkEnum) {
                        case UUID32: {
                            idValue = IdUtil.simpleUUID();
                            break;
                        }
                        case UUID36: {
                            idValue = IdUtil.randomUUID();
                            break;
                        }
                        case OBJECTID: {
                            idValue = IdUtil.objectId();
                            break;
                        }
                        case SNOWFLAKE: {
                            Snowflake snowflake = IdUtil.getSnowflake((long)id.workerId(), (long)id.datacenterId());
                            idValue = snowflake.nextId();
                            break;
                        }
                        case UN_KNOWN: {
                            return;
                        }
                    }
                    try {
                        Map<String, TableFieldInfo> fieldInfoMap = tableInfo.getColumnMap();
                        Method setPrimaryKey = item.getClass().getMethod("set" + StringUtils.capitalize((String)primaryKey.getName()), fieldInfoMap.get(primaryKey.getName()).getPropertyType());
                        setPrimaryKey.setAccessible(true);
                        setPrimaryKey.invoke(item, idValue);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public Object getParameterObject() {
        return this.parameterObject;
    }

    public void setParameters(PreparedStatement ps) {
        ErrorContext.instance().activity("setting parameters").object(this.mappedStatement.getParameterMap().getId());
        List parameterMappings = this.boundSql.getParameterMappings();
        if (parameterMappings != null) {
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (this.boundSql.hasAdditionalParameter(propertyName)) {
                    value = this.boundSql.getAdditionalParameter(propertyName);
                } else if (this.parameterObject == null) {
                    value = null;
                } else if (this.typeHandlerRegistry.hasTypeHandler(this.parameterObject.getClass())) {
                    value = this.parameterObject;
                } else {
                    MetaObject metaObject = this.configuration.newMetaObject(this.parameterObject);
                    value = metaObject.getValue(propertyName);
                }
                TypeHandler typeHandler = parameterMapping.getTypeHandler();
                JdbcType jdbcType = parameterMapping.getJdbcType();
                if (value == null && jdbcType == null) {
                    jdbcType = this.configuration.getJdbcTypeForNull();
                }
                try {
                    typeHandler.setParameter(ps, i + 1, value, jdbcType);
                    continue;
                }
                catch (SQLException | TypeException var10) {
                    throw new TypeException("Could not set parameters for mapping: " + parameterMapping + ". Cause: " + var10, var10);
                }
            }
        }
    }
}

