/*
 * Decompiled with CFR 0.152.
 */
package com.rabbit.core.module;

import com.rabbit.core.config.RabbitConfig;
import com.rabbit.core.module.RabbitMapperRegistry;
import com.rabbit.core.module.RabbitXMLLanguageDriver;
import com.rabbit.core.typehandler.IEnumTypeHandler;
import com.rabbit.core.typehandler.StringEnumTypeHandler;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.executor.BatchExecutor;
import org.apache.ibatis.executor.CachingExecutor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ReuseExecutor;
import org.apache.ibatis.executor.SimpleExecutor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.transaction.Transaction;

public class RabbitConfiguration
extends Configuration {
    private static final Log logger = LogFactory.getLog(RabbitConfiguration.class);
    RabbitMapperRegistry mybatisMapperRegistry = new RabbitMapperRegistry(this);
    private RabbitConfig globalConfig;

    public RabbitConfiguration(Environment environment) {
        this();
        this.environment = environment;
    }

    public RabbitConfiguration() {
        this.mapUnderscoreToCamelCase = true;
        this.languageRegistry.setDefaultDriverClass(RabbitXMLLanguageDriver.class);
        this.typeHandlerRegistry.register(IEnumTypeHandler.class);
        this.typeHandlerRegistry.register(StringEnumTypeHandler.class);
    }

    public void addMappedStatement(MappedStatement ms) {
        logger.debug("addMappedStatement: " + ms.getId());
        if (this.mappedStatements.containsKey(ms.getId())) {
            logger.error("mapper[" + ms.getId() + "] is ignored, because it exists, maybe from xml file");
            return;
        }
        super.addMappedStatement(ms);
    }

    public MapperRegistry getMapperRegistry() {
        return this.mybatisMapperRegistry;
    }

    public <T> void addMapper(Class<T> type) {
        logger.debug("addMapper: " + type.getName());
        this.mybatisMapperRegistry.addMapper(type);
    }

    public void addMappers(String packageName, Class<?> superType) {
        this.mybatisMapperRegistry.addMappers(packageName, superType);
    }

    public void addMappers(String packageName) {
        this.mybatisMapperRegistry.addMappers(packageName);
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        return this.mybatisMapperRegistry.getMapper(type, sqlSession);
    }

    public boolean hasMapper(Class<?> type) {
        return this.mybatisMapperRegistry.hasMapper(type);
    }

    public void setDefaultScriptingLanguage(Class<? extends LanguageDriver> driver) {
        if (driver == null) {
            driver = RabbitXMLLanguageDriver.class;
        }
        this.getLanguageRegistry().setDefaultDriverClass(driver);
    }

    public Executor newExecutor(Transaction transaction, ExecutorType executorType) {
        executorType = executorType == null ? this.defaultExecutorType : executorType;
        ExecutorType executorType2 = executorType = executorType == null ? ExecutorType.SIMPLE : executorType;
        Object executor = ExecutorType.BATCH == executorType ? new BatchExecutor((Configuration)this, transaction) : (ExecutorType.REUSE == executorType ? new ReuseExecutor((Configuration)this, transaction) : new SimpleExecutor((Configuration)this, transaction));
        if (this.cacheEnabled) {
            executor = new CachingExecutor((Executor)executor);
        }
        return (Executor)this.interceptorChain.pluginAll(executor);
    }

    public void setGlobalConfig(RabbitConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public RabbitConfig getGlobalConfig() {
        return this.globalConfig;
    }
}

